/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.AnonymousAccess;
import org.glowroot.config.UserInterfaceConfigBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;

@ParametersAreNonnullByDefault
@Immutable
public final class UserInterfaceConfig
extends UserInterfaceConfigBase {
    private final int port;
    private final String adminPasswordHash;
    private final String readOnlyPasswordHash;
    private final AnonymousAccess anonymousAccess;
    private final int sessionTimeoutMinutes;
    private final String version;

    private UserInterfaceConfig(Builder builder) {
        this.port = builder.portIsSet() ? builder.port : super.port();
        this.adminPasswordHash = builder.adminPasswordHash != null ? builder.adminPasswordHash : Preconditions.checkNotNull(super.adminPasswordHash());
        this.readOnlyPasswordHash = builder.readOnlyPasswordHash != null ? builder.readOnlyPasswordHash : Preconditions.checkNotNull(super.readOnlyPasswordHash());
        this.anonymousAccess = builder.anonymousAccess != null ? builder.anonymousAccess : Preconditions.checkNotNull(super.anonymousAccess());
        this.sessionTimeoutMinutes = builder.sessionTimeoutMinutesIsSet() ? builder.sessionTimeoutMinutes : super.sessionTimeoutMinutes();
        this.version = Preconditions.checkNotNull(super.version());
    }

    private UserInterfaceConfig(int port, String adminPasswordHash, String readOnlyPasswordHash, AnonymousAccess anonymousAccess, int sessionTimeoutMinutes) {
        this.port = port;
        this.adminPasswordHash = adminPasswordHash;
        this.readOnlyPasswordHash = readOnlyPasswordHash;
        this.anonymousAccess = anonymousAccess;
        this.sessionTimeoutMinutes = sessionTimeoutMinutes;
        this.version = Preconditions.checkNotNull(super.version());
    }

    @Override
    @JsonProperty(value="port")
    public int port() {
        return this.port;
    }

    @Override
    @JsonProperty(value="adminPasswordHash")
    public String adminPasswordHash() {
        return this.adminPasswordHash;
    }

    @Override
    @JsonProperty(value="readOnlyPasswordHash")
    public String readOnlyPasswordHash() {
        return this.readOnlyPasswordHash;
    }

    @Override
    @JsonProperty(value="anonymousAccess")
    public AnonymousAccess anonymousAccess() {
        return this.anonymousAccess;
    }

    @Override
    @JsonProperty(value="sessionTimeoutMinutes")
    public int sessionTimeoutMinutes() {
        return this.sessionTimeoutMinutes;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final UserInterfaceConfig withPort(int value) {
        if (this.port == value) {
            return this;
        }
        int newValue = value;
        return new UserInterfaceConfig(newValue, this.adminPasswordHash, this.readOnlyPasswordHash, this.anonymousAccess, this.sessionTimeoutMinutes);
    }

    public final UserInterfaceConfig withAdminPasswordHash(String value) {
        if (this.adminPasswordHash == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new UserInterfaceConfig(this.port, newValue, this.readOnlyPasswordHash, this.anonymousAccess, this.sessionTimeoutMinutes);
    }

    public final UserInterfaceConfig withReadOnlyPasswordHash(String value) {
        if (this.readOnlyPasswordHash == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new UserInterfaceConfig(this.port, this.adminPasswordHash, newValue, this.anonymousAccess, this.sessionTimeoutMinutes);
    }

    public final UserInterfaceConfig withAnonymousAccess(AnonymousAccess value) {
        if (this.anonymousAccess == value) {
            return this;
        }
        AnonymousAccess newValue = Preconditions.checkNotNull(value);
        return new UserInterfaceConfig(this.port, this.adminPasswordHash, this.readOnlyPasswordHash, newValue, this.sessionTimeoutMinutes);
    }

    public final UserInterfaceConfig withSessionTimeoutMinutes(int value) {
        if (this.sessionTimeoutMinutes == value) {
            return this;
        }
        int newValue = value;
        return new UserInterfaceConfig(this.port, this.adminPasswordHash, this.readOnlyPasswordHash, this.anonymousAccess, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof UserInterfaceConfig && this.equalTo((UserInterfaceConfig)another);
    }

    private boolean equalTo(UserInterfaceConfig another) {
        return this.port == another.port && this.adminPasswordHash.equals(another.adminPasswordHash) && this.readOnlyPasswordHash.equals(another.readOnlyPasswordHash) && this.anonymousAccess.equals((Object)another.anonymousAccess) && this.sessionTimeoutMinutes == another.sessionTimeoutMinutes && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.port;
        h = h * 17 + this.adminPasswordHash.hashCode();
        h = h * 17 + this.readOnlyPasswordHash.hashCode();
        h = h * 17 + this.anonymousAccess.hashCode();
        h = h * 17 + this.sessionTimeoutMinutes;
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("UserInterfaceConfig").add("port", this.port).add("adminPasswordHash", this.adminPasswordHash).add("readOnlyPasswordHash", this.readOnlyPasswordHash).add("anonymousAccess", (Object)this.anonymousAccess).add("sessionTimeoutMinutes", this.sessionTimeoutMinutes).add("version", this.version).toString();
    }

    @JsonCreator
    public static UserInterfaceConfig fromAllAttributes(@JsonProperty(value="port") @Nullable Integer port, @JsonProperty(value="adminPasswordHash") @Nullable String adminPasswordHash, @JsonProperty(value="readOnlyPasswordHash") @Nullable String readOnlyPasswordHash, @JsonProperty(value="anonymousAccess") @Nullable AnonymousAccess anonymousAccess, @JsonProperty(value="sessionTimeoutMinutes") @Nullable Integer sessionTimeoutMinutes) {
        Builder builder = UserInterfaceConfig.builder();
        if (port != null) {
            builder.port(port);
        }
        if (adminPasswordHash != null) {
            builder.adminPasswordHash(adminPasswordHash);
        }
        if (readOnlyPasswordHash != null) {
            builder.readOnlyPasswordHash(readOnlyPasswordHash);
        }
        if (anonymousAccess != null) {
            builder.anonymousAccess(anonymousAccess);
        }
        if (sessionTimeoutMinutes != null) {
            builder.sessionTimeoutMinutes(sessionTimeoutMinutes);
        }
        return builder.build();
    }

    public static UserInterfaceConfig copyOf(UserInterfaceConfigBase instance) {
        if (instance instanceof UserInterfaceConfig) {
            return (UserInterfaceConfig)instance;
        }
        return UserInterfaceConfig.builder().port(instance.port()).adminPasswordHash(instance.adminPasswordHash()).readOnlyPasswordHash(instance.readOnlyPasswordHash()).anonymousAccess(instance.anonymousAccess()).sessionTimeoutMinutes(instance.sessionTimeoutMinutes()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long NONDEFAULT_BIT_PORT = 1L;
        private static final long NONDEFAULT_BIT_ADMIN_PASSWORD_HASH = 2L;
        private static final long NONDEFAULT_BIT_READ_ONLY_PASSWORD_HASH = 4L;
        private static final long NONDEFAULT_BIT_ANONYMOUS_ACCESS = 8L;
        private static final long NONDEFAULT_BIT_SESSION_TIMEOUT_MINUTES = 16L;
        private long nondefaultBitset;
        private int port;
        @Nullable
        private String adminPasswordHash;
        @Nullable
        private String readOnlyPasswordHash;
        @Nullable
        private AnonymousAccess anonymousAccess;
        private int sessionTimeoutMinutes;

        private Builder() {
        }

        public final Builder port(int port) {
            this.checkNotIsSet(this.portIsSet(), "port");
            this.port = port;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder adminPasswordHash(String adminPasswordHash) {
            this.checkNotIsSet(this.adminPasswordHashIsSet(), "adminPasswordHash");
            this.adminPasswordHash = Preconditions.checkNotNull(adminPasswordHash);
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder readOnlyPasswordHash(String readOnlyPasswordHash) {
            this.checkNotIsSet(this.readOnlyPasswordHashIsSet(), "readOnlyPasswordHash");
            this.readOnlyPasswordHash = Preconditions.checkNotNull(readOnlyPasswordHash);
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder anonymousAccess(AnonymousAccess anonymousAccess) {
            this.checkNotIsSet(this.anonymousAccessIsSet(), "anonymousAccess");
            this.anonymousAccess = Preconditions.checkNotNull(anonymousAccess);
            this.nondefaultBitset |= 8L;
            return this;
        }

        public final Builder sessionTimeoutMinutes(int sessionTimeoutMinutes) {
            this.checkNotIsSet(this.sessionTimeoutMinutesIsSet(), "sessionTimeoutMinutes");
            this.sessionTimeoutMinutes = sessionTimeoutMinutes;
            this.nondefaultBitset |= 0x10L;
            return this;
        }

        public UserInterfaceConfig build() {
            return new UserInterfaceConfig(this);
        }

        private boolean portIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean adminPasswordHashIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean readOnlyPasswordHashIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean anonymousAccessIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }

        private boolean sessionTimeoutMinutesIsSet() {
            return (this.nondefaultBitset & 0x10L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of UserInterfaceConfig is strict, attribute is already set: ".concat(name));
            }
        }
    }
}

