/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.UserRecordingConfigBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
public final class UserRecordingConfig
extends UserRecordingConfigBase {
    private final boolean enabled;
    private final String user;
    private final int profileIntervalMillis;
    private final String version;

    private UserRecordingConfig(Builder builder) {
        this.enabled = builder.enabledIsSet() ? builder.enabled : super.enabled();
        this.user = builder.user != null ? builder.user : Preconditions.checkNotNull(super.user());
        this.profileIntervalMillis = builder.profileIntervalMillisIsSet() ? builder.profileIntervalMillis : super.profileIntervalMillis();
        this.version = Preconditions.checkNotNull(super.version());
    }

    private UserRecordingConfig(boolean enabled, String user, int profileIntervalMillis) {
        this.enabled = enabled;
        this.user = user;
        this.profileIntervalMillis = profileIntervalMillis;
        this.version = Preconditions.checkNotNull(super.version());
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="user")
    public String user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="profileIntervalMillis")
    public int profileIntervalMillis() {
        return this.profileIntervalMillis;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final UserRecordingConfig withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        boolean newValue = value;
        return new UserRecordingConfig(newValue, this.user, this.profileIntervalMillis);
    }

    public final UserRecordingConfig withUser(String value) {
        if (this.user == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new UserRecordingConfig(this.enabled, newValue, this.profileIntervalMillis);
    }

    public final UserRecordingConfig withProfileIntervalMillis(int value) {
        if (this.profileIntervalMillis == value) {
            return this;
        }
        int newValue = value;
        return new UserRecordingConfig(this.enabled, this.user, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof UserRecordingConfig && this.equalTo((UserRecordingConfig)another);
    }

    private boolean equalTo(UserRecordingConfig another) {
        return this.enabled == another.enabled && this.user.equals(another.user) && this.profileIntervalMillis == another.profileIntervalMillis && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode(this.enabled);
        h = h * 17 + this.user.hashCode();
        h = h * 17 + this.profileIntervalMillis;
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("UserRecordingConfig").add("enabled", this.enabled).add("user", this.user).add("profileIntervalMillis", this.profileIntervalMillis).add("version", this.version).toString();
    }

    @JsonCreator
    public static UserRecordingConfig fromAllAttributes(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="user") @Nullable String user, @JsonProperty(value="profileIntervalMillis") @Nullable Integer profileIntervalMillis) {
        Builder builder = UserRecordingConfig.builder();
        if (enabled != null) {
            builder.enabled(enabled);
        }
        if (user != null) {
            builder.user(user);
        }
        if (profileIntervalMillis != null) {
            builder.profileIntervalMillis(profileIntervalMillis);
        }
        return builder.build();
    }

    public static UserRecordingConfig copyOf(UserRecordingConfigBase instance) {
        if (instance instanceof UserRecordingConfig) {
            return (UserRecordingConfig)instance;
        }
        return UserRecordingConfig.builder().enabled(instance.enabled()).user(instance.user()).profileIntervalMillis(instance.profileIntervalMillis()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long NONDEFAULT_BIT_ENABLED = 1L;
        private static final long NONDEFAULT_BIT_USER = 2L;
        private static final long NONDEFAULT_BIT_PROFILE_INTERVAL_MILLIS = 4L;
        private long nondefaultBitset;
        private boolean enabled;
        @Nullable
        private String user;
        private int profileIntervalMillis;

        private Builder() {
        }

        public final Builder enabled(boolean enabled) {
            this.checkNotIsSet(this.enabledIsSet(), "enabled");
            this.enabled = enabled;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder user(String user) {
            this.checkNotIsSet(this.userIsSet(), "user");
            this.user = Preconditions.checkNotNull(user);
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder profileIntervalMillis(int profileIntervalMillis) {
            this.checkNotIsSet(this.profileIntervalMillisIsSet(), "profileIntervalMillis");
            this.profileIntervalMillis = profileIntervalMillis;
            this.nondefaultBitset |= 4L;
            return this;
        }

        public UserRecordingConfig build() {
            return new UserRecordingConfig(this);
        }

        private boolean enabledIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean userIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean profileIntervalMillisIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of UserRecordingConfig is strict, attribute is already set: ".concat(name));
            }
        }
    }
}

