/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class AlertConfig {
    @Nullable
    private String transactionType;
    private double percentile;
    private int timePeriodMinutes;
    private int thresholdMillis;
    private int minTransactionCount;
    private List<String> emailAddresses = Lists.newArrayList();
    @Nullable
    private final String version;

    public AlertConfig() {
        this.version = null;
    }

    private AlertConfig(String version) {
        this.version = version;
    }

    @Nullable
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public double getPercentile() {
        return this.percentile;
    }

    public void setPercentile(double percentile) {
        this.percentile = percentile;
    }

    public int getTimePeriodMinutes() {
        return this.timePeriodMinutes;
    }

    public void setTimePeriodMinutes(int timePeriodMinutes) {
        this.timePeriodMinutes = timePeriodMinutes;
    }

    public int getThresholdMillis() {
        return this.thresholdMillis;
    }

    public void setThresholdMillis(int thresholdMillis) {
        this.thresholdMillis = thresholdMillis;
    }

    public int getMinTransactionCount() {
        return this.minTransactionCount;
    }

    public void setMinTransactionCount(int minTransactionCount) {
        this.minTransactionCount = minTransactionCount;
    }

    public List<String> getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof AlertConfig) {
            AlertConfig that = (AlertConfig)obj;
            return Objects.equal((Object)this.transactionType, (Object)that.transactionType) && Objects.equal((Object)this.percentile, (Object)that.percentile) && Objects.equal((Object)this.timePeriodMinutes, (Object)that.timePeriodMinutes) && Objects.equal((Object)this.thresholdMillis, (Object)that.thresholdMillis) && Objects.equal((Object)this.minTransactionCount, (Object)that.minTransactionCount) && Objects.equal(this.emailAddresses, that.emailAddresses);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.transactionType, this.percentile, this.timePeriodMinutes, this.thresholdMillis, this.minTransactionCount, this.emailAddresses});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("transactionType", (Object)this.transactionType).add("percentile", this.percentile).add("timePeriodMinutes", this.timePeriodMinutes).add("thresholdMillis", this.thresholdMillis).add("minTransactionCount", this.minTransactionCount).add("emailAddresses", this.emailAddresses).add("version", (Object)this.version).toString();
    }

    @JsonCreator
    static AlertConfig readValue(@JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="percentile") @Nullable Double percentile, @JsonProperty(value="timePeriodMinutes") @Nullable Integer timePeriodMinutes, @JsonProperty(value="thresholdMillis") @Nullable Integer thresholdMillis, @JsonProperty(value="minTransactionCount") @Nullable Integer minTransactionCount, @JsonProperty(value="emailAddresses") @Nullable List<String> emailAddresses, @JsonProperty(value="version") @Nullable String version) throws JsonMappingException {
        ObjectMappers.checkRequiredProperty(transactionType, "transactionType");
        ObjectMappers.checkRequiredProperty(percentile, "percentile");
        ObjectMappers.checkRequiredProperty(timePeriodMinutes, "timePeriodMinutes");
        ObjectMappers.checkRequiredProperty(thresholdMillis, "thresholdMillis");
        ObjectMappers.checkRequiredProperty(minTransactionCount, "minTransactionCount");
        ObjectMappers.checkRequiredProperty(emailAddresses, "emailAddresses");
        ObjectMappers.checkRequiredProperty(version, "version");
        AlertConfig config = new AlertConfig(version);
        config.setTransactionType(transactionType);
        config.setPercentile(percentile);
        config.setTimePeriodMinutes(timePeriodMinutes);
        config.setThresholdMillis(thresholdMillis);
        config.setMinTransactionCount(minTransactionCount);
        config.setEmailAddresses(emailAddresses);
        return config;
    }
}

