/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.config;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.container.common.HttpClient;
import org.glowroot.container.common.ObjectMappers;
import org.glowroot.container.config.AdvancedConfig;
import org.glowroot.container.config.AlertConfig;
import org.glowroot.container.config.GaugeConfig;
import org.glowroot.container.config.InstrumentationConfig;
import org.glowroot.container.config.PluginConfig;
import org.glowroot.container.config.SmtpConfig;
import org.glowroot.container.config.StorageConfig;
import org.glowroot.container.config.TransactionConfig;
import org.glowroot.container.config.UserInterfaceConfig;
import org.glowroot.container.config.UserRecordingConfig;

public class ConfigService {
    private static final ObjectMapper mapper = ObjectMappers.create();
    private final HttpClient httpClient;
    private final GetUiPortCommand getUiPortCommand;

    public ConfigService(HttpClient httpClient, GetUiPortCommand getUiPortCommand) {
        this.httpClient = httpClient;
        this.getUiPortCommand = getUiPortCommand;
    }

    public void setPluginProperty(String pluginId, String propertyName, @Nullable Object propertyValue) throws Exception {
        PluginConfig config = this.getPluginConfig(pluginId);
        if (config == null) {
            throw new IllegalStateException("Plugin not found for pluginId: " + pluginId);
        }
        config.setProperty(propertyName, propertyValue);
        this.updatePluginConfig(pluginId, config);
    }

    public TransactionConfig getTransactionConfig() throws Exception {
        return this.getConfig("/backend/config/transaction", TransactionConfig.class);
    }

    public void updateTransactionConfig(TransactionConfig config) throws Exception {
        this.httpClient.post("/backend/config/transaction", mapper.writeValueAsString((Object)config));
    }

    public UserInterfaceConfig getUserInterfaceConfig() throws Exception {
        return this.getConfig("/backend/config/ui", UserInterfaceConfig.class);
    }

    public void updateUserInterfaceConfig(UserInterfaceConfig config) throws Exception {
        String response = this.httpClient.post("/backend/config/ui", mapper.writeValueAsString((Object)config));
        JsonNode node = mapper.readTree(response);
        JsonNode currentPasswordIncorrectNode = node.get("currentPasswordIncorrect");
        if (currentPasswordIncorrectNode != null && currentPasswordIncorrectNode.asBoolean()) {
            throw new CurrentPasswordIncorrectException();
        }
        JsonNode portChangeFailedNode = node.get("portChangeFailed");
        if (portChangeFailedNode != null && portChangeFailedNode.asBoolean()) {
            throw new PortChangeFailedException();
        }
        this.httpClient.updateUiPort(this.getUiPortCommand.getUiPort());
    }

    public StorageConfig getStorageConfig() throws Exception {
        return this.getConfig("/backend/config/storage", StorageConfig.class);
    }

    public void updateStorageConfig(StorageConfig config) throws Exception {
        this.httpClient.post("/backend/config/storage", mapper.writeValueAsString((Object)config));
    }

    public SmtpConfig getSmtpConfig() throws Exception {
        return this.getConfig("/backend/config/smtp", SmtpConfig.class);
    }

    public void updateSmtpConfig(SmtpConfig config) throws Exception {
        this.httpClient.post("/backend/config/smtp", mapper.writeValueAsString((Object)config));
    }

    public UserRecordingConfig getUserRecordingConfig() throws Exception {
        return this.getConfig("/backend/config/user-recording", UserRecordingConfig.class);
    }

    public void updateUserRecordingConfig(UserRecordingConfig config) throws Exception {
        this.httpClient.post("/backend/config/user-recording", mapper.writeValueAsString((Object)config));
    }

    public AdvancedConfig getAdvancedConfig() throws Exception {
        return this.getConfig("/backend/config/advanced", AdvancedConfig.class);
    }

    public void updateAdvancedConfig(AdvancedConfig config) throws Exception {
        this.httpClient.post("/backend/config/advanced", mapper.writeValueAsString((Object)config));
    }

    @Nullable
    public PluginConfig getPluginConfig(String pluginId) throws Exception {
        return this.getConfig("/backend/config/plugin/" + pluginId, PluginConfig.class);
    }

    public void updatePluginConfig(String pluginId, PluginConfig config) throws Exception {
        this.httpClient.post("/backend/config/plugin/" + pluginId, mapper.writeValueAsString((Object)config));
    }

    public InstrumentationConfig getInstrumentationConfig(String version) throws Exception {
        String response = this.httpClient.get("/backend/config/instrumentation/" + version);
        ObjectNode rootNode = ObjectMappers.readRequiredValue(mapper, response, ObjectNode.class);
        ObjectNode configNode = (ObjectNode)ObjectMappers.getRequiredChildNode((JsonNode)rootNode, "config");
        return (InstrumentationConfig)mapper.readValue(mapper.treeAsTokens((TreeNode)configNode), (TypeReference)new TypeReference<InstrumentationConfig>(){});
    }

    public List<InstrumentationConfig> getInstrumentationConfigs() throws Exception {
        String response = this.httpClient.get("/backend/config/instrumentation");
        ObjectNode rootNode = ObjectMappers.readRequiredValue(mapper, response, ObjectNode.class);
        JsonNode configsNode = ObjectMappers.getRequiredChildNode((JsonNode)rootNode, "configs");
        return (List)mapper.readValue(mapper.treeAsTokens((TreeNode)configsNode), (TypeReference)new TypeReference<List<InstrumentationConfig>>(){});
    }

    public InstrumentationConfig addInstrumentationConfig(InstrumentationConfig config) throws Exception {
        String response = this.httpClient.post("/backend/config/instrumentation/add", mapper.writeValueAsString((Object)config));
        ObjectNode rootNode = ObjectMappers.readRequiredValue(mapper, response, ObjectNode.class);
        ObjectNode configNode = (ObjectNode)ObjectMappers.getRequiredChildNode((JsonNode)rootNode, "config");
        return (InstrumentationConfig)mapper.readValue(mapper.treeAsTokens((TreeNode)configNode), InstrumentationConfig.class);
    }

    public InstrumentationConfig updateInstrumentationConfig(InstrumentationConfig config) throws Exception {
        String response = this.httpClient.post("/backend/config/instrumentation/update", mapper.writeValueAsString((Object)config));
        ObjectNode rootNode = ObjectMappers.readRequiredValue(mapper, response, ObjectNode.class);
        ObjectNode configNode = (ObjectNode)ObjectMappers.getRequiredChildNode((JsonNode)rootNode, "config");
        return (InstrumentationConfig)mapper.readValue(mapper.treeAsTokens((TreeNode)configNode), InstrumentationConfig.class);
    }

    public void removeInstrumentationConfig(String version) throws Exception {
        this.httpClient.post("/backend/config/instrumentation/remove", mapper.writeValueAsString((Object)version));
    }

    public GaugeConfig getGaugeConfig(String version) throws Exception {
        String response = this.httpClient.get("/backend/config/gauges/" + version);
        ObjectNode rootNode = ObjectMappers.readRequiredValue(mapper, response, ObjectNode.class);
        ObjectNode configNode = (ObjectNode)ObjectMappers.getRequiredChildNode((JsonNode)rootNode, "config");
        return (GaugeConfig)mapper.readValue(mapper.treeAsTokens((TreeNode)configNode), (TypeReference)new TypeReference<GaugeConfig>(){});
    }

    public List<GaugeConfig> getGaugeConfigs() throws Exception {
        String response = this.httpClient.get("/backend/config/gauges");
        ArrayNode rootNode = ObjectMappers.readRequiredValue(mapper, response, ArrayNode.class);
        ArrayList configs = Lists.newArrayList();
        for (JsonNode childNode : rootNode) {
            ObjectNode configNode = (ObjectNode)ObjectMappers.getRequiredChildNode(childNode, "config");
            configs.add(mapper.readValue(mapper.treeAsTokens((TreeNode)configNode), GaugeConfig.class));
        }
        return configs;
    }

    public GaugeConfig addGaugeConfig(GaugeConfig config) throws Exception {
        String response = this.httpClient.post("/backend/config/gauges/add", mapper.writeValueAsString((Object)config));
        ObjectNode rootNode = ObjectMappers.readRequiredValue(mapper, response, ObjectNode.class);
        ObjectNode configNode = (ObjectNode)ObjectMappers.getRequiredChildNode((JsonNode)rootNode, "config");
        return (GaugeConfig)mapper.readValue(mapper.treeAsTokens((TreeNode)configNode), GaugeConfig.class);
    }

    public GaugeConfig updateGaugeConfig(GaugeConfig config) throws Exception {
        String response = this.httpClient.post("/backend/config/gauges/update", mapper.writeValueAsString((Object)config));
        ObjectNode rootNode = ObjectMappers.readRequiredValue(mapper, response, ObjectNode.class);
        ObjectNode configNode = (ObjectNode)ObjectMappers.getRequiredChildNode((JsonNode)rootNode, "config");
        return (GaugeConfig)mapper.readValue(mapper.treeAsTokens((TreeNode)configNode), GaugeConfig.class);
    }

    public void removeGaugeConfig(String version) throws Exception {
        this.httpClient.post("/backend/config/gauges/remove", mapper.writeValueAsString((Object)version));
    }

    public AlertConfig getAlertConfig(String version) throws Exception {
        String response = this.httpClient.get("/backend/config/alerts/" + version);
        return (AlertConfig)mapper.readValue(response, (TypeReference)new TypeReference<AlertConfig>(){});
    }

    public List<AlertConfig> getAlertConfigs() throws Exception {
        String response = this.httpClient.get("/backend/config/alerts");
        return (List)mapper.readValue(response, (TypeReference)new TypeReference<List<AlertConfig>>(){});
    }

    public AlertConfig addAlertConfig(AlertConfig config) throws Exception {
        String response = this.httpClient.post("/backend/config/alerts/add", mapper.writeValueAsString((Object)config));
        return ObjectMappers.readRequiredValue(mapper, response, AlertConfig.class);
    }

    public AlertConfig updateAlertConfig(AlertConfig config) throws Exception {
        String response = this.httpClient.post("/backend/config/alerts/update", mapper.writeValueAsString((Object)config));
        return ObjectMappers.readRequiredValue(mapper, response, AlertConfig.class);
    }

    public void removeAlertConfig(String version) throws Exception {
        this.httpClient.post("/backend/config/alerts/remove", mapper.writeValueAsString((Object)version));
    }

    public int reweave() throws Exception {
        String response = this.httpClient.post("/backend/admin/reweave", "");
        ObjectNode rootNode = ObjectMappers.readRequiredValue(mapper, response, ObjectNode.class);
        JsonNode classesNode = ObjectMappers.getRequiredChildNode((JsonNode)rootNode, "classes");
        return classesNode.asInt();
    }

    public void compactData() throws Exception {
        this.httpClient.post("/backend/admin/defrag-data", "");
    }

    public void resetAllConfig() throws Exception {
        this.httpClient.post("/backend/admin/reset-all-config", "");
        this.setTransactionSlowThresholdMillis(0);
    }

    public void setTransactionSlowThresholdMillis(int slowThresholdMillis) throws Exception {
        TransactionConfig transactionConfig = this.getTransactionConfig();
        transactionConfig.setSlowThresholdMillis(slowThresholdMillis);
        this.updateTransactionConfig(transactionConfig);
    }

    private <T> T getConfig(String url, Class<T> valueType) throws Exception {
        String response = this.httpClient.get(url);
        ObjectNode rootNode = ObjectMappers.readRequiredValue(mapper, response, ObjectNode.class);
        JsonNode configNode = rootNode.get("config");
        if (configNode == null) {
            configNode = rootNode;
        }
        return (T)mapper.treeToValue((TreeNode)configNode, valueType);
    }

    public class PortChangeFailedException
    extends Exception {
    }

    public class CurrentPasswordIncorrectException
    extends Exception {
    }

    public static interface GetUiPortCommand {
        public int getUiPort() throws Exception;
    }
}

