/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class StorageConfig {
    private List<Integer> rollupExpirationHours = Lists.newArrayList();
    private int traceExpirationHours;
    private List<Integer> rollupCappedDatabaseSizesMb = Lists.newArrayList();
    private int traceCappedDatabaseSizeMb;
    private final String version;

    private StorageConfig(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Integer> getRollupExpirationHours() {
        return this.rollupExpirationHours;
    }

    public void setRollupExpirationHours(List<Integer> rollupExpirationHours) {
        this.rollupExpirationHours = rollupExpirationHours;
    }

    public int getTraceExpirationHours() {
        return this.traceExpirationHours;
    }

    public void setTraceExpirationHours(int traceExpirationHours) {
        this.traceExpirationHours = traceExpirationHours;
    }

    public List<Integer> getRollupCappedDatabaseSizesMb() {
        return this.rollupCappedDatabaseSizesMb;
    }

    public void setRollupCappedDatabaseSizesMb(List<Integer> rollupCappedDatabaseSizesMb) {
        this.rollupCappedDatabaseSizesMb = rollupCappedDatabaseSizesMb;
    }

    public int getTraceCappedDatabaseSizeMb() {
        return this.traceCappedDatabaseSizeMb;
    }

    public void setTraceCappedDatabaseSizeMb(int traceCappedDatabaseSizeMb) {
        this.traceCappedDatabaseSizeMb = traceCappedDatabaseSizeMb;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof StorageConfig) {
            StorageConfig that = (StorageConfig)obj;
            return Objects.equal(this.rollupExpirationHours, that.rollupExpirationHours) && Objects.equal((Object)this.traceExpirationHours, (Object)that.traceExpirationHours) && Objects.equal(this.rollupCappedDatabaseSizesMb, that.rollupCappedDatabaseSizesMb) && Objects.equal((Object)this.traceCappedDatabaseSizeMb, (Object)that.traceCappedDatabaseSizeMb);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rollupExpirationHours, this.traceExpirationHours, this.rollupCappedDatabaseSizesMb, this.traceCappedDatabaseSizeMb});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rollupExpirationHours", this.rollupExpirationHours).add("traceExpirationHours", this.traceExpirationHours).add("rollupCappedDatabaseSizesMb", this.rollupCappedDatabaseSizesMb).add("traceCappedDatabaseSizeMb", this.traceCappedDatabaseSizeMb).add("version", (Object)this.version).toString();
    }

    @JsonCreator
    static StorageConfig readValue(@JsonProperty(value="rollupExpirationHours") @Nullable List<Integer> rollupExpirationHours, @JsonProperty(value="traceExpirationHours") @Nullable Integer traceExpirationHours, @JsonProperty(value="rollupCappedDatabaseSizesMb") @Nullable List<Integer> rollupCappedDatabaseSizesMb, @JsonProperty(value="traceCappedDatabaseSizeMb") @Nullable Integer traceCappedDatabaseSizeMb, @JsonProperty(value="version") @Nullable String version) throws JsonMappingException {
        ObjectMappers.checkRequiredProperty(rollupExpirationHours, "rollupExpirationHours");
        ObjectMappers.checkRequiredProperty(traceExpirationHours, "traceExpirationHours");
        ObjectMappers.checkRequiredProperty(rollupCappedDatabaseSizesMb, "rollupCappedDatabaseSizesMb");
        ObjectMappers.checkRequiredProperty(traceCappedDatabaseSizeMb, "traceCappedDatabaseSizeMb");
        ObjectMappers.checkRequiredProperty(version, "version");
        StorageConfig config = new StorageConfig(version);
        config.setRollupExpirationHours(rollupExpirationHours);
        config.setTraceExpirationHours(traceExpirationHours);
        config.setRollupCappedDatabaseSizesMb(rollupCappedDatabaseSizesMb);
        config.setTraceCappedDatabaseSizeMb(traceCappedDatabaseSizeMb);
        return config;
    }
}

