/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class TransactionConfig {
    private int slowThresholdMillis;
    private int profilingIntervalMillis;
    private String defaultDisplayedTransactionType = "";
    private List<Double> defaultDisplayedPercentiles = Lists.newArrayList();
    private final String version;

    private TransactionConfig(String version) {
        this.version = version;
    }

    public int getSlowThresholdMillis() {
        return this.slowThresholdMillis;
    }

    public void setSlowThresholdMillis(int slowThresholdMillis) {
        this.slowThresholdMillis = slowThresholdMillis;
    }

    public int getProfilingIntervalMillis() {
        return this.profilingIntervalMillis;
    }

    public void setProfilingIntervalMillis(int profilingIntervalMillis) {
        this.profilingIntervalMillis = profilingIntervalMillis;
    }

    public String getDefaultDisplayedTransactionType() {
        return this.defaultDisplayedTransactionType;
    }

    public void setDefaultDisplayedTransactionType(String defaultDisplayedTransactionType) {
        this.defaultDisplayedTransactionType = defaultDisplayedTransactionType;
    }

    public List<Double> getDefaultDisplayedPercentiles() {
        return this.defaultDisplayedPercentiles;
    }

    public void setDefaultDisplayedPercentiles(List<Double> defaultDisplayedPercentiles) {
        this.defaultDisplayedPercentiles = defaultDisplayedPercentiles;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof TransactionConfig) {
            TransactionConfig that = (TransactionConfig)obj;
            return Objects.equal((Object)this.slowThresholdMillis, (Object)that.slowThresholdMillis) && Objects.equal((Object)this.profilingIntervalMillis, (Object)that.profilingIntervalMillis) && Objects.equal((Object)this.defaultDisplayedTransactionType, (Object)that.defaultDisplayedTransactionType) && Objects.equal(this.defaultDisplayedPercentiles, that.defaultDisplayedPercentiles);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.slowThresholdMillis, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, this.defaultDisplayedPercentiles});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("slowThresholdMillis", this.slowThresholdMillis).add("profilingIntervalMillis", this.profilingIntervalMillis).add("defaultDisplayedTransactionType", (Object)this.defaultDisplayedTransactionType).add("defaultDisplayedPercentiles", this.defaultDisplayedPercentiles).add("version", (Object)this.version).toString();
    }

    @JsonCreator
    static TransactionConfig readValue(@JsonProperty(value="slowThresholdMillis") @Nullable Integer slowThresholdMillis, @JsonProperty(value="profilingIntervalMillis") @Nullable Integer profilingIntervalMillis, @JsonProperty(value="defaultDisplayedTransactionType") @Nullable String defaultDisplayedTransactionType, @JsonProperty(value="defaultDisplayedPercentiles") @Nullable List<Double> defaultDisplayedPercentiles, @JsonProperty(value="version") @Nullable String version) throws JsonMappingException {
        ObjectMappers.checkRequiredProperty(slowThresholdMillis, "slowThresholdMillis");
        ObjectMappers.checkRequiredProperty(profilingIntervalMillis, "profilingIntervalMillis");
        ObjectMappers.checkRequiredProperty(defaultDisplayedTransactionType, "defaultDisplayedTransactionType");
        ObjectMappers.checkRequiredProperty(defaultDisplayedPercentiles, "defaultDisplayedPercentiles");
        ObjectMappers.checkRequiredProperty(version, "version");
        TransactionConfig config = new TransactionConfig(version);
        config.setSlowThresholdMillis(slowThresholdMillis);
        config.setProfilingIntervalMillis(profilingIntervalMillis);
        config.setDefaultDisplayedTransactionType(defaultDisplayedTransactionType);
        config.setDefaultDisplayedPercentiles(defaultDisplayedPercentiles);
        return config;
    }
}

