/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.google.common.reflect.Reflection;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.glowroot.common.ClassNames;
import org.glowroot.plugin.api.Agent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedClassLoader
extends ClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(IsolatedClassLoader.class);
    private final ImmutableList<Class<?>> bridgeClasses;
    private final ImmutableList<String> excludePackages;
    private final Map<String, Class<?>> classes = Maps.newConcurrentMap();

    IsolatedClassLoader(List<Class<?>> bridgeClasses, List<String> excludePackages) {
        super(IsolatedClassLoader.class.getClassLoader());
        this.bridgeClasses = ImmutableList.builder().addAll(bridgeClasses).add(IsolatedClassLoader.class).build();
        this.excludePackages = ImmutableList.copyOf(excludePackages);
    }

    public <S, T extends S> S newInstance(Class<T> implClass, Class<S> bridgeClass) throws Exception {
        this.validateBridgeable(bridgeClass.getName());
        return bridgeClass.cast(this.loadClass(implClass.getName()).newInstance());
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.loadWithParentClassLoader(name)) {
            return super.loadClass(name, resolve);
        }
        Class<?> c = this.classes.get(name);
        if (c != null) {
            return c;
        }
        c = this.findClass(name);
        this.classes.put(name, c);
        return c;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes;
        for (Class bridgeClass : this.bridgeClasses) {
            if (!bridgeClass.getName().equals(name)) continue;
            return bridgeClass;
        }
        String resourceName = ClassNames.toInternalName(name) + ".class";
        URL url = this.getResource(resourceName);
        if (url == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            bytes = Resources.toByteArray((URL)url);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Error loading class", e);
        }
        return this.weaveAndDefineClass(name, bytes);
    }

    public Class<?> weaveAndDefineClass(String name, byte[] bytes) {
        String packageName = Reflection.getPackageName((String)name);
        if (this.getPackage(packageName) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        return super.defineClass(name, bytes, 0, bytes.length);
    }

    private void validateBridgeable(String name) {
        if (IsolatedClassLoader.isInBootstrapClassLoader(name)) {
            return;
        }
        for (Class bridgeClass : this.bridgeClasses) {
            if (!bridgeClass.getName().equals(name)) continue;
            return;
        }
        throw new IllegalStateException("Class '" + name + "' is not bridgeable");
    }

    private boolean loadWithParentClassLoader(String name) {
        if (name.startsWith(Agent.class.getName())) {
            return false;
        }
        if (IsolatedClassLoader.isInBootstrapClassLoader(name)) {
            return true;
        }
        for (String excludePackage : this.excludePackages) {
            if (!name.startsWith(excludePackage + ".")) continue;
            return true;
        }
        return false;
    }

    private static boolean isInBootstrapClassLoader(String name) {
        try {
            Class<?> cls = Class.forName(name, false, ClassLoader.getSystemClassLoader());
            return cls.getClassLoader() == null;
        }
        catch (ClassNotFoundException e) {
            logger.trace(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

