/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.impl;

import com.google.common.base.Stopwatch;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.glowroot.GlowrootModule;
import org.glowroot.MainEntryPoint;
import org.glowroot.Viewer;
import org.glowroot.config.ConfigService;
import org.glowroot.config.TransactionConfig;
import org.glowroot.container.impl.SocketCommandProcessor;
import org.glowroot.container.impl.SocketHeartbeat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaagentMain {
    private static final Logger logger = LoggerFactory.getLogger(JavaagentMain.class);

    public static void main(String ... args) throws Exception {
        boolean viewerMode = Boolean.getBoolean("glowroot.testHarness.viewerMode");
        if (viewerMode) {
            JavaagentMain.startViewer();
        } else {
            JavaagentMain.setTransactionSlowThresholdMillisToZero();
        }
        int port = Integer.parseInt(args[0]);
        Socket socket = new Socket((String)null, port);
        ObjectInputStream objectIn = new ObjectInputStream(socket.getInputStream());
        ObjectOutputStream objectOut = new ObjectOutputStream(socket.getOutputStream());
        new Thread(new SocketHeartbeat(objectOut)).start();
        new Thread(new SocketCommandProcessor(objectIn, objectOut)).start();
        if (!viewerMode) {
            for (int i = 0; i < 1000; ++i) {
                JavaagentMain.timerMarkerOne();
                JavaagentMain.timerMarkerTwo();
                Thread.sleep(1L);
            }
        }
    }

    static void setTransactionSlowThresholdMillisToZero() throws Exception {
        GlowrootModule glowrootModule = MainEntryPoint.getGlowrootModule();
        if (glowrootModule == null) {
            return;
        }
        ConfigService configService = glowrootModule.getConfigModule().getConfigService();
        TransactionConfig config = configService.getTransactionConfig();
        if (config.slowThresholdMillis() != 0) {
            TransactionConfig updatedConfig = config.withSlowThresholdMillis(0);
            configService.updateTransactionConfig(updatedConfig, config.version());
        }
    }

    private static void startViewer() throws AssertionError {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Viewer.main(new String[0]);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (stopwatch.elapsed(TimeUnit.SECONDS) < 30L && MainEntryPoint.getGlowrootModule() == null) {
        }
        if (MainEntryPoint.getGlowrootModule() == null) {
            throw new AssertionError((Object)"Timeout occurred waiting for glowroot to start");
        }
    }

    private static void timerMarkerOne() throws InterruptedException {
        Thread.sleep(1L);
    }

    private static void timerMarkerTwo() throws InterruptedException {
        Thread.sleep(1L);
    }
}

