/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.trace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class ThrowableInfo {
    private final String display;
    private final ImmutableList<String> stackTrace;
    private final int framesInCommonWithCaused;
    @Nullable
    private final ThrowableInfo cause;

    private ThrowableInfo(String display, List<String> stackTrace, int framesInCommonWithCaused, @Nullable ThrowableInfo cause) {
        this.display = display;
        this.stackTrace = ImmutableList.copyOf(stackTrace);
        this.framesInCommonWithCaused = framesInCommonWithCaused;
        this.cause = cause;
    }

    public String getDisplay() {
        return this.display;
    }

    public ImmutableList<String> getStackTrace() {
        return this.stackTrace;
    }

    public int getFramesInCommonWithCaused() {
        return this.framesInCommonWithCaused;
    }

    @Nullable
    public ThrowableInfo getCause() {
        return this.cause;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("display", (Object)this.display).add("stackTrace", this.stackTrace).add("framesInCommonWithCaused", this.framesInCommonWithCaused).add("cause", (Object)this.cause).toString();
    }

    @JsonCreator
    static ThrowableInfo readValue(@JsonProperty(value="display") @Nullable String display, @JsonProperty(value="stackTrace") @Nullable List<String> uncheckedStackTrace, @JsonProperty(value="framesInCommonWithCaused") @Nullable Integer framesInCommonWithCaused, @JsonProperty(value="cause") @Nullable ThrowableInfo cause) throws JsonMappingException {
        List<String> stackTrace = ObjectMappers.orEmpty(uncheckedStackTrace, "stackTrace");
        ObjectMappers.checkRequiredProperty(display, "display");
        ObjectMappers.checkRequiredProperty(framesInCommonWithCaused, "framesInCommonWithCaused");
        return new ThrowableInfo(display, stackTrace, framesInCommonWithCaused, cause);
    }
}

