/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.trace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;
import org.glowroot.container.trace.ThrowableInfo;
import org.glowroot.container.trace.Timer;
import org.glowroot.container.trace.TraceGcInfo;

public class Trace {
    private final String id;
    private final boolean active;
    private final boolean partial;
    private final boolean error;
    private final long startTime;
    private final long captureTime;
    private final long duration;
    private final String transactionType;
    private final String transactionName;
    private final String headline;
    @Nullable
    private final String user;
    private final ImmutableSetMultimap<String, String> customAttributes;
    private final Map<String, Object> customDetail;
    @Nullable
    private final String errorMessage;
    @Nullable
    private final ThrowableInfo errorThrowable;
    private final Timer rootTimer;
    @Nullable
    private final Long threadCpuTime;
    @Nullable
    private final Long threadBlockedTime;
    @Nullable
    private final Long threadWaitedTime;
    @Nullable
    private final Long threadAllocatedBytes;
    private final ImmutableList<TraceGcInfo> gcInfos;
    private final long entryCount;
    private final long profileSampleCount;
    private final Existence entriesExistence;
    private final Existence profileExistence;

    private Trace(String id, boolean active, boolean partial, boolean error, long startTime, long captureTime, long duration, String transactionType, String transactionName, String headline, @Nullable String user, ImmutableSetMultimap<String, String> customAttributes, Map<String, Object> customDetail, @Nullable String errorMessage, @Nullable ThrowableInfo errorThrowable, Timer rootTimer, @Nullable Long threadCpuTime, @Nullable Long threadBlockedTime, @Nullable Long threadWaitedTime, @Nullable Long threadAllocatedBytes, List<TraceGcInfo> gcInfos, long entryCount, long profileSampleCount, Existence entriesExistence, Existence profileExistence) {
        this.id = id;
        this.active = active;
        this.partial = partial;
        this.error = error;
        this.startTime = startTime;
        this.captureTime = captureTime;
        this.duration = duration;
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.headline = headline;
        this.user = user;
        this.customAttributes = customAttributes;
        this.customDetail = customDetail;
        this.errorMessage = errorMessage;
        this.errorThrowable = errorThrowable;
        this.rootTimer = rootTimer;
        this.threadCpuTime = threadCpuTime;
        this.threadBlockedTime = threadBlockedTime;
        this.threadWaitedTime = threadWaitedTime;
        this.threadAllocatedBytes = threadAllocatedBytes;
        this.gcInfos = ImmutableList.copyOf(gcInfos);
        this.entryCount = entryCount;
        this.profileSampleCount = profileSampleCount;
        this.entriesExistence = entriesExistence;
        this.profileExistence = profileExistence;
    }

    public String getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public boolean isError() {
        return this.error;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCaptureTime() {
        return this.captureTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public String getHeadline() {
        return this.headline;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public ImmutableSetMultimap<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    public Map<String, Object> getCustomDetail() {
        return this.customDetail;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public ThrowableInfo getErrorThrowable() {
        return this.errorThrowable;
    }

    public Timer getRootTimer() {
        return this.rootTimer;
    }

    @Nullable
    public Long getThreadCpuTime() {
        return this.threadCpuTime;
    }

    @Nullable
    public Long getThreadBlockedTime() {
        return this.threadBlockedTime;
    }

    @Nullable
    public Long getThreadWaitedTime() {
        return this.threadWaitedTime;
    }

    @Nullable
    public Long getThreadAllocatedBytes() {
        return this.threadAllocatedBytes;
    }

    public ImmutableList<TraceGcInfo> getGcInfos() {
        return this.gcInfos;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public long getProfileSampleCount() {
        return this.profileSampleCount;
    }

    public Existence getEntriesExistence() {
        return this.entriesExistence;
    }

    public Existence getProfileExistence() {
        return this.profileExistence;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("active", this.active).add("partial", this.partial).add("error", this.error).add("startTime", this.startTime).add("captureTime", this.captureTime).add("duration", this.duration).add("transactionType", (Object)this.transactionType).add("transactionName", (Object)this.transactionName).add("headline", (Object)this.headline).add("user", (Object)this.user).add("customAttributes", this.customAttributes).add("customDetail", this.customDetail).add("errorMessage", (Object)this.errorMessage).add("errorThrowable", (Object)this.errorThrowable).add("rootTimer", (Object)this.rootTimer).add("threadCpuTime", (Object)this.threadCpuTime).add("threadBlockedTime", (Object)this.threadBlockedTime).add("threadWaitedTime", (Object)this.threadWaitedTime).add("threadAllocatedBytes", (Object)this.threadAllocatedBytes).add("gcInfos", this.gcInfos).add("entryCount", this.entryCount).add("profileSampleCount", this.profileSampleCount).add("entriesExistence", (Object)this.entriesExistence).add("profileExistence", (Object)this.profileExistence).toString();
    }

    @JsonCreator
    static Trace readValue(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="active") @Nullable Boolean active, @JsonProperty(value="partial") @Nullable Boolean partial, @JsonProperty(value="error") @Nullable Boolean error, @JsonProperty(value="startTime") @Nullable Long startTime, @JsonProperty(value="captureTime") @Nullable Long captureTime, @JsonProperty(value="duration") @Nullable Long duration, @JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="transactionName") @Nullable String transactionName, @JsonProperty(value="headline") @Nullable String headline, @JsonProperty(value="user") @Nullable String user, @JsonProperty(value="customAttributes") @Nullable Map<String, List<String>> customAttributes, @JsonProperty(value="customDetail") @Nullable Map<String, Object> customDetail, @JsonProperty(value="errorMessage") @Nullable String errorMessage, @JsonProperty(value="errorThrowable") @Nullable ThrowableInfo errorThrowable, @JsonProperty(value="timers") @Nullable Timer rootTimer, @JsonProperty(value="threadCpuTime") @Nullable Long threadCpuTime, @JsonProperty(value="threadBlockedTime") @Nullable Long threadBlockedTime, @JsonProperty(value="threadWaitedTime") @Nullable Long threadWaitedTime, @JsonProperty(value="threadAllocatedBytes") @Nullable Long threadAllocatedBytes, @JsonProperty(value="gcInfos") @Nullable List<TraceGcInfo> gcInfosUnchecked, @JsonProperty(value="entryCount") @Nullable Long entryCount, @JsonProperty(value="profileSampleCount") @Nullable Long profileSampleCount, @JsonProperty(value="entriesExistence") @Nullable Existence entriesExistence, @JsonProperty(value="profileExistence") @Nullable Existence profileExistence) throws JsonMappingException {
        List<TraceGcInfo> gcInfos = ObjectMappers.orEmpty(gcInfosUnchecked, "gcInfos");
        ObjectMappers.checkRequiredProperty(id, "id");
        ObjectMappers.checkRequiredProperty(active, "active");
        ObjectMappers.checkRequiredProperty(partial, "partial");
        ObjectMappers.checkRequiredProperty(error, "error");
        ObjectMappers.checkRequiredProperty(startTime, "startTime");
        ObjectMappers.checkRequiredProperty(captureTime, "captureTime");
        ObjectMappers.checkRequiredProperty(duration, "duration");
        ObjectMappers.checkRequiredProperty(transactionType, "transactionType");
        ObjectMappers.checkRequiredProperty(transactionName, "transactionName");
        ObjectMappers.checkRequiredProperty(headline, "headline");
        ObjectMappers.checkRequiredProperty(rootTimer, "timers");
        ObjectMappers.checkRequiredProperty(entryCount, "entryCount");
        ObjectMappers.checkRequiredProperty(profileSampleCount, "profileSampleCount");
        ObjectMappers.checkRequiredProperty(entriesExistence, "entriesExistence");
        ObjectMappers.checkRequiredProperty(profileExistence, "profileExistence");
        ImmutableSetMultimap.Builder theCustomAttributes = ImmutableSetMultimap.builder();
        if (customAttributes != null) {
            for (Map.Entry<String, List<String>> entry : customAttributes.entrySet()) {
                List<String> uncheckedValues = entry.getValue();
                if (uncheckedValues == null) {
                    throw new JsonMappingException("Null value not allowed for custom attribute map value");
                }
                List<String> values = ObjectMappers.orEmpty(uncheckedValues, "customAttributes");
                theCustomAttributes.putAll((Object)entry.getKey(), values);
            }
        }
        return new Trace(id, active, partial, error, startTime, captureTime, duration, transactionType, transactionName, headline, user, (ImmutableSetMultimap<String, String>)theCustomAttributes.build(), ObjectMappers.nullToEmpty(customDetail), errorMessage, errorThrowable, rootTimer, threadCpuTime, threadBlockedTime, threadWaitedTime, threadAllocatedBytes, gcInfos, entryCount, profileSampleCount, entriesExistence, profileExistence);
    }

    public static enum Existence {
        YES,
        NO,
        EXPIRED;

    }
}

