/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.jvm;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.jvm.OptionalService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
public final class Availability
extends OptionalService.AvailabilityBase {
    private final boolean isAvailable;
    private final String reason;

    private Availability(boolean isAvailable, String reason) {
        this.isAvailable = isAvailable;
        this.reason = reason;
    }

    @Override
    @JsonProperty(value="isAvailable")
    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Override
    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    public final Availability withIsAvailable(boolean value) {
        if (this.isAvailable == value) {
            return this;
        }
        boolean newValue = value;
        return new Availability(newValue, this.reason);
    }

    public final Availability withReason(String value) {
        if (this.reason == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Availability(this.isAvailable, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof Availability && this.equalTo((Availability)another);
    }

    private boolean equalTo(Availability another) {
        return this.isAvailable == another.isAvailable && this.reason.equals(another.reason);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode(this.isAvailable);
        h = h * 17 + this.reason.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Availability").add("isAvailable", this.isAvailable).add("reason", this.reason).toString();
    }

    @JsonCreator
    public static Availability fromAllAttributes(@JsonProperty(value="isAvailable") @Nullable Boolean isAvailable, @JsonProperty(value="reason") @Nullable String reason) {
        Builder builder = Availability.builder();
        if (isAvailable != null) {
            builder.isAvailable(isAvailable);
        }
        if (reason != null) {
            builder.reason(reason);
        }
        return builder.build();
    }

    public static Availability of(boolean isAvailable, String reason) {
        return new Availability(isAvailable, reason);
    }

    public static Availability copyOf(OptionalService.AvailabilityBase instance) {
        if (instance instanceof Availability) {
            return (Availability)instance;
        }
        return Availability.builder().isAvailable(instance.isAvailable()).reason(instance.getReason()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_IS_AVAILABLE = 1L;
        private static final long INITIALIZED_BIT_REASON = 2L;
        private long initializedBitset;
        private boolean isAvailable;
        @Nullable
        private String reason;

        private Builder() {
        }

        public final Builder isAvailable(boolean isAvailable) {
            this.checkNotIsSet(this.isAvailableIsSet(), "isAvailable");
            this.isAvailable = isAvailable;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder reason(String reason) {
            this.checkNotIsSet(this.reasonIsSet(), "reason");
            this.reason = Preconditions.checkNotNull(reason);
            this.initializedBitset |= 2L;
            return this;
        }

        public Availability build() {
            this.checkRequiredAttributes();
            return new Availability(this.isAvailable, this.reason);
        }

        private boolean isAvailableIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean reasonIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Availability is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.isAvailableIsSet()) {
                attributes.add("isAvailable");
            }
            if (!this.reasonIsSet()) {
                attributes.add("reason");
            }
            return "Cannot build Availability, some of required attributes are not set " + attributes;
        }
    }
}

