/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.jvm;

import javax.annotation.Nullable;
import org.glowroot.jvm.HeapDumps;
import org.glowroot.jvm.LazyPlatformMBeanServer;
import org.glowroot.jvm.OptionalService;
import org.glowroot.jvm.ProcessId;
import org.glowroot.jvm.ThreadAllocatedBytes;

public class JvmModule {
    private final LazyPlatformMBeanServer lazyPlatformMBeanServer;
    private final OptionalService<ThreadAllocatedBytes> threadAllocatedBytes;
    private final OptionalService<HeapDumps> heapDumps;
    @Nullable
    private final String processId;

    public JvmModule(boolean jbossModules) {
        this.lazyPlatformMBeanServer = new LazyPlatformMBeanServer(jbossModules);
        this.threadAllocatedBytes = ThreadAllocatedBytes.create();
        this.heapDumps = HeapDumps.create(this.lazyPlatformMBeanServer);
        this.processId = ProcessId.getProcessId();
    }

    public LazyPlatformMBeanServer getLazyPlatformMBeanServer() {
        return this.lazyPlatformMBeanServer;
    }

    public OptionalService<ThreadAllocatedBytes> getThreadAllocatedBytes() {
        return this.threadAllocatedBytes;
    }

    public OptionalService<HeapDumps> getHeapDumps() {
        return this.heapDumps;
    }

    @Nullable
    public String getProcessId() {
        return this.processId;
    }
}

