/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.jvm;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.Stopwatch;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class LazyPlatformMBeanServer {
    private static final Logger logger = LoggerFactory.getLogger(LazyPlatformMBeanServer.class);
    private final boolean jbossModules;
    @GuardedBy(value="initListeners")
    private final List<InitListener> initListeners = Lists.newArrayList();
    @MonotonicNonNull
    private volatile MBeanServer mbeanServer;

    LazyPlatformMBeanServer(boolean jbossModules) {
        this.jbossModules = jbossModules;
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws Exception {
        this.ensureInit();
        return this.mbeanServer.getObjectInstance(name);
    }

    void invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws Exception {
        this.ensureInit();
        this.mbeanServer.invoke(name, operationName, params, signature);
    }

    public Set<ObjectName> queryNames(@Nullable ObjectName name, @Nullable QueryExp query) throws InterruptedException {
        this.ensureInit();
        return this.mbeanServer.queryNames(name, query);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws Exception {
        this.ensureInit();
        return this.mbeanServer.getMBeanInfo(name);
    }

    public Object getAttribute(ObjectName name, String attribute) throws Exception {
        this.ensureInit();
        return this.mbeanServer.getAttribute(name, attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitListener(InitListener initListener) {
        List<InitListener> list = this.initListeners;
        synchronized (list) {
            if (this.mbeanServer == null) {
                this.initListeners.add(initListener);
            } else {
                try {
                    initListener.postInit(this.mbeanServer);
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
            }
        }
    }

    @OnlyUsedByTests
    public void unregisterMBean(ObjectName name) throws Exception {
        this.ensureInit();
        this.mbeanServer.unregisterMBean(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"mbeanServer"})
    private void ensureInit() throws InterruptedException {
        if (this.needsDelayedInit()) {
            LazyPlatformMBeanServer.waitForJBossModuleInitialization(Stopwatch.createUnstarted());
        }
        List<InitListener> list = this.initListeners;
        synchronized (list) {
            if (this.mbeanServer == null) {
                this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
                for (InitListener initListener : this.initListeners) {
                    try {
                        initListener.postInit(this.mbeanServer);
                    }
                    catch (Throwable t) {
                        logger.error(t.getMessage(), t);
                    }
                }
            }
        }
    }

    private boolean needsDelayedInit() {
        return this.mbeanServer == null && this.jbossModules;
    }

    @VisibleForTesting
    static void waitForJBossModuleInitialization(Stopwatch stopwatch) throws InterruptedException {
        stopwatch.start();
        while (stopwatch.elapsed(TimeUnit.SECONDS) < 60L) {
            if (System.getProperty("java.util.logging.manager") != null) {
                return;
            }
            Thread.sleep(100L);
        }
        logger.error("this jvm appears to be running jboss-modules, but it did not set up java.util.logging.manager");
    }

    public static interface InitListener {
        public void postInit(MBeanServer var1) throws Exception;
    }
}

