/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.jvm;

import javax.annotation.Nullable;
import org.glowroot.common.Styles;
import org.glowroot.jvm.Availability;
import org.glowroot.shaded.google.common.base.Supplier;
import org.glowroot.shaded.google.common.base.Suppliers;
import org.immutables.value.Value;

public abstract class OptionalService<T> {
    static <T> OptionalService<T> available(T service) {
        return new PresentOptionalService<T>(service);
    }

    static <T> OptionalService<T> unavailable(String reason) {
        return new AbsentOptionalService(reason);
    }

    static <T> OptionalService<T> lazy(Supplier<OptionalService<T>> supplier) {
        return new LazyOptionalService<T>(supplier);
    }

    public abstract Availability getAvailability();

    @Nullable
    public abstract T getService();

    private static class LazyOptionalService<T>
    extends OptionalService<T> {
        private final Supplier<OptionalService<T>> supplier;

        LazyOptionalService(Supplier<OptionalService<T>> supplier) {
            this.supplier = Suppliers.memoize(supplier);
        }

        @Override
        public Availability getAvailability() {
            return this.supplier.get().getAvailability();
        }

        @Override
        @Nullable
        public T getService() {
            return this.supplier.get().getService();
        }
    }

    private static class AbsentOptionalService<T>
    extends OptionalService<T> {
        private final Availability availability;

        public AbsentOptionalService(String reason) {
            this.availability = Availability.of(false, reason);
        }

        @Override
        public Availability getAvailability() {
            return this.availability;
        }

        @Override
        @Nullable
        public T getService() {
            return null;
        }
    }

    private static class PresentOptionalService<T>
    extends OptionalService<T> {
        private final Availability availability = Availability.of(true, "");
        private final T service;

        public PresentOptionalService(T service) {
            this.service = service;
        }

        @Override
        public Availability getAvailability() {
            return this.availability;
        }

        @Override
        public T getService() {
            return this.service;
        }
    }

    @Value.Immutable
    @Styles.AllParameters
    public static abstract class AvailabilityBase {
        public abstract boolean isAvailable();

        public abstract String getReason();
    }
}

