/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.jvm;

import java.lang.management.ManagementFactory;
import javax.annotation.Nullable;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class ProcessId {
    private static final Logger logger = LoggerFactory.getLogger(ProcessId.class);

    private ProcessId() {
    }

    @Nullable
    static String getProcessId() {
        return ProcessId.parseProcessId(ManagementFactory.getRuntimeMXBean().getName());
    }

    @Nullable
    @VisibleForTesting
    static String parseProcessId(String runtimeName) {
        int index = runtimeName.indexOf(64);
        if (index > 0) {
            String pid = runtimeName.substring(0, index);
            try {
                Long.parseLong(pid);
                return pid;
            }
            catch (NumberFormatException e) {
                logger.debug(e.getMessage(), e);
                return null;
            }
        }
        return null;
    }
}

