/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.jvm;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.glowroot.common.Reflections;
import org.glowroot.jvm.OptionalService;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class ThreadAllocatedBytes {
    private static final Logger logger = LoggerFactory.getLogger(ThreadAllocatedBytes.class);
    private final Method getThreadAllocatedBytesMethod;
    private volatile boolean disabledDueToError;

    static OptionalService<ThreadAllocatedBytes> create() {
        try {
            return ThreadAllocatedBytes.createInternal();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            return OptionalService.unavailable("<see error log for detail>");
        }
    }

    private static OptionalService<ThreadAllocatedBytes> createInternal() throws Exception {
        Class<?> sunThreadMXBeanClass;
        try {
            sunThreadMXBeanClass = Class.forName("com.sun.management.ThreadMXBean");
        }
        catch (ClassNotFoundException e) {
            logger.debug(e.getMessage(), e);
            return OptionalService.unavailable("Cannot find class com.sun.management.ThreadMXBean (introduced in Oracle Java SE 6u25)");
        }
        Method isSupportedMethod = Reflections.getMethod(sunThreadMXBeanClass, "isThreadAllocatedMemorySupported", new Class[0]);
        Boolean supported = (Boolean)Reflections.invoke(isSupportedMethod, (Object)ManagementFactory.getThreadMXBean(), new Object[0]);
        return ThreadAllocatedBytes.createInternal(supported, sunThreadMXBeanClass);
    }

    @VisibleForTesting
    static OptionalService<ThreadAllocatedBytes> createInternal(@Nullable Boolean supported, Class<?> sunThreadMXBeanClass) throws Exception {
        if (supported == null) {
            return OptionalService.unavailable("ThreadMXBean.isThreadAllocatedMemorySupported() unexpectedly returned null");
        }
        if (!supported.booleanValue()) {
            return OptionalService.unavailable("Method com.sun.management.ThreadMXBean.isThreadAllocatedMemorySupported() returned false");
        }
        Method getThreadAllocatedBytesMethod = Reflections.getMethod(sunThreadMXBeanClass, "getThreadAllocatedBytes", Long.TYPE);
        return OptionalService.available(new ThreadAllocatedBytes(getThreadAllocatedBytesMethod));
    }

    private ThreadAllocatedBytes(Method getThreadAllocatedBytesMethod) {
        this.getThreadAllocatedBytesMethod = getThreadAllocatedBytesMethod;
    }

    public long getThreadAllocatedBytesSafely(long threadId) {
        if (this.disabledDueToError) {
            return -1L;
        }
        try {
            Long threadAllocatedBytes = (Long)Reflections.invoke(this.getThreadAllocatedBytesMethod, (Object)ManagementFactory.getThreadMXBean(), threadId);
            if (threadAllocatedBytes == null) {
                logger.error("method unexpectedly returned null: com.sun.management.ThreadMXBean.getThreadAllocatedBytes()");
                this.disabledDueToError = true;
                return -1L;
            }
            return threadAllocatedBytes;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            this.disabledDueToError = true;
            return -1L;
        }
    }
}

