/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.zip.DataFormatException;
import javax.annotation.Nullable;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.collector.Aggregate;
import org.glowroot.collector.AggregateTimer;
import org.glowroot.collector.ErrorPoint;
import org.glowroot.collector.ErrorSummary;
import org.glowroot.collector.LazyHistogram;
import org.glowroot.collector.ProfileAggregate;
import org.glowroot.collector.QueryAggregate;
import org.glowroot.collector.QueryComponent;
import org.glowroot.collector.TransactionSummary;
import org.glowroot.common.Checkers;
import org.glowroot.common.Clock;
import org.glowroot.common.ObjectMappers;
import org.glowroot.common.ScratchBuffer;
import org.glowroot.config.ConfigService;
import org.glowroot.config.RollupConfig;
import org.glowroot.local.store.CappedDatabase;
import org.glowroot.local.store.Column;
import org.glowroot.local.store.DataSource;
import org.glowroot.local.store.ErrorSummaryQuery;
import org.glowroot.local.store.Index;
import org.glowroot.local.store.QueryResult;
import org.glowroot.local.store.RowMappers;
import org.glowroot.local.store.TransactionSummaryQuery;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.google.common.io.CharSource;
import org.glowroot.transaction.model.ProfileNode;
import org.immutables.value.Value;

public class AggregateDao {
    public static final String OVERWRITTEN = "{\"overwritten\":true}";
    private static final ObjectMapper mapper = ObjectMappers.create();
    private static final ImmutableList<Column> overallAggregatePointColumns = ImmutableList.of(Column.of("transaction_type", 12), Column.of("capture_time", -5), Column.of("total_micros", -5), Column.of("error_count", -5), Column.of("transaction_count", -5), Column.of("total_cpu_micros", -5), Column.of("total_blocked_micros", -5), Column.of("total_waited_micros", -5), Column.of("total_allocated_kbytes", -5), Column.of("queries_capped_id", -5), Column.of("profile_capped_id", -5), Column.of("histogram", 2004), new Column[]{Column.of("timers", 12)});
    private static final ImmutableList<Column> transactionAggregateColumns = ImmutableList.of(Column.of("transaction_type", 12), Column.of("transaction_name", 12), Column.of("capture_time", -5), Column.of("total_micros", -5), Column.of("error_count", -5), Column.of("transaction_count", -5), Column.of("total_cpu_micros", -5), Column.of("total_blocked_micros", -5), Column.of("total_waited_micros", -5), Column.of("total_allocated_kbytes", -5), Column.of("queries_capped_id", -5), Column.of("profile_capped_id", -5), new Column[]{Column.of("histogram", 2004), Column.of("timers", 12)});
    private static final ImmutableList<String> overallAggregateIndexColumns = ImmutableList.of("capture_time", "transaction_type", "total_micros", "transaction_count", "error_count");
    private static final ImmutableList<String> transactionAggregateIndexColumns = ImmutableList.of("capture_time", "transaction_type", "transaction_name", "total_micros", "transaction_count", "error_count");
    private final DataSource dataSource;
    private final List<CappedDatabase> rollupCappedDatabases;
    private final ConfigService configService;
    private final Clock clock;
    private final AtomicLongArray lastRollupTimes;
    private final Object rollupLock = new Object();

    AggregateDao(DataSource dataSource, List<CappedDatabase> rollupCappedDatabases, ConfigService configService, Clock clock) throws SQLException {
        this.dataSource = dataSource;
        this.rollupCappedDatabases = rollupCappedDatabases;
        this.configService = configService;
        this.clock = clock;
        ImmutableList<RollupConfig> rollupConfigs = configService.getRollupConfigs();
        for (int i = 0; i < rollupConfigs.size(); ++i) {
            String overallTableName = "overall_aggregate_rollup_" + Checkers.castUntainted(i);
            dataSource.syncTable(overallTableName, overallAggregatePointColumns);
            dataSource.syncIndexes(overallTableName, ImmutableList.of(Index.of(overallTableName + "_idx", overallAggregateIndexColumns)));
            String transactionTableName = "transaction_aggregate_rollup_" + Checkers.castUntainted(i);
            dataSource.syncTable(transactionTableName, transactionAggregateColumns);
            dataSource.syncIndexes(transactionTableName, ImmutableList.of(Index.of(transactionTableName + "_idx", transactionAggregateIndexColumns)));
        }
        long[] lastRollupTimes = new long[rollupConfigs.size()];
        lastRollupTimes[0] = 0L;
        for (int i = 1; i < lastRollupTimes.length; ++i) {
            lastRollupTimes[i] = dataSource.queryForLong("select ifnull(max(capture_time), 0) from overall_aggregate_rollup_" + Checkers.castUntainted(i), new Object[0]);
        }
        this.lastRollupTimes = new AtomicLongArray(lastRollupTimes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(List<Aggregate> overallAggregates, List<Aggregate> transactionAggregates, long captureTime) throws Exception {
        this.storeAtRollupLevel(overallAggregates, transactionAggregates, 0);
        Object object = this.rollupLock;
        synchronized (object) {
            ImmutableList<RollupConfig> rollupConfigs = this.configService.getRollupConfigs();
            for (int i = 1; i < rollupConfigs.size(); ++i) {
                RollupConfig rollupConfig = (RollupConfig)rollupConfigs.get(i);
                long safeRollupTime = AggregateDao.getSafeRollupTime(captureTime, rollupConfig.intervalMillis());
                if (safeRollupTime <= this.lastRollupTimes.get(i)) continue;
                this.rollup(this.lastRollupTimes.get(i), safeRollupTime, rollupConfig.intervalMillis(), i, i - 1);
                this.lastRollupTimes.set(i, safeRollupTime);
            }
        }
    }

    public TransactionSummary readOverallSummary(String transactionType, long captureTimeFrom, long captureTimeTo) throws SQLException {
        int rollupLevel = this.getRollupLevelForView(captureTimeFrom, captureTimeTo);
        long lastRollupTime = this.lastRollupTimes.get(rollupLevel);
        if (rollupLevel != 0 && captureTimeTo > lastRollupTime) {
            TransactionSummary overallSummary = this.readOverallSummaryInternal(transactionType, captureTimeFrom, lastRollupTime, rollupLevel);
            TransactionSummary sinceLastRollupSummary = this.readOverallSummaryInternal(transactionType, lastRollupTime, captureTimeTo, 0);
            return this.combineOverallSummaries(overallSummary, sinceLastRollupSummary);
        }
        return this.readOverallSummaryInternal(transactionType, captureTimeFrom, captureTimeTo, rollupLevel);
    }

    public QueryResult<TransactionSummary> readTransactionSummaries(TransactionSummaryQuery query) throws SQLException {
        int rollupLevel = this.getRollupLevelForView(query.from(), query.to());
        long lastRollupTime = this.lastRollupTimes.get(rollupLevel);
        ImmutableList<TransactionSummary> summaries = rollupLevel != 0 && query.to() > lastRollupTime ? this.readTransactionSummariesInternalSplit(query, rollupLevel, lastRollupTime) : this.readTransactionSummariesInternal(query, rollupLevel);
        return QueryResult.from(summaries, query.limit());
    }

    public ErrorSummary readOverallErrorSummary(String transactionType, long captureTimeFrom, long captureTimeTo, int rollupLevel) throws SQLException {
        ErrorSummary result = this.dataSource.query("select sum(error_count), sum(transaction_count) from overall_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and capture_time > ? and capture_time <= ?", new OverallErrorSummaryResultSetExtractor(), transactionType, captureTimeFrom, captureTimeTo);
        if (result == null) {
            return ErrorSummary.builder().build();
        }
        return result;
    }

    public QueryResult<ErrorSummary> readTransactionErrorSummaries(ErrorSummaryQuery query, int rollupLevel) throws SQLException {
        ImmutableList<ErrorSummary> summary = this.dataSource.query("select transaction_name, sum(error_count), sum(transaction_count) from transaction_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and capture_time > ?" + " and capture_time <= ? group by transaction_type, transaction_name" + " having sum(error_count) > 0 order by " + AggregateDao.getSortClause(query.sortOrder()) + ", transaction_type, transaction_name limit ?", new ErrorSummaryRowMapper(), query.transactionType(), query.from(), query.to(), query.limit() + 1);
        return QueryResult.from(summary, query.limit());
    }

    public ImmutableList<Aggregate> readOverallAggregates(String transactionType, long captureTimeFrom, long captureTimeTo, int rollupLevel) throws SQLException {
        return this.dataSource.query("select capture_time, total_micros, error_count, transaction_count, total_cpu_micros, total_blocked_micros, total_waited_micros, total_allocated_kbytes, histogram, timers from overall_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and capture_time >= ? and capture_time <= ?" + " order by capture_time", new AggregateRowMapper(transactionType, null), transactionType, captureTimeFrom, captureTimeTo);
    }

    public ImmutableList<Aggregate> readTransactionAggregates(String transactionType, String transactionName, long captureTimeFrom, long captureTimeTo, int rollupLevel) throws SQLException {
        return this.dataSource.query("select capture_time, total_micros, error_count, transaction_count, total_cpu_micros, total_blocked_micros, total_waited_micros, total_allocated_kbytes, histogram, timers from transaction_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and transaction_name = ? and capture_time >= ?" + " and capture_time <= ? order by capture_time", new AggregateRowMapper(transactionType, transactionName), transactionType, transactionName, captureTimeFrom, captureTimeTo);
    }

    public ImmutableList<QueryAggregate> readOverallQueryAggregates(String transactionType, long captureTimeFrom, long captureTimeTo, int rollupLevel) throws SQLException {
        return this.dataSource.query("select capture_time, queries_capped_id from overall_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and capture_time > ? and capture_time <= ?" + " and queries_capped_id >= ?  order by capture_time", new QueryAggregateRowMapper(rollupLevel), transactionType, captureTimeFrom, captureTimeTo, this.rollupCappedDatabases.get(rollupLevel).getSmallestNonExpiredId());
    }

    public ImmutableList<QueryAggregate> readTransactionQueryAggregates(String transactionType, String transactionName, long captureTimeFrom, long captureTimeTo, int rollupLevel) throws SQLException {
        return this.dataSource.query("select capture_time, queries_capped_id from transaction_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and transaction_name = ? and capture_time > ?" + " and capture_time <= ? and queries_capped_id >= ? order by capture_time", new QueryAggregateRowMapper(rollupLevel), transactionType, transactionName, captureTimeFrom, captureTimeTo, this.rollupCappedDatabases.get(rollupLevel).getSmallestNonExpiredId());
    }

    public ImmutableList<ProfileAggregate> readOverallProfileAggregates(String transactionType, long captureTimeFrom, long captureTimeTo, int rollupLevel) throws SQLException {
        return this.dataSource.query("select capture_time, profile_capped_id from overall_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and capture_time > ? and capture_time <= ?" + " and profile_capped_id >= ? order by capture_time", new ProfileAggregateRowMapper(rollupLevel), transactionType, captureTimeFrom, captureTimeTo, this.rollupCappedDatabases.get(rollupLevel).getSmallestNonExpiredId());
    }

    public ImmutableList<ProfileAggregate> readTransactionProfileAggregates(String transactionType, String transactionName, long captureTimeFrom, long captureTimeTo, int rollupLevel) throws SQLException {
        return this.dataSource.query("select capture_time, profile_capped_id from transaction_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and transaction_name = ? and capture_time > ?" + " and capture_time <= ? and profile_capped_id >= ? order by capture_time", new ProfileAggregateRowMapper(rollupLevel), transactionType, transactionName, captureTimeFrom, captureTimeTo, this.rollupCappedDatabases.get(rollupLevel).getSmallestNonExpiredId());
    }

    public ImmutableList<ErrorPoint> readOverallErrorPoints(String transactionType, long captureTimeFrom, long captureTimeTo, int rollupLevel) throws SQLException {
        return this.dataSource.query("select capture_time, sum(error_count), sum(transaction_count) from overall_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and capture_time >= ? and capture_time <= ?" + " group by capture_time having sum(error_count) > 0 order by capture_time", new ErrorPointRowMapper(), transactionType, captureTimeFrom, captureTimeTo);
    }

    public ImmutableList<ErrorPoint> readTransactionErrorPoints(String transactionType, String transactionName, long captureTimeFrom, long captureTimeTo, int rollupLevel) throws SQLException {
        return this.dataSource.query("select capture_time, error_count, transaction_count from transaction_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and transaction_name = ? and capture_time >= ?" + " and capture_time <= ? and error_count > 0 order by capture_time", new ErrorPointRowMapper(), transactionType, transactionName, captureTimeFrom, captureTimeTo);
    }

    public boolean shouldHaveOverallQueries(String transactionType, long captureTimeFrom, long captureTimeTo) throws SQLException {
        return this.shouldHaveOverallSomething("queries_capped_id", transactionType, captureTimeFrom, captureTimeTo);
    }

    public boolean shouldHaveTransactionQueries(String transactionType, String transactionName, long captureTimeFrom, long captureTimeTo) throws SQLException {
        return this.shouldHaveTransactionSomething("queries_capped_id", transactionType, transactionName, captureTimeFrom, captureTimeTo);
    }

    public boolean shouldHaveOverallProfile(String transactionType, long captureTimeFrom, long captureTimeTo) throws SQLException {
        return this.shouldHaveOverallSomething("profile_capped_id", transactionType, captureTimeFrom, captureTimeTo);
    }

    public boolean shouldHaveTransactionProfile(String transactionType, String transactionName, long captureTimeFrom, long captureTimeTo) throws SQLException {
        return this.shouldHaveTransactionSomething("profile_capped_id", transactionType, transactionName, captureTimeFrom, captureTimeTo);
    }

    public long getDataPointIntervalMillis(long captureTimeFrom, long captureTimeTo) {
        long millis = captureTimeTo - captureTimeFrom;
        long timeAgoMillis = this.clock.currentTimeMillis() - captureTimeFrom;
        ImmutableList<Integer> rollupExpirationHours = this.configService.getStorageConfig().rollupExpirationHours();
        ImmutableList<RollupConfig> rollupConfigs = this.configService.getRollupConfigs();
        for (int i = 0; i < rollupConfigs.size() - 1; ++i) {
            RollupConfig currRollupConfig = (RollupConfig)rollupConfigs.get(i);
            RollupConfig nextRollupConfig = (RollupConfig)rollupConfigs.get(i + 1);
            if (millis >= nextRollupConfig.viewThresholdMillis() || TimeUnit.HOURS.toMillis(((Integer)rollupExpirationHours.get(i)).intValue()) <= timeAgoMillis) continue;
            return currRollupConfig.intervalMillis();
        }
        return ((RollupConfig)rollupConfigs.get(rollupConfigs.size() - 1)).intervalMillis();
    }

    public int getRollupLevelForView(long captureTimeFrom, long captureTimeTo) {
        long millis = captureTimeTo - captureTimeFrom;
        long timeAgoMillis = this.clock.currentTimeMillis() - captureTimeFrom;
        ImmutableList<Integer> rollupExpirationHours = this.configService.getStorageConfig().rollupExpirationHours();
        ImmutableList<RollupConfig> rollupConfigs = this.configService.getRollupConfigs();
        for (int i = 0; i < rollupConfigs.size() - 1; ++i) {
            RollupConfig nextRollupConfig = (RollupConfig)rollupConfigs.get(i + 1);
            if (millis >= nextRollupConfig.viewThresholdMillis() || TimeUnit.HOURS.toMillis(((Integer)rollupExpirationHours.get(i)).intValue()) <= timeAgoMillis) continue;
            return i;
        }
        return rollupConfigs.size() - 1;
    }

    public void deleteAll() throws SQLException {
        for (int i = 0; i < this.configService.getRollupConfigs().size(); ++i) {
            this.dataSource.execute("truncate table overall_aggregate_rollup_" + Checkers.castUntainted(i));
            this.dataSource.execute("truncate table transaction_aggregate_rollup_" + Checkers.castUntainted(i));
        }
    }

    void deleteBefore(long captureTime, int rollupLevel) throws SQLException {
        this.dataSource.deleteBefore("overall_aggregate_rollup_" + Checkers.castUntainted(rollupLevel), captureTime);
        this.dataSource.deleteBefore("transaction_aggregate_rollup_" + Checkers.castUntainted(rollupLevel), captureTime);
    }

    private void rollup(long lastRollupTime, long curentRollupTime, long fixedIntervalMillis, int toRollupLevel, int fromRollupLevel) throws Exception {
        String captureTimeSql = Checkers.castUntainted("ceil(capture_time / " + fixedIntervalMillis + ".0) * " + fixedIntervalMillis);
        ImmutableList<Long> rollupTimes = this.dataSource.query("select distinct " + captureTimeSql + " from overall_aggregate_rollup_" + Checkers.castUntainted(fromRollupLevel) + " where capture_time > ? and capture_time <= ?", new LongRowMapper(), lastRollupTime, curentRollupTime);
        for (Long rollupTime : rollupTimes) {
            this.rollupOneInterval(rollupTime, fixedIntervalMillis, toRollupLevel, fromRollupLevel);
        }
    }

    private void rollupOneInterval(long rollupTime, long fixedIntervalMillis, int toRollupLevel, int fromRollupLevel) throws Exception {
        List<Aggregate> overallAggregates = this.dataSource.query("select transaction_type, total_micros, error_count, transaction_count, total_cpu_micros, total_blocked_micros, total_waited_micros, total_allocated_kbytes, queries_capped_id, profile_capped_id, histogram, timers from overall_aggregate_rollup_" + Checkers.castUntainted(fromRollupLevel) + " where capture_time > ? and capture_time <= ?", new OverallRollupResultSetExtractor(rollupTime, fromRollupLevel), rollupTime - fixedIntervalMillis, rollupTime);
        if (overallAggregates == null) {
            return;
        }
        List<Aggregate> transactionAggregates = this.dataSource.query("select transaction_type, transaction_name, total_micros, error_count, transaction_count, total_cpu_micros, total_blocked_micros, total_waited_micros, total_allocated_kbytes, queries_capped_id, profile_capped_id, histogram, timers from transaction_aggregate_rollup_" + Checkers.castUntainted(fromRollupLevel) + " where capture_time > ? and capture_time <= ?", new TransactionRollupResultSetExtractor(rollupTime, fromRollupLevel), rollupTime - fixedIntervalMillis, rollupTime);
        if (transactionAggregates == null) {
            return;
        }
        this.storeAtRollupLevel(overallAggregates, transactionAggregates, toRollupLevel);
    }

    private void storeAtRollupLevel(List<Aggregate> overallAggregates, List<Aggregate> transactionAggregates, int rollupLevel) throws Exception {
        this.dataSource.batchUpdate("insert into overall_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " (transaction_type, capture_time, total_micros, error_count, transaction_count," + " total_cpu_micros, total_blocked_micros, total_waited_micros," + " total_allocated_kbytes, queries_capped_id, profile_capped_id, histogram," + " timers) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new OverallBatchAdder(overallAggregates, rollupLevel));
        this.dataSource.batchUpdate("insert into transaction_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " (transaction_type, transaction_name, capture_time," + " total_micros, error_count, transaction_count, total_cpu_micros," + " total_blocked_micros, total_waited_micros, total_allocated_kbytes," + " queries_capped_id, profile_capped_id, histogram, timers)" + " values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new TransactionBatchAdder(transactionAggregates, rollupLevel));
    }

    private TransactionSummary readOverallSummaryInternal(String transactionType, long captureTimeFrom, long captureTimeTo, int rollupLevel) throws SQLException {
        TransactionSummary summary = this.dataSource.query("select sum(total_micros), sum(transaction_count) from overall_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and capture_time > ?" + " and capture_time <= ?", new OverallSummaryResultSetExtractor(), transactionType, captureTimeFrom, captureTimeTo);
        if (summary == null) {
            return TransactionSummary.builder().build();
        }
        return summary;
    }

    private TransactionSummary combineOverallSummaries(TransactionSummary overallSummary1, TransactionSummary overallSummary2) {
        return TransactionSummary.builder().totalMicros(overallSummary1.totalMicros() + overallSummary2.totalMicros()).transactionCount(overallSummary1.transactionCount() + overallSummary2.transactionCount()).build();
    }

    private ImmutableList<TransactionSummary> readTransactionSummariesInternal(TransactionSummaryQuery query, int rollupLevel) throws SQLException {
        return this.dataSource.query("select transaction_name, sum(total_micros), sum(transaction_count) from transaction_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and capture_time > ? and capture_time <= ?" + " group by transaction_name order by " + AggregateDao.getSortClause(query.sortOrder()) + ", transaction_name limit ?", new TransactionSummaryRowMapper(), query.transactionType(), query.from(), query.to(), query.limit() + 1);
    }

    private ImmutableList<TransactionSummary> readTransactionSummariesInternalSplit(TransactionSummaryQuery query, int rollupLevel, long lastRollupTime) throws SQLException {
        return this.dataSource.query("select transaction_name, sum(total_micros), sum(transaction_count) from (select transaction_name, total_micros, transaction_count from transaction_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and capture_time > ? and capture_time <= ?" + " union all select transaction_name, total_micros, transaction_count" + " from transaction_aggregate_rollup_0 where transaction_type = ?" + " and capture_time > ? and capture_time <= ?) group by transaction_name order by " + AggregateDao.getSortClause(query.sortOrder()) + ", transaction_name limit ?", new TransactionSummaryRowMapper(), query.transactionType(), query.from(), lastRollupTime, query.transactionType(), lastRollupTime, query.to(), query.limit() + 1);
    }

    private boolean shouldHaveOverallSomething(@Untainted String cappedIdColumnName, String transactionType, long captureTimeFrom, long captureTimeTo) throws SQLException {
        int rollupLevel = this.getRollupLevelForView(captureTimeFrom, captureTimeTo);
        return this.dataSource.queryForExists("select 1 from overall_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ? and capture_time > ?" + " and capture_time <= ? and " + cappedIdColumnName + " is not null limit 1", transactionType, captureTimeFrom, captureTimeTo);
    }

    private boolean shouldHaveTransactionSomething(@Untainted String cappedIdColumnName, String transactionType, String transactionName, long captureTimeFrom, long captureTimeTo) throws SQLException {
        int rollupLevel = this.getRollupLevelForView(captureTimeFrom, captureTimeTo);
        return this.dataSource.queryForExists("select 1 from transaction_aggregate_rollup_" + Checkers.castUntainted(rollupLevel) + " where transaction_type = ?" + " and transaction_name = ? and capture_time > ? and capture_time <= ? and  " + cappedIdColumnName + " is not null limit 1", transactionType, transactionName, captureTimeFrom, captureTimeTo);
    }

    private void bindCommon(PreparedStatement preparedStatement, Aggregate overallAggregate, int startIndex, int rollupLevel) throws Exception {
        Long queriesCappedId = null;
        String queries = overallAggregate.queries();
        if (queries != null) {
            queriesCappedId = this.rollupCappedDatabases.get(rollupLevel).write(CharSource.wrap(queries), "aggregate queries");
        }
        Long profileCappedId = null;
        String profile = overallAggregate.profile();
        if (profile != null) {
            profileCappedId = this.rollupCappedDatabases.get(rollupLevel).write(CharSource.wrap(profile), "aggregate profiles");
        }
        int i = startIndex;
        preparedStatement.setLong(i++, overallAggregate.captureTime());
        preparedStatement.setLong(i++, overallAggregate.totalMicros());
        preparedStatement.setLong(i++, overallAggregate.errorCount());
        preparedStatement.setLong(i++, overallAggregate.transactionCount());
        RowMappers.setLong(preparedStatement, i++, overallAggregate.totalCpuMicros());
        RowMappers.setLong(preparedStatement, i++, overallAggregate.totalBlockedMicros());
        RowMappers.setLong(preparedStatement, i++, overallAggregate.totalWaitedMicros());
        RowMappers.setLong(preparedStatement, i++, overallAggregate.totalAllocatedKBytes());
        RowMappers.setLong(preparedStatement, i++, queriesCappedId);
        RowMappers.setLong(preparedStatement, i++, profileCappedId);
        preparedStatement.setBytes(i++, overallAggregate.histogram());
        preparedStatement.setString(i++, overallAggregate.timers());
    }

    public static long getNextRollupTime(long captureTime, long intervalMillis) {
        return (long)Math.ceil((double)captureTime / (double)intervalMillis) * intervalMillis;
    }

    static long getSafeRollupTime(long captureTime, long intervalMillis) {
        return (long)Math.floor((double)captureTime / (double)intervalMillis) * intervalMillis;
    }

    @Untainted
    private static String getSortClause(TransactionSummarySortOrder sortOrder) {
        switch (sortOrder) {
            case TOTAL_TIME: {
                return "sum(total_micros) desc";
            }
            case AVERAGE_TIME: {
                return "sum(total_micros) / sum(transaction_count) desc";
            }
            case THROUGHPUT: {
                return "sum(transaction_count) desc";
            }
        }
        throw new AssertionError((Object)("Unexpected sort order: " + (Object)((Object)sortOrder)));
    }

    @Untainted
    private static String getSortClause(ErrorSummarySortOrder sortOrder) {
        switch (sortOrder) {
            case ERROR_COUNT: {
                return "sum(error_count) desc";
            }
            case ERROR_RATE: {
                return "sum(error_count) / sum(transaction_count) desc";
            }
        }
        throw new AssertionError((Object)("Unexpected sort order: " + (Object)((Object)sortOrder)));
    }

    public static class MergedAggregate {
        private long captureTime;
        private final String transactionType;
        @Nullable
        private final String transactionName;
        private long totalMicros;
        private long errorCount;
        private long transactionCount;
        @Nullable
        private Long totalCpuMicros;
        @Nullable
        private Long totalBlockedMicros;
        @Nullable
        private Long totalWaitedMicros;
        @Nullable
        private Long totalAllocatedKBytes;
        private final LazyHistogram lazyHistogram = new LazyHistogram();
        private final AggregateTimer syntheticRootTimer = AggregateTimer.createSyntheticRootTimer();
        private final QueryComponent queryComponent;
        private final ProfileNode syntheticProfileNode = ProfileNode.createSyntheticRoot();

        public MergedAggregate(long captureTime, String transactionType, @Nullable String transactionName, int maxAggregateQueriesPerQueryType) {
            this.captureTime = captureTime;
            this.transactionType = transactionType;
            this.transactionName = transactionName;
            this.queryComponent = new QueryComponent(maxAggregateQueriesPerQueryType, 0);
        }

        public void setCaptureTime(long captureTime) {
            this.captureTime = captureTime;
        }

        public void addTotalMicros(long totalMicros) {
            this.totalMicros += totalMicros;
        }

        public void addErrorCount(long errorCount) {
            this.errorCount += errorCount;
        }

        public void addTransactionCount(long transactionCount) {
            this.transactionCount += transactionCount;
        }

        public void addTotalCpuMicros(@Nullable Long totalCpuMicros) {
            this.totalCpuMicros = MergedAggregate.nullAwareAdd(this.totalCpuMicros, totalCpuMicros);
        }

        public void addTotalBlockedMicros(@Nullable Long totalBlockedMicros) {
            this.totalBlockedMicros = MergedAggregate.nullAwareAdd(this.totalBlockedMicros, totalBlockedMicros);
        }

        public void addTotalWaitedMicros(@Nullable Long totalWaitedMicros) {
            this.totalWaitedMicros = MergedAggregate.nullAwareAdd(this.totalWaitedMicros, totalWaitedMicros);
        }

        public void addTotalAllocatedKBytes(@Nullable Long totalAllocatedKBytes) {
            this.totalAllocatedKBytes = MergedAggregate.nullAwareAdd(this.totalAllocatedKBytes, totalAllocatedKBytes);
        }

        public void addHistogram(byte[] histogram) throws DataFormatException {
            this.lazyHistogram.decodeFromByteBuffer(ByteBuffer.wrap(histogram));
        }

        public void addTimers(String timers) throws IOException {
            AggregateTimer syntheticRootTimers = mapper.readValue(timers, AggregateTimer.class);
            this.syntheticRootTimer.mergeMatchedTimer(syntheticRootTimers);
        }

        public Aggregate toAggregate(ScratchBuffer scratchBuffer) throws IOException {
            ByteBuffer buffer = scratchBuffer.getBuffer(this.lazyHistogram.getNeededByteBufferCapacity());
            buffer.clear();
            byte[] histogram = this.lazyHistogram.encodeUsingTempByteBuffer(buffer);
            return Aggregate.builder().transactionType(this.transactionType).transactionName(this.transactionName).captureTime(this.captureTime).totalMicros(this.totalMicros).errorCount(this.errorCount).transactionCount(this.transactionCount).totalCpuMicros(this.totalCpuMicros).totalBlockedMicros(this.totalBlockedMicros).totalWaitedMicros(this.totalWaitedMicros).totalAllocatedKBytes(this.totalAllocatedKBytes).histogram(histogram).timers(mapper.writeValueAsString(this.syntheticRootTimer)).queries(this.getQueriesJson()).profile(this.getProfileJson()).build();
        }

        private void addQueries(String queryContent) throws IOException {
            this.queryComponent.mergeQueries(queryContent);
        }

        private void addProfile(String profileContent) throws IOException {
            ProfileNode profileNode = ObjectMappers.readRequiredValue(mapper, profileContent, ProfileNode.class);
            this.syntheticProfileNode.mergeMatchedNode(profileNode);
        }

        @Nullable
        private String getQueriesJson() throws IOException {
            Map<String, List<QueryComponent.AggregateQuery>> queries = this.queryComponent.getOrderedAndTruncatedQueries();
            if (queries.isEmpty()) {
                return null;
            }
            return mapper.writeValueAsString(queries);
        }

        @Nullable
        private String getProfileJson() throws IOException {
            if (this.syntheticProfileNode.getSampleCount() == 0L) {
                return null;
            }
            return mapper.writeValueAsString(this.syntheticProfileNode);
        }

        @Nullable
        private static Long nullAwareAdd(@Nullable Long x, @Nullable Long y) {
            if (x == null) {
                return y;
            }
            if (y == null) {
                return x;
            }
            return x + y;
        }
    }

    private class TransactionRollupResultSetExtractor
    extends RollupResultSetExtractor {
        private final long rollupCaptureTime;
        private final int fromRollupLevel;

        private TransactionRollupResultSetExtractor(long rollupCaptureTime, int fromRollupLevel) {
            this.rollupCaptureTime = rollupCaptureTime;
            this.fromRollupLevel = fromRollupLevel;
        }

        @Override
        public List<Aggregate> extractData(ResultSet resultSet) throws Exception {
            HashMap mergedAggregates = Maps.newHashMap();
            while (resultSet.next()) {
                MergedAggregate mergedAggregate;
                String transactionType = Preconditions.checkNotNull(resultSet.getString(1));
                String transactionName = Preconditions.checkNotNull(resultSet.getString(2));
                HashMap<String, MergedAggregate> mergedAggregateMap = (HashMap<String, MergedAggregate>)mergedAggregates.get(transactionType);
                if (mergedAggregateMap == null) {
                    mergedAggregateMap = Maps.newHashMap();
                    mergedAggregates.put(transactionType, mergedAggregateMap);
                }
                if ((mergedAggregate = (MergedAggregate)mergedAggregateMap.get(transactionName)) == null) {
                    mergedAggregate = new MergedAggregate(this.rollupCaptureTime, transactionType, transactionName, AggregateDao.this.configService.getAdvancedConfig().maxAggregateQueriesPerQueryType());
                    mergedAggregateMap.put(transactionName, mergedAggregate);
                }
                this.merge(mergedAggregate, resultSet, 3, this.fromRollupLevel);
            }
            ArrayList<Aggregate> aggregates = Lists.newArrayList();
            ScratchBuffer scratchBuffer = new ScratchBuffer();
            for (Map mergedAggregateMap : mergedAggregates.values()) {
                for (MergedAggregate mergedAggregate : mergedAggregateMap.values()) {
                    aggregates.add(mergedAggregate.toAggregate(scratchBuffer));
                }
            }
            return aggregates;
        }
    }

    private class OverallRollupResultSetExtractor
    extends RollupResultSetExtractor {
        private final long rollupCaptureTime;
        private final int fromRollupLevel;

        private OverallRollupResultSetExtractor(long rollupCaptureTime, int fromRollupLevel) {
            this.rollupCaptureTime = rollupCaptureTime;
            this.fromRollupLevel = fromRollupLevel;
        }

        @Override
        public List<Aggregate> extractData(ResultSet resultSet) throws Exception {
            HashMap<String, MergedAggregate> mergedAggregates = Maps.newHashMap();
            while (resultSet.next()) {
                String transactionType = Preconditions.checkNotNull(resultSet.getString(1));
                MergedAggregate mergedAggregate = (MergedAggregate)mergedAggregates.get(transactionType);
                if (mergedAggregate == null) {
                    mergedAggregate = new MergedAggregate(this.rollupCaptureTime, transactionType, null, AggregateDao.this.configService.getAdvancedConfig().maxAggregateQueriesPerQueryType());
                    mergedAggregates.put(transactionType, mergedAggregate);
                }
                this.merge(mergedAggregate, resultSet, 2, this.fromRollupLevel);
            }
            ArrayList<Aggregate> aggregates = Lists.newArrayList();
            ScratchBuffer scratchBuffer = new ScratchBuffer();
            for (MergedAggregate mergedAggregate : mergedAggregates.values()) {
                aggregates.add(mergedAggregate.toAggregate(scratchBuffer));
            }
            return aggregates;
        }
    }

    private abstract class RollupResultSetExtractor
    implements DataSource.ResultSetExtractor<List<Aggregate>> {
        private RollupResultSetExtractor() {
        }

        void merge(MergedAggregate mergedAggregate, ResultSet resultSet, int startColumnIndex, int fromRollupLevel) throws Exception {
            String profileContent;
            String queriesContent;
            int i = startColumnIndex;
            long totalMicros = resultSet.getLong(i++);
            long errorCount = resultSet.getLong(i++);
            long transactionCount = resultSet.getLong(i++);
            Long totalCpuMicros = resultSet.getLong(i++);
            Long totalBlockedMicros = RowMappers.getLong(resultSet, i++);
            Long totalWaitedMicros = RowMappers.getLong(resultSet, i++);
            Long totalAllocatedKBytes = RowMappers.getLong(resultSet, i++);
            Long queriesCappedId = RowMappers.getLong(resultSet, i++);
            Long profileCappedId = RowMappers.getLong(resultSet, i++);
            byte[] histogram = Preconditions.checkNotNull(resultSet.getBytes(i++));
            String timers = Preconditions.checkNotNull(resultSet.getString(i++));
            mergedAggregate.addTotalMicros(totalMicros);
            mergedAggregate.addErrorCount(errorCount);
            mergedAggregate.addTransactionCount(transactionCount);
            mergedAggregate.addTotalCpuMicros(totalCpuMicros);
            mergedAggregate.addTotalBlockedMicros(totalBlockedMicros);
            mergedAggregate.addTotalWaitedMicros(totalWaitedMicros);
            mergedAggregate.addTotalAllocatedKBytes(totalAllocatedKBytes);
            mergedAggregate.addHistogram(histogram);
            mergedAggregate.addTimers(timers);
            if (queriesCappedId != null && !(queriesContent = ((CappedDatabase)AggregateDao.this.rollupCappedDatabases.get(fromRollupLevel)).read(queriesCappedId, AggregateDao.OVERWRITTEN).read()).equals(AggregateDao.OVERWRITTEN)) {
                mergedAggregate.addQueries(queriesContent);
            }
            if (profileCappedId != null && !(profileContent = ((CappedDatabase)AggregateDao.this.rollupCappedDatabases.get(fromRollupLevel)).read(profileCappedId, AggregateDao.OVERWRITTEN).read()).equals(AggregateDao.OVERWRITTEN)) {
                mergedAggregate.addProfile(profileContent);
            }
        }
    }

    private static class LongRowMapper
    implements DataSource.RowMapper<Long> {
        private LongRowMapper() {
        }

        @Override
        public Long mapRow(ResultSet resultSet) throws SQLException {
            return resultSet.getLong(1);
        }
    }

    private class ProfileAggregateRowMapper
    implements DataSource.RowMapper<ProfileAggregate> {
        private final int rollupLevel;

        public ProfileAggregateRowMapper(int rollupLevel) {
            this.rollupLevel = rollupLevel;
        }

        @Override
        public ProfileAggregate mapRow(ResultSet resultSet) throws SQLException {
            long captureTime = resultSet.getLong(1);
            CharSource profile = ((CappedDatabase)AggregateDao.this.rollupCappedDatabases.get(this.rollupLevel)).read(resultSet.getLong(2), AggregateDao.OVERWRITTEN);
            return ProfileAggregate.of(captureTime, profile);
        }
    }

    private class QueryAggregateRowMapper
    implements DataSource.RowMapper<QueryAggregate> {
        private final int rollupLevel;

        public QueryAggregateRowMapper(int rollupLevel) {
            this.rollupLevel = rollupLevel;
        }

        @Override
        public QueryAggregate mapRow(ResultSet resultSet) throws SQLException {
            long captureTime = resultSet.getLong(1);
            CharSource queries = ((CappedDatabase)AggregateDao.this.rollupCappedDatabases.get(this.rollupLevel)).read(resultSet.getLong(2), AggregateDao.OVERWRITTEN);
            return QueryAggregate.of(captureTime, queries);
        }
    }

    private static class ErrorPointRowMapper
    implements DataSource.RowMapper<ErrorPoint> {
        private ErrorPointRowMapper() {
        }

        @Override
        public ErrorPoint mapRow(ResultSet resultSet) throws SQLException {
            long captureTime = resultSet.getLong(1);
            long errorCount = resultSet.getLong(2);
            long transactionCount = resultSet.getLong(3);
            return ErrorPoint.of(captureTime, errorCount, transactionCount);
        }
    }

    private static class AggregateRowMapper
    implements DataSource.RowMapper<Aggregate> {
        private final String transactionType;
        @Nullable
        private final String transactionName;

        private AggregateRowMapper(String transactionType, @Nullable String transactionName) {
            this.transactionType = transactionType;
            this.transactionName = transactionName;
        }

        @Override
        public Aggregate mapRow(ResultSet resultSet) throws SQLException {
            int i = 1;
            return Aggregate.builder().transactionType(this.transactionType).transactionName(this.transactionName).captureTime(resultSet.getLong(i++)).totalMicros(resultSet.getLong(i++)).errorCount(resultSet.getLong(i++)).transactionCount(resultSet.getLong(i++)).totalCpuMicros(resultSet.getLong(i++)).totalBlockedMicros(resultSet.getLong(i++)).totalWaitedMicros(resultSet.getLong(i++)).totalAllocatedKBytes(resultSet.getLong(i++)).histogram(Preconditions.checkNotNull(resultSet.getBytes(i++))).timers(Preconditions.checkNotNull(resultSet.getString(i++))).build();
        }
    }

    private static class ErrorSummaryRowMapper
    implements DataSource.RowMapper<ErrorSummary> {
        private ErrorSummaryRowMapper() {
        }

        @Override
        public ErrorSummary mapRow(ResultSet resultSet) throws SQLException {
            String transactionName = resultSet.getString(1);
            if (transactionName == null) {
                throw new SQLException("Found null transaction_name in transaction_aggregate");
            }
            return ErrorSummary.builder().transactionName(transactionName).errorCount(resultSet.getLong(2)).transactionCount(resultSet.getLong(3)).build();
        }
    }

    private static class OverallErrorSummaryResultSetExtractor
    implements DataSource.ResultSetExtractor<ErrorSummary> {
        private OverallErrorSummaryResultSetExtractor() {
        }

        @Override
        public ErrorSummary extractData(ResultSet resultSet) throws SQLException {
            if (!resultSet.next()) {
                throw new SQLException("Aggregate query did not return any results");
            }
            return ErrorSummary.builder().errorCount(resultSet.getLong(1)).transactionCount(resultSet.getLong(2)).build();
        }
    }

    private static class TransactionSummaryRowMapper
    implements DataSource.RowMapper<TransactionSummary> {
        private TransactionSummaryRowMapper() {
        }

        @Override
        public TransactionSummary mapRow(ResultSet resultSet) throws SQLException {
            String transactionName = resultSet.getString(1);
            if (transactionName == null) {
                throw new SQLException("Found null transaction_name in transaction_aggregate");
            }
            return TransactionSummary.builder().transactionName(transactionName).totalMicros(resultSet.getLong(2)).transactionCount(resultSet.getLong(3)).build();
        }
    }

    private static class OverallSummaryResultSetExtractor
    implements DataSource.ResultSetExtractor<TransactionSummary> {
        private OverallSummaryResultSetExtractor() {
        }

        @Override
        public TransactionSummary extractData(ResultSet resultSet) throws SQLException {
            if (!resultSet.next()) {
                throw new SQLException("Aggregate query did not return any results");
            }
            return TransactionSummary.builder().totalMicros(resultSet.getLong(1)).transactionCount(resultSet.getLong(2)).build();
        }
    }

    private class TransactionBatchAdder
    implements DataSource.BatchAdder {
        private final List<Aggregate> transactionAggregates;
        private final int rollupLevel;

        private TransactionBatchAdder(List<Aggregate> transactionAggregates, int rollupLevel) {
            this.transactionAggregates = transactionAggregates;
            this.rollupLevel = rollupLevel;
        }

        @Override
        public void addBatches(PreparedStatement preparedStatement) throws Exception {
            for (Aggregate transactionAggregate : this.transactionAggregates) {
                preparedStatement.setString(1, transactionAggregate.transactionType());
                preparedStatement.setString(2, transactionAggregate.transactionName());
                AggregateDao.this.bindCommon(preparedStatement, transactionAggregate, 3, this.rollupLevel);
                preparedStatement.addBatch();
            }
        }
    }

    private class OverallBatchAdder
    implements DataSource.BatchAdder {
        private final List<Aggregate> overallAggregates;
        private final int rollupLevel;

        private OverallBatchAdder(List<Aggregate> overallAggregates, int rollupLevel) {
            this.overallAggregates = overallAggregates;
            this.rollupLevel = rollupLevel;
        }

        @Override
        public void addBatches(PreparedStatement preparedStatement) throws Exception {
            for (Aggregate overallAggregate : this.overallAggregates) {
                preparedStatement.setString(1, overallAggregate.transactionType());
                AggregateDao.this.bindCommon(preparedStatement, overallAggregate, 2, this.rollupLevel);
                preparedStatement.addBatch();
            }
        }
    }

    public static enum ErrorSummarySortOrder {
        ERROR_COUNT,
        ERROR_RATE;

    }

    public static enum TransactionSummarySortOrder {
        TOTAL_TIME,
        AVERAGE_TIME,
        THROUGHPUT;

    }

    @Value.Immutable
    public static abstract class ErrorSummaryQueryBase {
        public abstract String transactionType();

        public abstract long from();

        public abstract long to();

        public abstract ErrorSummarySortOrder sortOrder();

        public abstract int limit();
    }

    @Value.Immutable
    public static abstract class TransactionSummaryQueryBase {
        public abstract String transactionType();

        public abstract long from();

        public abstract long to();

        public abstract TransactionSummarySortOrder sortOrder();

        public abstract int limit();
    }
}

