/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

public class CappedDatabaseStats {
    private long totalBytesBeforeCompression;
    private long totalBytesAfterCompression;
    private long totalMicros;
    private long totalWrites;

    public long getTotalBytesBeforeCompression() {
        return this.totalBytesBeforeCompression;
    }

    public long getTotalBytesAfterCompression() {
        return this.totalBytesAfterCompression;
    }

    public double getTotalMillis() {
        return (double)this.totalMicros / 1000.0;
    }

    public long getTotalWrites() {
        return this.totalWrites;
    }

    public double getCompressionRatio() {
        return (double)(this.totalBytesBeforeCompression - this.totalBytesAfterCompression) / (double)this.totalBytesBeforeCompression;
    }

    public double getAverageBytesPerWriteBeforeCompression() {
        return (double)this.totalBytesBeforeCompression / (double)this.totalWrites;
    }

    public double getAverageBytesPerWriteAfterCompression() {
        return (double)this.totalBytesAfterCompression / (double)this.totalWrites;
    }

    public double getAverageMillisPerWrite() {
        return (double)this.totalMicros / (double)(1000L * this.totalWrites);
    }

    void record(long bytesBeforeCompression, long bytesAfterCompression, long micros) {
        this.totalBytesBeforeCompression += bytesBeforeCompression;
        this.totalBytesAfterCompression += bytesAfterCompression;
        this.totalMicros += micros;
        ++this.totalWrites;
    }
}

