/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.local.store.Column;
import org.glowroot.local.store.Index;
import org.glowroot.local.store.ResultSetCloser;
import org.glowroot.local.store.Schemas;
import org.glowroot.local.store.StatementCloser;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.Joiner;
import org.glowroot.shaded.google.common.base.Throwables;
import org.glowroot.shaded.google.common.cache.CacheBuilder;
import org.glowroot.shaded.google.common.cache.CacheLoader;
import org.glowroot.shaded.google.common.cache.LoadingCache;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.h2.jdbc.JdbcConnection;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class DataSource {
    private static final Logger logger = LoggerFactory.getLogger(DataSource.class);
    private static final int CACHE_SIZE = Integer.getInteger("glowroot.internal.h2.cacheSize", 8192);
    @Nullable
    private final File dbFile;
    private final Thread shutdownHookThread;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private Connection connection;
    private volatile int queryTimeoutSeconds;
    private volatile boolean closing = false;
    private final LoadingCache<String, PreparedStatement> preparedStatementCache = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<String, PreparedStatement>(){

        @Override
        public PreparedStatement load(@Untainted String sql) throws SQLException {
            return DataSource.this.connection.prepareStatement(sql);
        }
    });

    DataSource() throws SQLException {
        this.dbFile = null;
        this.connection = DataSource.createConnection(null);
        this.shutdownHookThread = new ShutdownHookThread();
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
    }

    DataSource(File dbFile) throws SQLException {
        this.dbFile = dbFile;
        this.connection = DataSource.createConnection(dbFile);
        this.shutdownHookThread = new ShutdownHookThread();
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
    }

    void setQueryTimeoutSeconds(Integer queryTimeoutSeconds) {
        this.queryTimeoutSeconds = queryTimeoutSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defrag() throws SQLException {
        if (this.dbFile == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return;
            }
            this.execute("shutdown defrag");
            this.preparedStatementCache.invalidateAll();
            this.connection = DataSource.createConnection(this.dbFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(@Untainted String sql) throws SQLException {
        DataSource.debug(sql, new Object[0]);
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return;
            }
            Statement statement = this.connection.createStatement();
            StatementCloser closer = new StatementCloser(statement);
            try {
                statement.execute(sql);
            }
            catch (Throwable t) {
                throw closer.rethrow(t);
            }
            finally {
                closer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long queryForLong(final @Untainted String sql, Object ... args) throws SQLException {
        DataSource.debug(sql, args);
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return 0L;
            }
            return this.queryUnderLock(sql, args, new ResultSetExtractor<Long>(){

                @Override
                public Long extractData(ResultSet resultSet) throws SQLException {
                    if (resultSet.next()) {
                        return resultSet.getLong(1);
                    }
                    logger.warn("query didn't return any results: {}", (Object)sql);
                    return 0L;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean queryForExists(@Untainted String sql, Object ... args) throws SQLException {
        DataSource.debug(sql, args);
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return false;
            }
            return this.queryUnderLock(sql, args, new ResultSetExtractor<Boolean>(){

                @Override
                public Boolean extractData(ResultSet resultSet) throws SQLException {
                    return resultSet.next();
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> ImmutableList<T> query(@Untainted String sql, RowMapper<T> rowMapper, Object ... args) throws SQLException {
        DataSource.debug(sql, args);
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return ImmutableList.of();
            }
            PreparedStatement preparedStatement = this.prepareStatement(sql);
            for (int i = 0; i < args.length; ++i) {
                preparedStatement.setObject(i + 1, args[i]);
            }
            preparedStatement.setQueryTimeout(this.queryTimeoutSeconds);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetCloser closer = new ResultSetCloser(resultSet);
            try {
                ArrayList<T> mappedRows = Lists.newArrayList();
                while (resultSet.next()) {
                    mappedRows.add(rowMapper.mapRow(resultSet));
                }
                ImmutableList immutableList = ImmutableList.copyOf(mappedRows);
                return immutableList;
            }
            catch (Throwable t) {
                throw closer.rethrow(t);
            }
            finally {
                closer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T query(@Untainted String sql, ResultSetExtractor<T> rse, Object ... args) throws SQLException {
        DataSource.debug(sql, args);
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return null;
            }
            return this.queryUnderLock(sql, args, rse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int update(@Untainted String sql, Object ... args) throws SQLException {
        DataSource.debug(sql, args);
        if (this.closing) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return 0;
            }
            PreparedStatement preparedStatement = this.prepareStatement(sql);
            for (int i = 0; i < args.length; ++i) {
                preparedStatement.setObject(i + 1, args[i]);
            }
            preparedStatement.setQueryTimeout(0);
            return preparedStatement.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] batchUpdate(@Untainted String sql, BatchAdder batchAdder) throws Exception {
        DataSource.debug(sql, new Object[0]);
        if (this.closing) {
            return new int[0];
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return new int[0];
            }
            PreparedStatement preparedStatement = this.prepareStatement(sql);
            batchAdder.addBatches(preparedStatement);
            preparedStatement.setQueryTimeout(0);
            return preparedStatement.executeBatch();
        }
    }

    void deleteBefore(@Untainted String tableName, long captureTime) throws SQLException {
        int deleted;
        while ((deleted = this.update("delete from " + tableName + " where capture_time < ? limit 100", captureTime)) != 0) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncTable(@Untainted String tableName, List<Column> columns) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return;
            }
            Schemas.syncTable(tableName, columns, this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncIndexes(@Untainted String tableName, ImmutableList<Index> indexes) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return;
            }
            Schemas.syncIndexes(tableName, indexes, this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImmutableList<Column> getColumns(String tableName) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return ImmutableList.of();
            }
            return Schemas.getColumns(tableName, this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tableExists(String tableName) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            return !this.closing && Schemas.tableExists(tableName, this.connection);
        }
    }

    long getDbFileSize() {
        return this.dbFile == null ? 0L : this.dbFile.length();
    }

    void renameTable(@Untainted String oldTableName, @Untainted String newTableName) throws SQLException {
        if (Schemas.tableExists(oldTableName, this.connection)) {
            this.execute("alter table " + oldTableName + " rename to " + newTableName);
        }
    }

    void renameColumn(@Untainted String tableName, @Untainted String oldColumnName, @Untainted String newColumnName) throws SQLException {
        if (Schemas.columnExists(tableName, oldColumnName, this.connection)) {
            this.execute("alter table " + tableName + " alter column " + oldColumnName + " rename to " + newColumnName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyUsedByTests
    void close() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return;
            }
            this.closing = true;
            this.connection.close();
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
    }

    private <T> T queryUnderLock(@Untainted String sql, Object[] args, ResultSetExtractor<T> rse) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(sql);
        for (int i = 0; i < args.length; ++i) {
            preparedStatement.setObject(i + 1, args[i]);
        }
        preparedStatement.setQueryTimeout(this.queryTimeoutSeconds);
        ResultSet resultSet = preparedStatement.executeQuery();
        ResultSetCloser closer = new ResultSetCloser(resultSet);
        try {
            T t = rse.extractData(resultSet);
            return t;
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    private PreparedStatement prepareStatement(@Untainted String sql) throws SQLException {
        try {
            return this.preparedStatementCache.get(sql);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfPossible(cause, SQLException.class);
            logger.error(e.getMessage(), e);
            throw new SQLException(e);
        }
    }

    private static Connection createConnection(@Nullable File dbFile) throws SQLException {
        try {
            Class.forName("org.glowroot.shaded.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e);
        }
        if (dbFile == null) {
            return new JdbcConnection("jdbc:h2:mem:;compress=true;db_close_on_exit=false", new Properties());
        }
        String dbPath = dbFile.getPath();
        dbPath = dbPath.replaceFirst(".h2.db$", "");
        Properties props = new Properties();
        props.setProperty("user", "sa");
        props.setProperty("password", "");
        String url = "jdbc:h2:" + dbPath + ";compress=true;db_close_on_exit=false;cache_size=" + CACHE_SIZE;
        return new JdbcConnection(url, props);
    }

    private static void debug(String sql, Object ... args) {
        DataSource.debug(logger, sql, args);
    }

    @VisibleForTesting
    static void debug(Logger logger, String sql, Object ... args) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (args.length == 0) {
            logger.debug(sql);
            return;
        }
        ArrayList<String> argStrings = Lists.newArrayList();
        for (Object arg : args) {
            if (arg instanceof String) {
                argStrings.add('\'' + (String)arg + '\'');
                continue;
            }
            if (arg == null) {
                argStrings.add("NULL");
                continue;
            }
            argStrings.add(arg.toString());
        }
        logger.debug("{} [{}]", (Object)sql, (Object)Joiner.on(", ").join(argStrings));
    }

    private class ShutdownHookThread
    extends Thread {
        private ShutdownHookThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DataSource.this.closing = true;
                Object object = DataSource.this.lock;
                synchronized (object) {
                    DataSource.this.connection.close();
                }
            }
            catch (SQLException e) {
                logger.warn(e.getMessage(), e);
            }
        }
    }

    static interface ResultSetExtractor<T> {
        public T extractData(ResultSet var1) throws Exception;
    }

    static interface RowMapper<T> {
        public T mapRow(ResultSet var1) throws SQLException;
    }

    static interface BatchAdder {
        public void addBatches(PreparedStatement var1) throws Exception;
    }
}

