/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.store.GaugeMetaDao;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
final class GaugeMeta
extends GaugeMetaDao.GaugeMetaBase {
    private final long id;
    private final boolean everIncreasing;

    private GaugeMeta(long id, boolean everIncreasing) {
        this.id = id;
        this.everIncreasing = everIncreasing;
    }

    @Override
    @JsonProperty(value="id")
    public long id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="everIncreasing")
    public boolean everIncreasing() {
        return this.everIncreasing;
    }

    public final GaugeMeta withId(long value) {
        if (this.id == value) {
            return this;
        }
        long newValue = value;
        return new GaugeMeta(newValue, this.everIncreasing);
    }

    public final GaugeMeta withEverIncreasing(boolean value) {
        if (this.everIncreasing == value) {
            return this;
        }
        boolean newValue = value;
        return new GaugeMeta(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof GaugeMeta && this.equalTo((GaugeMeta)another);
    }

    private boolean equalTo(GaugeMeta another) {
        return this.id == another.id && this.everIncreasing == another.everIncreasing;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.id);
        h = h * 17 + Booleans.hashCode(this.everIncreasing);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GaugeMeta").add("id", this.id).add("everIncreasing", this.everIncreasing).toString();
    }

    @JsonCreator
    public static GaugeMeta fromAllAttributes(@JsonProperty(value="id") @Nullable Long id, @JsonProperty(value="everIncreasing") @Nullable Boolean everIncreasing) {
        Builder builder = GaugeMeta.builder();
        if (id != null) {
            builder.id(id);
        }
        if (everIncreasing != null) {
            builder.everIncreasing(everIncreasing);
        }
        return builder.build();
    }

    public static GaugeMeta of(long id, boolean everIncreasing) {
        return new GaugeMeta(id, everIncreasing);
    }

    static GaugeMeta copyOf(GaugeMetaDao.GaugeMetaBase instance) {
        if (instance instanceof GaugeMeta) {
            return (GaugeMeta)instance;
        }
        return GaugeMeta.builder().id(instance.id()).everIncreasing(instance.everIncreasing()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_ID = 1L;
        private static final long INITIALIZED_BIT_EVER_INCREASING = 2L;
        private long initializedBitset;
        private long id;
        private boolean everIncreasing;

        private Builder() {
        }

        public final Builder id(long id) {
            this.checkNotIsSet(this.idIsSet(), "id");
            this.id = id;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder everIncreasing(boolean everIncreasing) {
            this.checkNotIsSet(this.everIncreasingIsSet(), "everIncreasing");
            this.everIncreasing = everIncreasing;
            this.initializedBitset |= 2L;
            return this;
        }

        public GaugeMeta build() {
            this.checkRequiredAttributes();
            return new GaugeMeta(this.id, this.everIncreasing);
        }

        private boolean idIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean everIncreasingIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of GaugeMeta is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.everIncreasingIsSet()) {
                attributes.add("everIncreasing");
            }
            return "Cannot build GaugeMeta, some of required attributes are not set " + attributes;
        }
    }
}

