/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.collector.GaugePoint;
import org.glowroot.collector.GaugePointRepository;
import org.glowroot.common.Checkers;
import org.glowroot.common.Clock;
import org.glowroot.config.ConfigService;
import org.glowroot.config.RollupConfig;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.store.Column;
import org.glowroot.local.store.DataSource;
import org.glowroot.local.store.GaugeMeta;
import org.glowroot.local.store.GaugeMetaDao;
import org.glowroot.local.store.Index;
import org.glowroot.shaded.google.common.base.Joiner;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

public class GaugePointDao
implements GaugePointRepository {
    private static final ImmutableList<Column> gaugePointRollup0Columns = ImmutableList.of(Column.of("gauge_meta_id", -5), Column.of("capture_time", -5), Column.of("value", 8));
    private static final ImmutableList<Column> gaugePointRollupColumns = ImmutableList.of(Column.of("gauge_meta_id", -5), Column.of("capture_time", -5), Column.of("value", 8), Column.of("count", 8));
    private static final ImmutableList<Index> gaugePointRollup0Indexes = ImmutableList.of(Index.of("gauge_point_rollup_0_idx", ImmutableList.of("gauge_meta_id", "capture_time", "value")));
    private final GaugeMetaDao gaugeMetaDao;
    private final DataSource dataSource;
    private final ConfigService configService;
    private final Clock clock;
    private final ImmutableList<RollupConfig> rollupConfigs;
    private final AtomicLongArray lastRollupTimes;
    private final Object rollupLock = new Object();

    GaugePointDao(DataSource dataSource, ConfigService configService, Clock clock) throws SQLException {
        this.gaugeMetaDao = new GaugeMetaDao(dataSource);
        this.dataSource = dataSource;
        this.configService = configService;
        this.clock = clock;
        this.rollupConfigs = configService.getRollupConfigs();
        dataSource.syncTable("gauge_point_rollup_0", gaugePointRollup0Columns);
        dataSource.syncIndexes("gauge_point_rollup_0", gaugePointRollup0Indexes);
        for (int i = 1; i <= this.rollupConfigs.size(); ++i) {
            dataSource.syncTable("gauge_point_rollup_" + Checkers.castUntainted(i), gaugePointRollupColumns);
            dataSource.syncIndexes("gauge_point_rollup_" + Checkers.castUntainted(i), ImmutableList.of(Index.of("gauge_point_rollup_" + Checkers.castUntainted(i) + "_idx", ImmutableList.of("gauge_meta_id", "capture_time", "value"))));
        }
        ArrayList<Column> columns = Lists.newArrayList();
        for (int i = 1; i <= this.rollupConfigs.size(); ++i) {
            columns.add(Column.of("last_rollup_" + i + "_time", -5));
        }
        dataSource.syncTable("gauge_point_last_rollup_times", columns);
        ArrayList<String> columnNames = Lists.newArrayList();
        for (int i = 1; i <= this.rollupConfigs.size(); ++i) {
            columnNames.add("last_rollup_" + i + "_time");
        }
        Joiner joiner = Joiner.on(", ");
        String selectClause = Checkers.castUntainted(joiner.join(columnNames));
        long[] lastRollupTimes = dataSource.query("select " + selectClause + " from gauge_point_last_rollup_times", new LastRollupTimesExtractor(), new Object[0]);
        if (lastRollupTimes == null) {
            long[] values = new long[this.rollupConfigs.size()];
            String valueClause = Checkers.castUntainted(joiner.join(Longs.asList(values)));
            dataSource.update("insert into gauge_point_last_rollup_times (" + selectClause + ") values (" + valueClause + ")", new Object[0]);
            this.lastRollupTimes = new AtomicLongArray(values);
        } else {
            this.lastRollupTimes = new AtomicLongArray(lastRollupTimes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(final List<GaugePoint> gaugePoints) throws Exception {
        if (gaugePoints.isEmpty()) {
            return;
        }
        this.dataSource.batchUpdate("insert into gauge_point_rollup_0 (gauge_meta_id, capture_time, value) values (?, ?, ?)", new DataSource.BatchAdder(){

            @Override
            public void addBatches(PreparedStatement preparedStatement) throws SQLException {
                for (GaugePoint gaugePoint : gaugePoints) {
                    Boolean everIncreasing = gaugePoint.everIncreasing();
                    Preconditions.checkNotNull(everIncreasing);
                    long gaugeMetaId = GaugePointDao.this.gaugeMetaDao.getOrCreateGaugeMetaId(gaugePoint.gaugeName(), everIncreasing);
                    preparedStatement.setLong(1, gaugeMetaId);
                    preparedStatement.setLong(2, gaugePoint.captureTime());
                    preparedStatement.setDouble(3, gaugePoint.value());
                    preparedStatement.addBatch();
                }
            }
        });
        Object object = this.rollupLock;
        synchronized (object) {
            long safeCurrentTime = this.clock.currentTimeMillis() - 1L;
            for (int i = 0; i < this.rollupConfigs.size(); ++i) {
                long lastRollupTime;
                long intervalMillis = ((RollupConfig)this.rollupConfigs.get(i)).intervalMillis();
                long safeRollupTime = AggregateDao.getSafeRollupTime(safeCurrentTime, intervalMillis);
                if (safeRollupTime <= (lastRollupTime = this.lastRollupTimes.get(i))) continue;
                this.rollup(lastRollupTime, safeRollupTime, intervalMillis, i + 1, i);
                this.dataSource.update("update gauge_point_last_rollup_times set last_rollup_" + Checkers.castUntainted(i + 1) + "_time = ?", safeRollupTime);
                this.lastRollupTimes.set(i, safeRollupTime);
            }
        }
    }

    public ImmutableList<GaugePoint> readGaugePoints(String gaugeName, long captureTimeFrom, long captureTimeTo, int rollupLevel) throws SQLException {
        String tableName = "gauge_point_rollup_" + Checkers.castUntainted(rollupLevel);
        GaugeMeta gaugeMeta = this.gaugeMetaDao.getGaugeMetaId(gaugeName);
        if (gaugeMeta == null) {
            return ImmutableList.of();
        }
        return this.dataSource.query("select distinct capture_time, value from " + tableName + " where gauge_meta_id = ? and capture_time >= ? and capture_time <= ?" + " order by capture_time", new GaugePointRowMapper(gaugeName), gaugeMeta.id(), captureTimeFrom, captureTimeTo);
    }

    public List<GaugePoint> readManuallyRolledUpGaugePoints(long from, long to, String gaugeName, int rollupLevel, long liveCaptureTime) throws SQLException {
        long fixedIntervalMillis = ((RollupConfig)this.rollupConfigs.get(rollupLevel - 1)).intervalMillis();
        GaugeMeta gaugeMeta = this.gaugeMetaDao.getGaugeMetaId(gaugeName);
        if (gaugeMeta == null) {
            return ImmutableList.of();
        }
        String aggregateFunction = gaugeMeta.everIncreasing() ? "max" : "avg";
        String captureTimeSql = Checkers.castUntainted("ceil(capture_time / " + fixedIntervalMillis + ".0) * " + fixedIntervalMillis);
        ImmutableList<GaugePoint> gaugePoints = this.dataSource.query("select " + captureTimeSql + " ceil_capture_time, " + aggregateFunction + "(value) from gauge_point_rollup_0" + " where gauge_meta_id = ? and capture_time > ? and capture_time <= ?" + " group by ceil_capture_time order by ceil_capture_time", new GaugePointRowMapper(gaugeName), gaugeMeta.id(), from, to);
        if (gaugePoints.isEmpty()) {
            return ImmutableList.of();
        }
        GaugePoint lastGaugePoint = (GaugePoint)gaugePoints.get(gaugePoints.size() - 1);
        if (lastGaugePoint.captureTime() <= liveCaptureTime) {
            return gaugePoints;
        }
        ArrayList<GaugePoint> correctedGaugePoints = Lists.newArrayList(gaugePoints);
        correctedGaugePoints.set(correctedGaugePoints.size() - 1, lastGaugePoint.withCaptureTime(liveCaptureTime));
        return correctedGaugePoints;
    }

    public int getRollupLevelForView(long from, long to) {
        long millis = to - from;
        long timeAgoMillis = this.clock.currentTimeMillis() - from;
        ImmutableList<Integer> rollupExpirationHours = this.configService.getStorageConfig().rollupExpirationHours();
        if (millis < ((RollupConfig)this.rollupConfigs.get(0)).viewThresholdMillis() && TimeUnit.HOURS.toMillis(((Integer)rollupExpirationHours.get(0)).intValue()) > timeAgoMillis) {
            return 0;
        }
        for (int i = 0; i < this.rollupConfigs.size() - 1; ++i) {
            if (millis >= ((RollupConfig)this.rollupConfigs.get(i + 1)).viewThresholdMillis() || TimeUnit.HOURS.toMillis(((Integer)rollupExpirationHours.get(i)).intValue()) <= timeAgoMillis) continue;
            return i + 1;
        }
        return this.rollupConfigs.size();
    }

    public void deleteAll() throws SQLException {
        this.dataSource.execute("truncate table gauge_point_rollup_0");
        for (int i = 1; i <= this.configService.getRollupConfigs().size(); ++i) {
            this.dataSource.execute("truncate table gauge_point_rollup_" + Checkers.castUntainted(i));
        }
    }

    void deleteBefore(long captureTime, int rollupLevel) throws SQLException {
        this.dataSource.deleteBefore("gauge_point_rollup_" + Checkers.castUntainted(rollupLevel), captureTime);
    }

    private void rollup(long lastRollupTime, long safeRollupTime, long fixedIntervalMillis, int toRollupLevel, int fromRollupLevel) throws SQLException {
        int offsetMillis = TimeZone.getDefault().getOffset(safeRollupTime);
        String captureTimeSql = Checkers.castUntainted("ceil((capture_time + " + offsetMillis + ") / " + fixedIntervalMillis + ".0) * " + fixedIntervalMillis + " - " + offsetMillis);
        this.rollup(lastRollupTime, safeRollupTime, captureTimeSql, false, toRollupLevel, fromRollupLevel);
        this.rollup(lastRollupTime, safeRollupTime, captureTimeSql, true, toRollupLevel, fromRollupLevel);
    }

    private void rollup(long lastRollupTime, long safeRollupTime, @Untainted String captureTimeSql, boolean everIncreasing, int toRollupLevel, int fromRollupLevel) throws SQLException {
        String aggregateFunction = everIncreasing ? "max" : "avg";
        this.dataSource.update("insert into gauge_point_rollup_" + Checkers.castUntainted(toRollupLevel) + " (gauge_meta_id, capture_time, value, count) select gauge_meta_id, " + captureTimeSql + " ceil_capture_time, " + aggregateFunction + "(value), count(*) from gauge_point_rollup_" + Checkers.castUntainted(fromRollupLevel) + " gp, gauge_meta gm where gp.capture_time > ? and gp.capture_time <= ?" + " and gp.gauge_meta_id = gm.id and gm.ever_increasing = ?" + " group by gp.gauge_meta_id, ceil_capture_time", lastRollupTime, safeRollupTime, everIncreasing);
    }

    private static class GaugePointRowMapper
    implements DataSource.RowMapper<GaugePoint> {
        private final String gaugeName;

        public GaugePointRowMapper(String gaugeName) {
            this.gaugeName = gaugeName;
        }

        @Override
        public GaugePoint mapRow(ResultSet resultSet) throws SQLException {
            long captureTime = resultSet.getLong(1);
            double value = resultSet.getDouble(2);
            return GaugePoint.builder().gaugeName(this.gaugeName).captureTime(captureTime).value(value).build();
        }
    }

    private static class LastRollupTimesExtractor
    implements DataSource.ResultSetExtractor<long[]> {
        private LastRollupTimesExtractor() {
        }

        @Override
        public long[] extractData(ResultSet resultSet) throws Exception {
            if (!resultSet.next()) {
                return null;
            }
            int columns = resultSet.getMetaData().getColumnCount();
            long[] values = new long[columns];
            for (int i = 0; i < columns; ++i) {
                values[i] = resultSet.getLong(i + 1);
            }
            return values;
        }
    }
}

