/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.glowroot.common.Clock;
import org.glowroot.common.ScheduledRunnable;
import org.glowroot.config.ConfigService;
import org.glowroot.config.StorageConfig;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.store.GaugePointDao;
import org.glowroot.local.store.TraceDao;

class ReaperRunnable
extends ScheduledRunnable {
    private final ConfigService configService;
    private final AggregateDao aggregateDao;
    private final TraceDao traceDao;
    private final GaugePointDao gaugePointDao;
    private final Clock clock;

    ReaperRunnable(ConfigService configService, AggregateDao aggregateDao, TraceDao traceDao, GaugePointDao gaugePointDao, Clock clock) {
        this.configService = configService;
        this.aggregateDao = aggregateDao;
        this.traceDao = traceDao;
        this.gaugePointDao = gaugePointDao;
        this.clock = clock;
    }

    @Override
    protected void runInternal() throws SQLException {
        StorageConfig storageConfig = this.configService.getStorageConfig();
        long currentTime = this.clock.currentTimeMillis();
        for (int i = 0; i < storageConfig.rollupExpirationHours().size(); ++i) {
            int hours = (Integer)storageConfig.rollupExpirationHours().get(i);
            long captureTime = currentTime - TimeUnit.HOURS.toMillis(hours);
            this.aggregateDao.deleteBefore(captureTime, i);
            if (i == 0) {
                this.gaugePointDao.deleteBefore(captureTime, i);
            }
            this.gaugePointDao.deleteBefore(captureTime, i + 1);
        }
        long traceCaptureTime = currentTime - TimeUnit.HOURS.toMillis(storageConfig.traceExpirationHours());
        this.traceDao.deleteBefore(traceCaptureTime);
    }
}

