/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.common.Checkers;
import org.glowroot.common.Styles;
import org.glowroot.local.store.Column;
import org.glowroot.local.store.Index;
import org.glowroot.local.store.ResultSetCloser;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ArrayListMultimap;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.immutables.value.Value;

class Schemas {
    private static final Logger logger = LoggerFactory.getLogger(Schemas.class);
    private static final Map<Integer, String> sqlTypeNames = Maps.newHashMap();

    private Schemas() {
    }

    static void syncTable(@Untainted String tableName, List<Column> columns, Connection connection) throws SQLException {
        if (!Schemas.tableExists(tableName, connection)) {
            Schemas.createTable(tableName, columns, connection);
        } else if (Schemas.tableNeedsUpgrade(tableName, columns, connection)) {
            logger.warn("upgrading table {}, which unfortunately at this point just means dropping and re-create the table (losing existing data)", (Object)tableName);
            Schemas.execute("drop table " + tableName, connection);
            Schemas.createTable(tableName, columns, connection);
        }
    }

    static void syncIndexes(@Untainted String tableName, ImmutableList<Index> indexes, Connection connection) throws SQLException {
        ImmutableSet<Index> desiredIndexes = ImmutableSet.copyOf(indexes);
        ImmutableSet<Index> existingIndexes = Schemas.getIndexes(tableName, connection);
        for (Index index : Sets.difference(existingIndexes, desiredIndexes)) {
            Schemas.execute("drop index " + index.name(), connection);
        }
        for (Index index : Sets.difference(desiredIndexes, existingIndexes)) {
            Schemas.createIndex(tableName, index, connection);
        }
        existingIndexes = Schemas.getIndexes(tableName, connection);
        if (!existingIndexes.equals(desiredIndexes)) {
            logger.error("the logic in syncIndexes() needs fixing");
        }
    }

    static boolean tableExists(String tableName, Connection connection) throws SQLException {
        logger.debug("tableExists(): tableName={}", (Object)tableName);
        ResultSet resultSet = connection.getMetaData().getTables(null, null, tableName.toUpperCase(Locale.ENGLISH), null);
        ResultSetCloser closer = new ResultSetCloser(resultSet);
        try {
            boolean bl = resultSet.next();
            return bl;
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    static boolean columnExists(String tableName, String columnName, Connection connection) throws SQLException {
        logger.debug("columnExists(): tableName={}, columnName={}", (Object)tableName, (Object)columnName);
        ResultSet resultSet = connection.getMetaData().getColumns(null, null, tableName.toUpperCase(Locale.ENGLISH), columnName.toUpperCase(Locale.ENGLISH));
        ResultSetCloser closer = new ResultSetCloser(resultSet);
        try {
            boolean bl = resultSet.next();
            return bl;
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    static ImmutableList<Column> getColumns(String tableName, Connection connection) throws SQLException {
        ArrayList<Column> columns = Lists.newArrayList();
        ResultSet resultSet = connection.getMetaData().getColumns(null, null, tableName.toUpperCase(Locale.ENGLISH), null);
        ResultSetCloser closer = new ResultSetCloser(resultSet);
        try {
            while (resultSet.next()) {
                String columnName = Preconditions.checkNotNull(resultSet.getString("COLUMN_NAME"));
                int columnType = resultSet.getInt("DATA_TYPE");
                columns.add(Column.of(columnName.toLowerCase(Locale.ENGLISH), columnType));
            }
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
        return ImmutableList.copyOf(columns);
    }

    private static void createTable(@Untainted String tableName, List<Column> columns, Connection connection) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("create table ");
        sql.append(tableName);
        sql.append(" (");
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            String sqlTypeName = sqlTypeNames.get(columns.get(i).type());
            Preconditions.checkNotNull(sqlTypeName, "Unexpected sql type: %s", columns.get(i).type());
            sql.append(columns.get(i).name());
            sql.append(" ");
            sql.append(sqlTypeName);
            if (columns.get(i).primaryKey()) {
                sql.append(" primary key");
                continue;
            }
            if (!columns.get(i).identity()) continue;
            sql.append(" identity");
        }
        sql.append(")");
        Schemas.execute(Checkers.castUntainted(sql.toString()), connection);
        if (Schemas.tableNeedsUpgrade(tableName, columns, connection)) {
            logger.warn("table {} thinks it still needs to be upgraded, even after it was just upgraded", (Object)tableName);
        }
    }

    private static boolean tableNeedsUpgrade(String tableName, List<Column> columns, Connection connection) throws SQLException {
        TreeMap<String, Column> columnMap = new TreeMap<String, Column>(String.CASE_INSENSITIVE_ORDER);
        for (Column column : columns) {
            columnMap.put(column.name(), column);
        }
        ResultSet resultSet = connection.getMetaData().getColumns(null, null, tableName.toUpperCase(Locale.ENGLISH), null);
        ResultSetCloser closer = new ResultSetCloser(resultSet);
        try {
            boolean bl = !Schemas.columnNamesAndTypesMatch(resultSet, columnMap);
            return bl;
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    private static boolean columnNamesAndTypesMatch(ResultSet resultSet, Map<String, Column> columnMap) throws SQLException {
        while (resultSet.next()) {
            Column column = columnMap.remove(resultSet.getString("COLUMN_NAME"));
            if (column == null) {
                return false;
            }
            if (column.type() == resultSet.getInt("DATA_TYPE")) continue;
            return false;
        }
        return columnMap.isEmpty();
    }

    @VisibleForTesting
    static ImmutableSet<Index> getIndexes(String tableName, Connection connection) throws SQLException {
        ArrayListMultimap<String, String> indexColumns = ArrayListMultimap.create();
        ResultSet resultSet = connection.getMetaData().getIndexInfo(null, null, tableName.toUpperCase(Locale.ENGLISH), false, false);
        ResultSetCloser closer = new ResultSetCloser(resultSet);
        try {
            while (resultSet.next()) {
                String indexName = Preconditions.checkNotNull(resultSet.getString("INDEX_NAME"));
                String columnName = Preconditions.checkNotNull(resultSet.getString("COLUMN_NAME"));
                if (indexName.startsWith("PRIMARY_KEY_")) continue;
                indexColumns.put(Checkers.castUntainted(indexName), Checkers.castUntainted(columnName));
            }
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
        ImmutableSet.Builder indexes = ImmutableSet.builder();
        for (Map.Entry entry : indexColumns.asMap().entrySet()) {
            String name = ((String)entry.getKey()).toLowerCase(Locale.ENGLISH);
            ArrayList<String> columns = Lists.newArrayList();
            for (String column : entry.getValue()) {
                columns.add(column.toLowerCase(Locale.ENGLISH));
            }
            indexes.add(Index.of(name, columns));
        }
        return indexes.build();
    }

    private static void createIndex(String tableName, Index index, Connection connection) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("create index ");
        sql.append(index.name());
        sql.append(" on ");
        sql.append(tableName);
        sql.append(" (");
        for (int i = 0; i < index.columns().size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append((String)index.columns().get(i));
        }
        sql.append(")");
        Schemas.execute(Checkers.castUntainted(sql.toString()), connection);
    }

    private static void execute(@Untainted String sql, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.execute(sql);
        }
        finally {
            statement.close();
        }
    }

    static {
        sqlTypeNames.put(12, "varchar");
        sqlTypeNames.put(-5, "bigint");
        sqlTypeNames.put(16, "boolean");
        sqlTypeNames.put(2005, "clob");
        sqlTypeNames.put(8, "double");
        sqlTypeNames.put(2004, "blob");
    }

    @Value.Immutable
    @Styles.AllParameters
    static abstract class IndexBase {
        IndexBase() {
        }

        @Untainted
        abstract String name();

        abstract ImmutableList<String> columns();
    }

    @Value.Immutable
    static abstract class ColumnBase {
        ColumnBase() {
        }

        abstract String name();

        abstract int type();

        boolean primaryKey() {
            return false;
        }

        boolean identity() {
            return false;
        }
    }
}

