/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glowroot.collector.AggregateRepository;
import org.glowroot.collector.TraceRepository;
import org.glowroot.common.Clock;
import org.glowroot.config.ConfigModule;
import org.glowroot.config.ConfigService;
import org.glowroot.config.StorageConfig;
import org.glowroot.jvm.LazyPlatformMBeanServer;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.store.AggregateRepositoryImpl;
import org.glowroot.local.store.AlertingService;
import org.glowroot.local.store.CappedDatabase;
import org.glowroot.local.store.DataSource;
import org.glowroot.local.store.GaugePointDao;
import org.glowroot.local.store.H2DatabaseStats;
import org.glowroot.local.store.MailService;
import org.glowroot.local.store.ReaperRunnable;
import org.glowroot.local.store.RollupCappedDatabaseStats;
import org.glowroot.local.store.TraceCappedDatabaseStats;
import org.glowroot.local.store.TraceDao;
import org.glowroot.local.store.TriggeredAlertDao;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.plugin.api.config.ConfigListener;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.weaving.PreInitializeStorageShutdownClasses;

public class StorageModule {
    private static final long SNAPSHOT_REAPER_PERIOD_MINUTES = 5L;
    private static final Logger logger = LoggerFactory.getLogger(StorageModule.class);
    private final DataSource dataSource;
    private final ImmutableList<CappedDatabase> rollupCappedDatabases;
    private final CappedDatabase traceCappedDatabase;
    private final AggregateDao aggregateDao;
    private final AggregateRepositoryImpl aggregateRepositoryImpl;
    private final TraceDao traceDao;
    private final GaugePointDao gaugePointDao;
    @Nullable
    private final ReaperRunnable reaperRunnable;
    private final LazyPlatformMBeanServer lazyPlatformMBeanServer;
    @OnlyUsedByTests
    private volatile boolean unregisterMBeans;

    public StorageModule(File baseDir, Map<String, String> properties, Clock clock, Ticker ticker, ConfigModule configModule, ScheduledExecutorService scheduledExecutor, LazyPlatformMBeanServer lazyPlatformMBeanServer, boolean viewerModeEnabled) throws Exception {
        File dataDir = new File(baseDir, "data");
        if (!dataDir.exists() && !dataDir.mkdir()) {
            throw new IOException("Could not create directory: " + dataDir.getAbsolutePath());
        }
        String h2MemDb = properties.get("internal.h2.memdb");
        final DataSource dataSource = Boolean.parseBoolean(h2MemDb) ? new DataSource() : new DataSource(new File(dataDir, "data.h2.db"));
        this.dataSource = dataSource;
        final ConfigService configService = configModule.getConfigService();
        StorageConfig storageConfig = configService.getStorageConfig();
        ArrayList<CappedDatabase> rollupCappedDatabases = Lists.newArrayList();
        for (int i = 0; i < storageConfig.rollupCappedDatabaseSizesMb().size(); ++i) {
            File file = new File(dataDir, "rollup-" + i + "-detail.capped.db");
            int sizeKb = (Integer)storageConfig.rollupCappedDatabaseSizesMb().get(i) * 1024;
            rollupCappedDatabases.add(new CappedDatabase(file, sizeKb, ticker));
        }
        this.rollupCappedDatabases = ImmutableList.copyOf(rollupCappedDatabases);
        this.traceCappedDatabase = new CappedDatabase(new File(dataDir, "trace-detail.capped.db"), storageConfig.traceCappedDatabaseSizeMb() * 1024, ticker);
        this.lazyPlatformMBeanServer = lazyPlatformMBeanServer;
        lazyPlatformMBeanServer.addInitListener(new LazyInit());
        this.aggregateDao = new AggregateDao(dataSource, this.rollupCappedDatabases, configModule.getConfigService(), clock);
        TriggeredAlertDao triggeredAlertDao = new TriggeredAlertDao(dataSource);
        AlertingService alertingService = new AlertingService(configService, triggeredAlertDao, this.aggregateDao, new MailService());
        this.aggregateRepositoryImpl = new AggregateRepositoryImpl(this.aggregateDao, alertingService);
        this.traceDao = new TraceDao(dataSource, this.traceCappedDatabase);
        this.gaugePointDao = new GaugePointDao(dataSource, configService, clock);
        dataSource.setQueryTimeoutSeconds(configService.getAdvancedConfig().internalQueryTimeoutSeconds());
        configService.addConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                dataSource.setQueryTimeoutSeconds(configService.getAdvancedConfig().internalQueryTimeoutSeconds());
            }
        });
        PreInitializeStorageShutdownClasses.preInitializeClasses();
        if (viewerModeEnabled) {
            this.reaperRunnable = null;
        } else {
            this.reaperRunnable = new ReaperRunnable(configService, this.aggregateDao, this.traceDao, this.gaugePointDao, clock);
            this.reaperRunnable.scheduleWithFixedDelay(scheduledExecutor, 0L, 5L, TimeUnit.MINUTES);
        }
    }

    public AggregateRepository getAggregateRepository() {
        return this.aggregateRepositoryImpl;
    }

    public TraceRepository getTraceRepository() {
        return this.traceDao;
    }

    public GaugePointDao getGaugePointDao() {
        return this.gaugePointDao;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public AggregateDao getAggregateDao() {
        return this.aggregateDao;
    }

    public TraceDao getTraceDao() {
        return this.traceDao;
    }

    public ImmutableList<CappedDatabase> getRollupCappedDatabases() {
        return this.rollupCappedDatabases;
    }

    public CappedDatabase getTraceCappedDatabase() {
        return this.traceCappedDatabase;
    }

    @OnlyUsedByTests
    public void close() throws Exception {
        if (this.unregisterMBeans) {
            for (int i = 0; i < this.rollupCappedDatabases.size(); ++i) {
                this.lazyPlatformMBeanServer.unregisterMBean(new ObjectName("org.glowroot:type=RollupCappedDatabase" + i));
            }
            this.lazyPlatformMBeanServer.unregisterMBean(new ObjectName("org.glowroot:type=TraceCappedDatabase"));
            this.lazyPlatformMBeanServer.unregisterMBean(new ObjectName("org.glowroot:type=H2Database"));
        }
        if (this.reaperRunnable != null) {
            this.reaperRunnable.cancel();
        }
        for (CappedDatabase cappedDatabase : this.rollupCappedDatabases) {
            cappedDatabase.close();
        }
        this.traceCappedDatabase.close();
        this.dataSource.close();
    }

    private class LazyInit
    implements LazyPlatformMBeanServer.InitListener {
        private LazyInit() {
        }

        @Override
        public void postInit(MBeanServer mbeanServer) throws Exception {
            try {
                for (int i = 0; i < StorageModule.this.rollupCappedDatabases.size(); ++i) {
                    mbeanServer.registerMBean(new RollupCappedDatabaseStats((CappedDatabase)StorageModule.this.rollupCappedDatabases.get(i)), new ObjectName("org.glowroot:type=RollupCappedDatabase" + i));
                }
                mbeanServer.registerMBean(new TraceCappedDatabaseStats(StorageModule.this.traceCappedDatabase), new ObjectName("org.glowroot:type=TraceCappedDatabase"));
                mbeanServer.registerMBean(new H2DatabaseStats(StorageModule.this.dataSource), new ObjectName("org.glowroot:type=H2Database"));
                StorageModule.this.unregisterMBeans = true;
            }
            catch (InstanceAlreadyExistsException e) {
                logger.debug(e.getMessage(), e);
            }
        }
    }
}

