/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.store.StringComparator;
import org.glowroot.local.store.TracePointQueryBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class TracePointQuery
extends TracePointQueryBase {
    private final long from;
    private final long to;
    private final long durationLow;
    @Nullable
    private final Long durationHigh;
    @Nullable
    private final String transactionType;
    @Nullable
    private final StringComparator transactionNameComparator;
    @Nullable
    private final String transactionName;
    @Nullable
    private final StringComparator headlineComparator;
    @Nullable
    private final String headline;
    @Nullable
    private final StringComparator errorComparator;
    @Nullable
    private final String error;
    @Nullable
    private final StringComparator userComparator;
    @Nullable
    private final String user;
    @Nullable
    private final String customAttributeName;
    @Nullable
    private final StringComparator customAttributeValueComparator;
    @Nullable
    private final String customAttributeValue;
    private final boolean slowOnly;
    private final boolean errorOnly;
    private final int limit;

    private TracePointQuery(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.durationLow = builder.durationLow;
        this.durationHigh = builder.durationHigh;
        this.transactionType = builder.transactionType;
        this.transactionNameComparator = builder.transactionNameComparator;
        this.transactionName = builder.transactionName;
        this.headlineComparator = builder.headlineComparator;
        this.headline = builder.headline;
        this.errorComparator = builder.errorComparator;
        this.error = builder.error;
        this.userComparator = builder.userComparator;
        this.user = builder.user;
        this.customAttributeName = builder.customAttributeName;
        this.customAttributeValueComparator = builder.customAttributeValueComparator;
        this.customAttributeValue = builder.customAttributeValue;
        this.limit = builder.limit;
        this.slowOnly = builder.slowOnlyIsSet() ? builder.slowOnly : super.slowOnly();
        this.errorOnly = builder.errorOnlyIsSet() ? builder.errorOnly : super.errorOnly();
    }

    private TracePointQuery(long from, long to, long durationLow, @Nullable Long durationHigh, @Nullable String transactionType, @Nullable StringComparator transactionNameComparator, @Nullable String transactionName, @Nullable StringComparator headlineComparator, @Nullable String headline, @Nullable StringComparator errorComparator, @Nullable String error, @Nullable StringComparator userComparator, @Nullable String user, @Nullable String customAttributeName, @Nullable StringComparator customAttributeValueComparator, @Nullable String customAttributeValue, boolean slowOnly, boolean errorOnly, int limit) {
        this.from = from;
        this.to = to;
        this.durationLow = durationLow;
        this.durationHigh = durationHigh;
        this.transactionType = transactionType;
        this.transactionNameComparator = transactionNameComparator;
        this.transactionName = transactionName;
        this.headlineComparator = headlineComparator;
        this.headline = headline;
        this.errorComparator = errorComparator;
        this.error = error;
        this.userComparator = userComparator;
        this.user = user;
        this.customAttributeName = customAttributeName;
        this.customAttributeValueComparator = customAttributeValueComparator;
        this.customAttributeValue = customAttributeValue;
        this.slowOnly = slowOnly;
        this.errorOnly = errorOnly;
        this.limit = limit;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="durationLow")
    public long durationLow() {
        return this.durationLow;
    }

    @Override
    @JsonProperty(value="durationHigh")
    public Long durationHigh() {
        return this.durationHigh;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionNameComparator")
    public StringComparator transactionNameComparator() {
        return this.transactionNameComparator;
    }

    @Override
    @JsonProperty(value="transactionName")
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="headlineComparator")
    public StringComparator headlineComparator() {
        return this.headlineComparator;
    }

    @Override
    @JsonProperty(value="headline")
    public String headline() {
        return this.headline;
    }

    @Override
    @JsonProperty(value="errorComparator")
    public StringComparator errorComparator() {
        return this.errorComparator;
    }

    @Override
    @JsonProperty(value="error")
    public String error() {
        return this.error;
    }

    @Override
    @JsonProperty(value="userComparator")
    public StringComparator userComparator() {
        return this.userComparator;
    }

    @Override
    @JsonProperty(value="user")
    public String user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="customAttributeName")
    public String customAttributeName() {
        return this.customAttributeName;
    }

    @Override
    @JsonProperty(value="customAttributeValueComparator")
    public StringComparator customAttributeValueComparator() {
        return this.customAttributeValueComparator;
    }

    @Override
    @JsonProperty(value="customAttributeValue")
    public String customAttributeValue() {
        return this.customAttributeValue;
    }

    @Override
    @JsonProperty(value="slowOnly")
    public boolean slowOnly() {
        return this.slowOnly;
    }

    @Override
    @JsonProperty(value="errorOnly")
    public boolean errorOnly() {
        return this.errorOnly;
    }

    @Override
    @JsonProperty(value="limit")
    public int limit() {
        return this.limit;
    }

    public final TracePointQuery withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        long newValue = value;
        return new TracePointQuery(newValue, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withTo(long value) {
        if (this.to == value) {
            return this;
        }
        long newValue = value;
        return new TracePointQuery(this.from, newValue, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withDurationLow(long value) {
        if (this.durationLow == value) {
            return this;
        }
        long newValue = value;
        return new TracePointQuery(this.from, this.to, newValue, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withDurationHigh(@Nullable Long value) {
        if (this.durationHigh == value) {
            return this;
        }
        Long newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, newValue, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withTransactionType(@Nullable String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, newValue, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withTransactionNameComparator(@Nullable StringComparator value) {
        if (this.transactionNameComparator == value) {
            return this;
        }
        StringComparator newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, newValue, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withTransactionName(@Nullable String value) {
        if (this.transactionName == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, newValue, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withHeadlineComparator(@Nullable StringComparator value) {
        if (this.headlineComparator == value) {
            return this;
        }
        StringComparator newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, newValue, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withHeadline(@Nullable String value) {
        if (this.headline == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, newValue, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withErrorComparator(@Nullable StringComparator value) {
        if (this.errorComparator == value) {
            return this;
        }
        StringComparator newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, newValue, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withError(@Nullable String value) {
        if (this.error == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, newValue, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withUserComparator(@Nullable StringComparator value) {
        if (this.userComparator == value) {
            return this;
        }
        StringComparator newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, newValue, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withUser(@Nullable String value) {
        if (this.user == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, newValue, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withCustomAttributeName(@Nullable String value) {
        if (this.customAttributeName == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, newValue, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withCustomAttributeValueComparator(@Nullable StringComparator value) {
        if (this.customAttributeValueComparator == value) {
            return this;
        }
        StringComparator newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, newValue, this.customAttributeValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withCustomAttributeValue(@Nullable String value) {
        if (this.customAttributeValue == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, newValue, this.slowOnly, this.errorOnly, this.limit);
    }

    public final TracePointQuery withSlowOnly(boolean value) {
        if (this.slowOnly == value) {
            return this;
        }
        boolean newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, newValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withErrorOnly(boolean value) {
        if (this.errorOnly == value) {
            return this;
        }
        boolean newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, newValue, this.limit);
    }

    public final TracePointQuery withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        int newValue = value;
        return new TracePointQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.slowOnly, this.errorOnly, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TracePointQuery && this.equalTo((TracePointQuery)another);
    }

    private boolean equalTo(TracePointQuery another) {
        return this.from == another.from && this.to == another.to && this.durationLow == another.durationLow && Objects.equal(this.durationHigh, another.durationHigh) && Objects.equal(this.transactionType, another.transactionType) && Objects.equal((Object)this.transactionNameComparator, (Object)another.transactionNameComparator) && Objects.equal(this.transactionName, another.transactionName) && Objects.equal((Object)this.headlineComparator, (Object)another.headlineComparator) && Objects.equal(this.headline, another.headline) && Objects.equal((Object)this.errorComparator, (Object)another.errorComparator) && Objects.equal(this.error, another.error) && Objects.equal((Object)this.userComparator, (Object)another.userComparator) && Objects.equal(this.user, another.user) && Objects.equal(this.customAttributeName, another.customAttributeName) && Objects.equal((Object)this.customAttributeValueComparator, (Object)another.customAttributeValueComparator) && Objects.equal(this.customAttributeValue, another.customAttributeValue) && this.slowOnly == another.slowOnly && this.errorOnly == another.errorOnly && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.from);
        h = h * 17 + Longs.hashCode(this.to);
        h = h * 17 + Longs.hashCode(this.durationLow);
        h = h * 17 + Objects.hashCode(this.durationHigh);
        h = h * 17 + Objects.hashCode(this.transactionType);
        h = h * 17 + Objects.hashCode(new Object[]{this.transactionNameComparator});
        h = h * 17 + Objects.hashCode(this.transactionName);
        h = h * 17 + Objects.hashCode(new Object[]{this.headlineComparator});
        h = h * 17 + Objects.hashCode(this.headline);
        h = h * 17 + Objects.hashCode(new Object[]{this.errorComparator});
        h = h * 17 + Objects.hashCode(this.error);
        h = h * 17 + Objects.hashCode(new Object[]{this.userComparator});
        h = h * 17 + Objects.hashCode(this.user);
        h = h * 17 + Objects.hashCode(this.customAttributeName);
        h = h * 17 + Objects.hashCode(new Object[]{this.customAttributeValueComparator});
        h = h * 17 + Objects.hashCode(this.customAttributeValue);
        h = h * 17 + Booleans.hashCode(this.slowOnly);
        h = h * 17 + Booleans.hashCode(this.errorOnly);
        h = h * 17 + this.limit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TracePointQuery").add("from", this.from).add("to", this.to).add("durationLow", this.durationLow).add("durationHigh", this.durationHigh).add("transactionType", this.transactionType).add("transactionNameComparator", (Object)this.transactionNameComparator).add("transactionName", this.transactionName).add("headlineComparator", (Object)this.headlineComparator).add("headline", this.headline).add("errorComparator", (Object)this.errorComparator).add("error", this.error).add("userComparator", (Object)this.userComparator).add("user", this.user).add("customAttributeName", this.customAttributeName).add("customAttributeValueComparator", (Object)this.customAttributeValueComparator).add("customAttributeValue", this.customAttributeValue).add("slowOnly", this.slowOnly).add("errorOnly", this.errorOnly).add("limit", this.limit).toString();
    }

    @JsonCreator
    public static TracePointQuery fromAllAttributes(@JsonProperty(value="from") @Nullable Long from, @JsonProperty(value="to") @Nullable Long to, @JsonProperty(value="durationLow") @Nullable Long durationLow, @JsonProperty(value="durationHigh") @Nullable Long durationHigh, @JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="transactionNameComparator") @Nullable StringComparator transactionNameComparator, @JsonProperty(value="transactionName") @Nullable String transactionName, @JsonProperty(value="headlineComparator") @Nullable StringComparator headlineComparator, @JsonProperty(value="headline") @Nullable String headline, @JsonProperty(value="errorComparator") @Nullable StringComparator errorComparator, @JsonProperty(value="error") @Nullable String error, @JsonProperty(value="userComparator") @Nullable StringComparator userComparator, @JsonProperty(value="user") @Nullable String user, @JsonProperty(value="customAttributeName") @Nullable String customAttributeName, @JsonProperty(value="customAttributeValueComparator") @Nullable StringComparator customAttributeValueComparator, @JsonProperty(value="customAttributeValue") @Nullable String customAttributeValue, @JsonProperty(value="slowOnly") @Nullable Boolean slowOnly, @JsonProperty(value="errorOnly") @Nullable Boolean errorOnly, @JsonProperty(value="limit") @Nullable Integer limit) {
        Builder builder = TracePointQuery.builder();
        if (from != null) {
            builder.from(from);
        }
        if (to != null) {
            builder.to(to);
        }
        if (durationLow != null) {
            builder.durationLow(durationLow);
        }
        if (durationHigh != null) {
            builder.durationHigh(durationHigh);
        }
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (transactionNameComparator != null) {
            builder.transactionNameComparator(transactionNameComparator);
        }
        if (transactionName != null) {
            builder.transactionName(transactionName);
        }
        if (headlineComparator != null) {
            builder.headlineComparator(headlineComparator);
        }
        if (headline != null) {
            builder.headline(headline);
        }
        if (errorComparator != null) {
            builder.errorComparator(errorComparator);
        }
        if (error != null) {
            builder.error(error);
        }
        if (userComparator != null) {
            builder.userComparator(userComparator);
        }
        if (user != null) {
            builder.user(user);
        }
        if (customAttributeName != null) {
            builder.customAttributeName(customAttributeName);
        }
        if (customAttributeValueComparator != null) {
            builder.customAttributeValueComparator(customAttributeValueComparator);
        }
        if (customAttributeValue != null) {
            builder.customAttributeValue(customAttributeValue);
        }
        if (slowOnly != null) {
            builder.slowOnly(slowOnly);
        }
        if (errorOnly != null) {
            builder.errorOnly(errorOnly);
        }
        if (limit != null) {
            builder.limit(limit);
        }
        return builder.build();
    }

    public static TracePointQuery copyOf(TracePointQueryBase instance) {
        if (instance instanceof TracePointQuery) {
            return (TracePointQuery)instance;
        }
        return TracePointQuery.builder().from(instance.from()).to(instance.to()).durationLow(instance.durationLow()).durationHigh(instance.durationHigh()).transactionType(instance.transactionType()).transactionNameComparator(instance.transactionNameComparator()).transactionName(instance.transactionName()).headlineComparator(instance.headlineComparator()).headline(instance.headline()).errorComparator(instance.errorComparator()).error(instance.error()).userComparator(instance.userComparator()).user(instance.user()).customAttributeName(instance.customAttributeName()).customAttributeValueComparator(instance.customAttributeValueComparator()).customAttributeValue(instance.customAttributeValue()).slowOnly(instance.slowOnly()).errorOnly(instance.errorOnly()).limit(instance.limit()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 15L;
        private static final long INITIALIZED_BIT_FROM = 1L;
        private static final long INITIALIZED_BIT_TO = 2L;
        private static final long INITIALIZED_BIT_DURATION_LOW = 4L;
        private static final long INITIALIZED_BIT_LIMIT = 8L;
        private static final long NONDEFAULT_BIT_DURATION_HIGH = 1L;
        private static final long NONDEFAULT_BIT_TRANSACTION_TYPE = 2L;
        private static final long NONDEFAULT_BIT_TRANSACTION_NAME_COMPARATOR = 4L;
        private static final long NONDEFAULT_BIT_TRANSACTION_NAME = 8L;
        private static final long NONDEFAULT_BIT_HEADLINE_COMPARATOR = 16L;
        private static final long NONDEFAULT_BIT_HEADLINE = 32L;
        private static final long NONDEFAULT_BIT_ERROR_COMPARATOR = 64L;
        private static final long NONDEFAULT_BIT_ERROR = 128L;
        private static final long NONDEFAULT_BIT_USER_COMPARATOR = 256L;
        private static final long NONDEFAULT_BIT_USER = 512L;
        private static final long NONDEFAULT_BIT_CUSTOM_ATTRIBUTE_NAME = 1024L;
        private static final long NONDEFAULT_BIT_CUSTOM_ATTRIBUTE_VALUE_COMPARATOR = 2048L;
        private static final long NONDEFAULT_BIT_CUSTOM_ATTRIBUTE_VALUE = 4096L;
        private static final long NONDEFAULT_BIT_SLOW_ONLY = 8192L;
        private static final long NONDEFAULT_BIT_ERROR_ONLY = 16384L;
        private long initializedBitset;
        private long nondefaultBitset;
        private long from;
        private long to;
        private long durationLow;
        @Nullable
        private Long durationHigh;
        @Nullable
        private String transactionType;
        @Nullable
        private StringComparator transactionNameComparator;
        @Nullable
        private String transactionName;
        @Nullable
        private StringComparator headlineComparator;
        @Nullable
        private String headline;
        @Nullable
        private StringComparator errorComparator;
        @Nullable
        private String error;
        @Nullable
        private StringComparator userComparator;
        @Nullable
        private String user;
        @Nullable
        private String customAttributeName;
        @Nullable
        private StringComparator customAttributeValueComparator;
        @Nullable
        private String customAttributeValue;
        private boolean slowOnly;
        private boolean errorOnly;
        private int limit;

        private Builder() {
        }

        public final Builder from(long from) {
            this.checkNotIsSet(this.fromIsSet(), "from");
            this.from = from;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder to(long to) {
            this.checkNotIsSet(this.toIsSet(), "to");
            this.to = to;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder durationLow(long durationLow) {
            this.checkNotIsSet(this.durationLowIsSet(), "durationLow");
            this.durationLow = durationLow;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder durationHigh(@Nullable Long durationHigh) {
            this.checkNotIsSet(this.durationHighIsSet(), "durationHigh");
            this.durationHigh = durationHigh;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder transactionType(@Nullable String transactionType) {
            this.checkNotIsSet(this.transactionTypeIsSet(), "transactionType");
            this.transactionType = transactionType;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder transactionNameComparator(@Nullable StringComparator transactionNameComparator) {
            this.checkNotIsSet(this.transactionNameComparatorIsSet(), "transactionNameComparator");
            this.transactionNameComparator = transactionNameComparator;
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder transactionName(@Nullable String transactionName) {
            this.checkNotIsSet(this.transactionNameIsSet(), "transactionName");
            this.transactionName = transactionName;
            this.nondefaultBitset |= 8L;
            return this;
        }

        public final Builder headlineComparator(@Nullable StringComparator headlineComparator) {
            this.checkNotIsSet(this.headlineComparatorIsSet(), "headlineComparator");
            this.headlineComparator = headlineComparator;
            this.nondefaultBitset |= 0x10L;
            return this;
        }

        public final Builder headline(@Nullable String headline) {
            this.checkNotIsSet(this.headlineIsSet(), "headline");
            this.headline = headline;
            this.nondefaultBitset |= 0x20L;
            return this;
        }

        public final Builder errorComparator(@Nullable StringComparator errorComparator) {
            this.checkNotIsSet(this.errorComparatorIsSet(), "errorComparator");
            this.errorComparator = errorComparator;
            this.nondefaultBitset |= 0x40L;
            return this;
        }

        public final Builder error(@Nullable String error) {
            this.checkNotIsSet(this.errorIsSet(), "error");
            this.error = error;
            this.nondefaultBitset |= 0x80L;
            return this;
        }

        public final Builder userComparator(@Nullable StringComparator userComparator) {
            this.checkNotIsSet(this.userComparatorIsSet(), "userComparator");
            this.userComparator = userComparator;
            this.nondefaultBitset |= 0x100L;
            return this;
        }

        public final Builder user(@Nullable String user) {
            this.checkNotIsSet(this.userIsSet(), "user");
            this.user = user;
            this.nondefaultBitset |= 0x200L;
            return this;
        }

        public final Builder customAttributeName(@Nullable String customAttributeName) {
            this.checkNotIsSet(this.customAttributeNameIsSet(), "customAttributeName");
            this.customAttributeName = customAttributeName;
            this.nondefaultBitset |= 0x400L;
            return this;
        }

        public final Builder customAttributeValueComparator(@Nullable StringComparator customAttributeValueComparator) {
            this.checkNotIsSet(this.customAttributeValueComparatorIsSet(), "customAttributeValueComparator");
            this.customAttributeValueComparator = customAttributeValueComparator;
            this.nondefaultBitset |= 0x800L;
            return this;
        }

        public final Builder customAttributeValue(@Nullable String customAttributeValue) {
            this.checkNotIsSet(this.customAttributeValueIsSet(), "customAttributeValue");
            this.customAttributeValue = customAttributeValue;
            this.nondefaultBitset |= 0x1000L;
            return this;
        }

        public final Builder slowOnly(boolean slowOnly) {
            this.checkNotIsSet(this.slowOnlyIsSet(), "slowOnly");
            this.slowOnly = slowOnly;
            this.nondefaultBitset |= 0x2000L;
            return this;
        }

        public final Builder errorOnly(boolean errorOnly) {
            this.checkNotIsSet(this.errorOnlyIsSet(), "errorOnly");
            this.errorOnly = errorOnly;
            this.nondefaultBitset |= 0x4000L;
            return this;
        }

        public final Builder limit(int limit) {
            this.checkNotIsSet(this.limitIsSet(), "limit");
            this.limit = limit;
            this.initializedBitset |= 8L;
            return this;
        }

        public TracePointQuery build() {
            this.checkRequiredAttributes();
            return new TracePointQuery(this);
        }

        private boolean durationHighIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean transactionTypeIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean transactionNameComparatorIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean transactionNameIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }

        private boolean headlineComparatorIsSet() {
            return (this.nondefaultBitset & 0x10L) != 0L;
        }

        private boolean headlineIsSet() {
            return (this.nondefaultBitset & 0x20L) != 0L;
        }

        private boolean errorComparatorIsSet() {
            return (this.nondefaultBitset & 0x40L) != 0L;
        }

        private boolean errorIsSet() {
            return (this.nondefaultBitset & 0x80L) != 0L;
        }

        private boolean userComparatorIsSet() {
            return (this.nondefaultBitset & 0x100L) != 0L;
        }

        private boolean userIsSet() {
            return (this.nondefaultBitset & 0x200L) != 0L;
        }

        private boolean customAttributeNameIsSet() {
            return (this.nondefaultBitset & 0x400L) != 0L;
        }

        private boolean customAttributeValueComparatorIsSet() {
            return (this.nondefaultBitset & 0x800L) != 0L;
        }

        private boolean customAttributeValueIsSet() {
            return (this.nondefaultBitset & 0x1000L) != 0L;
        }

        private boolean slowOnlyIsSet() {
            return (this.nondefaultBitset & 0x2000L) != 0L;
        }

        private boolean errorOnlyIsSet() {
            return (this.nondefaultBitset & 0x4000L) != 0L;
        }

        private boolean fromIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean toIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean durationLowIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean limitIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of TracePointQuery is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 15L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.fromIsSet()) {
                attributes.add("from");
            }
            if (!this.toIsSet()) {
                attributes.add("to");
            }
            if (!this.durationLowIsSet()) {
                attributes.add("durationLow");
            }
            if (!this.limitIsSet()) {
                attributes.add("limit");
            }
            return "Cannot build TracePointQuery, some of required attributes are not set " + attributes;
        }
    }
}

