/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.local.store.ParameterizedSql;
import org.glowroot.local.store.StringComparator;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.google.common.collect.Lists;
import org.immutables.value.Value;

@Value.Immutable
public abstract class TracePointQueryBase {
    public abstract long from();

    public abstract long to();

    public abstract long durationLow();

    @Nullable
    public abstract Long durationHigh();

    @Nullable
    public abstract String transactionType();

    @Nullable
    public abstract StringComparator transactionNameComparator();

    @Nullable
    public abstract String transactionName();

    @Nullable
    public abstract StringComparator headlineComparator();

    @Nullable
    public abstract String headline();

    @Nullable
    public abstract StringComparator errorComparator();

    @Nullable
    public abstract String error();

    @Nullable
    public abstract StringComparator userComparator();

    @Nullable
    public abstract String user();

    @Nullable
    public abstract String customAttributeName();

    @Nullable
    public abstract StringComparator customAttributeValueComparator();

    @Nullable
    public abstract String customAttributeValue();

    public boolean slowOnly() {
        return false;
    }

    public boolean errorOnly() {
        return false;
    }

    public abstract int limit();

    ParameterizedSql getParameterizedSql() {
        ParameterizedSqlBuilder builder = new ParameterizedSqlBuilder();
        builder.appendText("select trace.id, trace.capture_time, trace.duration, trace.error from trace");
        ParameterizedSql criteria = this.getCustomAttributeCriteria();
        if (criteria == null) {
            builder.appendText(" where");
        } else {
            builder.appendText(", trace_custom_attribute attr where attr.trace_id = trace.id and attr.capture_time > ? and attr.capture_time <= ? and" + criteria.sql());
            builder.addArg(this.from());
            builder.addArg(this.to());
            builder.addArgs(criteria.args());
        }
        builder.appendText(" trace.capture_time > ? and trace.capture_time <= ?");
        builder.addArg(this.from());
        builder.addArg(this.to());
        this.appendDurationCriteria(builder);
        this.appendTransactionTypeCriteria(builder);
        this.appendSlowOnlyCriteria(builder);
        this.appendErrorOnlyCriteria(builder);
        this.appendTransactionNameCriteria(builder);
        this.appendHeadlineCriteria(builder);
        this.appendErrorCriteria(builder);
        this.appendUserCriteria(builder);
        this.appendOrderByAndLimit(builder);
        return builder.build();
    }

    @Nullable
    private ParameterizedSql getCustomAttributeCriteria() {
        String sql = "";
        ArrayList<String> args = Lists.newArrayList();
        String customAttributeName = this.customAttributeName();
        if (!Strings.isNullOrEmpty(customAttributeName)) {
            sql = sql + " upper(attr.name) = ? and";
            args.add(customAttributeName.toUpperCase(Locale.ENGLISH));
        }
        StringComparator customAttributeValueComparator = this.customAttributeValueComparator();
        String customAttributeValue = this.customAttributeValue();
        if (customAttributeValueComparator != null && !Strings.isNullOrEmpty(customAttributeValue)) {
            sql = sql + " upper(attr.value) " + customAttributeValueComparator.getComparator() + " ? and";
            args.add(customAttributeValueComparator.formatParameter(customAttributeValue));
        }
        if (sql.equals("")) {
            return null;
        }
        return ParameterizedSql.of(sql, args);
    }

    private void appendDurationCriteria(ParameterizedSqlBuilder builder) {
        Long durationHigh;
        long durationLow = this.durationLow();
        if (durationLow != 0L) {
            builder.appendText(" and trace.duration >= ?");
            builder.addArg(durationLow);
        }
        if ((durationHigh = this.durationHigh()) != null) {
            builder.appendText(" and trace.duration <= ?");
            builder.addArg(durationHigh);
        }
    }

    private void appendTransactionTypeCriteria(ParameterizedSqlBuilder builder) {
        String transactionType = this.transactionType();
        if (!Strings.isNullOrEmpty(transactionType)) {
            builder.appendText(" and trace.transaction_type = ?");
            builder.addArg(transactionType);
        }
    }

    private void appendSlowOnlyCriteria(ParameterizedSqlBuilder builder) {
        if (this.slowOnly()) {
            builder.appendText(" and trace.slow = ?");
            builder.addArg(true);
        }
    }

    private void appendErrorOnlyCriteria(ParameterizedSqlBuilder builder) {
        if (this.errorOnly()) {
            builder.appendText(" and trace.error = ?");
            builder.addArg(true);
        }
    }

    private void appendTransactionNameCriteria(ParameterizedSqlBuilder builder) {
        StringComparator transactionNameComparator = this.transactionNameComparator();
        String transactionName = this.transactionName();
        if (transactionNameComparator != null && !Strings.isNullOrEmpty(transactionName)) {
            builder.appendText(" and upper(trace.transaction_name) " + transactionNameComparator.getComparator() + " ?");
            builder.addArg(transactionNameComparator.formatParameter(transactionName));
        }
    }

    private void appendHeadlineCriteria(ParameterizedSqlBuilder builder) {
        StringComparator headlineComparator = this.headlineComparator();
        String headline = this.headline();
        if (headlineComparator != null && !Strings.isNullOrEmpty(headline)) {
            builder.appendText(" and upper(trace.headline) " + headlineComparator.getComparator() + " ?");
            builder.addArg(headlineComparator.formatParameter(headline));
        }
    }

    private void appendErrorCriteria(ParameterizedSqlBuilder builder) {
        StringComparator errorComparator = this.errorComparator();
        String error = this.error();
        if (errorComparator != null && !Strings.isNullOrEmpty(error)) {
            builder.appendText(" and upper(trace.error_message) " + errorComparator.getComparator() + " ?");
            builder.addArg(errorComparator.formatParameter(error));
        }
    }

    private void appendUserCriteria(ParameterizedSqlBuilder builder) {
        StringComparator userComparator = this.userComparator();
        String user = this.user();
        if (userComparator != null && !Strings.isNullOrEmpty(user)) {
            builder.appendText(" and upper(trace.user) " + userComparator.getComparator() + " ?");
            builder.addArg(userComparator.formatParameter(user));
        }
    }

    private void appendOrderByAndLimit(ParameterizedSqlBuilder builder) {
        builder.appendText(" order by trace.duration");
        if (this.limit() != 0) {
            builder.appendText(" desc limit ?");
            builder.addArg(this.limit() + 1);
        }
    }

    private static class ParameterizedSqlBuilder {
        @Untainted
        private String sql = "";
        private final List<Object> args = Lists.newArrayList();

        private ParameterizedSqlBuilder() {
        }

        private void appendText(@Untainted String sql) {
            this.sql = this.sql + sql;
        }

        public void addArg(Object arg) {
            this.args.add(arg);
        }

        public void addArgs(List<Object> args) {
            this.args.addAll(args);
        }

        private ParameterizedSql build() {
            return ParameterizedSql.of(this.sql, this.args);
        }
    }
}

