/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.collector.AggregateCollector;
import org.glowroot.config.ConfigService;
import org.glowroot.config.InstrumentationConfig;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.store.DataSource;
import org.glowroot.local.store.GaugePointDao;
import org.glowroot.local.store.TraceDao;
import org.glowroot.local.ui.GET;
import org.glowroot.local.ui.JsonService;
import org.glowroot.local.ui.POST;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Iterables;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.transaction.AdviceCache;
import org.glowroot.transaction.TransactionCollector;
import org.glowroot.transaction.TransactionRegistry;
import org.glowroot.weaving.AnalyzedWorld;

@JsonService
class AdminJsonService {
    private final AggregateDao aggregateDao;
    private final TraceDao traceDao;
    private final GaugePointDao gaugePointDao;
    @Nullable
    private final AggregateCollector aggregateCollector;
    private final ConfigService configService;
    private final AdviceCache adviceCache;
    private final AnalyzedWorld analyzedWorld;
    @Nullable
    private final Instrumentation instrumentation;
    private final TransactionCollector transactionCollector;
    private final DataSource dataSource;
    private final TransactionRegistry transactionRegistry;

    AdminJsonService(AggregateDao aggregateDao, TraceDao traceDao, GaugePointDao gaugePointDao, @Nullable AggregateCollector aggregateCollector, ConfigService configService, AdviceCache adviceCache, AnalyzedWorld analyzedWorld, @Nullable Instrumentation instrumentation, TransactionCollector transactionCollector, DataSource dataSource, TransactionRegistry transactionRegistry) {
        this.aggregateDao = aggregateDao;
        this.traceDao = traceDao;
        this.gaugePointDao = gaugePointDao;
        this.aggregateCollector = aggregateCollector;
        this.configService = configService;
        this.adviceCache = adviceCache;
        this.analyzedWorld = analyzedWorld;
        this.instrumentation = instrumentation;
        this.transactionCollector = transactionCollector;
        this.dataSource = dataSource;
        this.transactionRegistry = transactionRegistry;
    }

    @POST(value="/backend/admin/delete-all-data")
    void deleteAllData() throws SQLException {
        if (this.aggregateCollector != null) {
            this.aggregateCollector.clearAll();
        }
        this.traceDao.deleteAll();
        this.gaugePointDao.deleteAll();
        this.aggregateDao.deleteAll();
        this.dataSource.defrag();
    }

    @POST(value="/backend/admin/reweave")
    String reweave() throws Exception {
        Preconditions.checkNotNull(this.instrumentation);
        Preconditions.checkState(this.instrumentation.isRetransformClassesSupported(), "Retransform classes is not supported");
        int count = this.reweaveInternal();
        return "{\"classes\":" + count + "}";
    }

    @POST(value="/backend/admin/defrag-data")
    void defragData() throws SQLException {
        this.dataSource.defrag();
    }

    @POST(value="/backend/admin/reset-all-config")
    @OnlyUsedByTests
    void resetAllConfig() throws IOException {
        this.configService.resetAllConfig();
    }

    @GET(value="/backend/admin/num-active-transactions")
    @OnlyUsedByTests
    String getNumActiveTransactions() {
        return Integer.toString(this.transactionRegistry.getTransactions().size());
    }

    @GET(value="/backend/admin/num-pending-complete-transactions")
    @OnlyUsedByTests
    String getNumPendingCompleteTransactions() {
        return Integer.toString(this.transactionCollector.getPendingTransactions().size());
    }

    @GET(value="/backend/admin/num-traces")
    @OnlyUsedByTests
    String getNumTraces() throws SQLException {
        return Long.toString(this.traceDao.count());
    }

    @RequiresNonNull(value={"instrumentation"})
    private int reweaveInternal() throws Exception {
        List<InstrumentationConfig> configs = this.configService.getInstrumentationConfigs();
        this.adviceCache.updateAdvisors(configs, false);
        HashSet<String> classNames = Sets.newHashSet();
        for (InstrumentationConfig config : configs) {
            classNames.add(config.className());
        }
        HashSet<Class<?>> classes = Sets.newHashSet();
        List<Class<?>> possibleNewReweavableClasses = this.getExistingSubClasses(classNames);
        List<Class<?>> existingReweavableClasses = this.analyzedWorld.getClassesWithReweavableAdvice(true);
        this.analyzedWorld.removeClasses(possibleNewReweavableClasses);
        classes.addAll(existingReweavableClasses);
        classes.addAll(possibleNewReweavableClasses);
        if (classes.isEmpty()) {
            return 0;
        }
        this.instrumentation.retransformClasses(Iterables.toArray(classes, Class.class));
        List<Class<?>> updatedReweavableClasses = this.analyzedWorld.getClassesWithReweavableAdvice(false);
        int count = existingReweavableClasses.size();
        for (Class<?> possibleNewReweavableClass : possibleNewReweavableClasses) {
            if (!updatedReweavableClasses.contains(possibleNewReweavableClass) || existingReweavableClasses.contains(possibleNewReweavableClass)) continue;
            ++count;
        }
        return count;
    }

    @RequiresNonNull(value={"instrumentation"})
    private List<Class<?>> getExistingSubClasses(Set<String> classNames) {
        ArrayList<Class<?>> classes = Lists.newArrayList();
        for (Class clazz : this.instrumentation.getAllLoadedClasses()) {
            if (!AdminJsonService.isSubClassOfOneOf(clazz, classNames)) continue;
            classes.add(clazz);
        }
        return classes;
    }

    private static boolean isSubClassOfOneOf(Class<?> clazz, Set<String> classNames) {
        if (classNames.contains(clazz.getName())) {
            return true;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && AdminJsonService.isSubClassOfOneOf(superclass, classNames)) {
            return true;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!AdminJsonService.isSubClassOfOneOf(iface, classNames)) continue;
            return true;
        }
        return false;
    }
}

