/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.InstrumentationJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class ClassNamesRequest
extends InstrumentationJsonService.ClassNamesRequestBase {
    private final String partialClassName;
    private final int limit;

    private ClassNamesRequest(String partialClassName, int limit) {
        this.partialClassName = partialClassName;
        this.limit = limit;
    }

    @Override
    @JsonProperty(value="partialClassName")
    public String partialClassName() {
        return this.partialClassName;
    }

    @Override
    @JsonProperty(value="limit")
    public int limit() {
        return this.limit;
    }

    public final ClassNamesRequest withPartialClassName(String value) {
        if (this.partialClassName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ClassNamesRequest(newValue, this.limit);
    }

    public final ClassNamesRequest withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        int newValue = value;
        return new ClassNamesRequest(this.partialClassName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ClassNamesRequest && this.equalTo((ClassNamesRequest)another);
    }

    private boolean equalTo(ClassNamesRequest another) {
        return this.partialClassName.equals(another.partialClassName) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.partialClassName.hashCode();
        h = h * 17 + this.limit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ClassNamesRequest").add("partialClassName", this.partialClassName).add("limit", this.limit).toString();
    }

    @JsonCreator
    public static ClassNamesRequest fromAllAttributes(@JsonProperty(value="partialClassName") @Nullable String partialClassName, @JsonProperty(value="limit") @Nullable Integer limit) {
        Builder builder = ClassNamesRequest.builder();
        if (partialClassName != null) {
            builder.partialClassName(partialClassName);
        }
        if (limit != null) {
            builder.limit(limit);
        }
        return builder.build();
    }

    static ClassNamesRequest copyOf(InstrumentationJsonService.ClassNamesRequestBase instance) {
        if (instance instanceof ClassNamesRequest) {
            return (ClassNamesRequest)instance;
        }
        return ClassNamesRequest.builder().partialClassName(instance.partialClassName()).limit(instance.limit()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_PARTIAL_CLASS_NAME = 1L;
        private static final long INITIALIZED_BIT_LIMIT = 2L;
        private long initializedBitset;
        @Nullable
        private String partialClassName;
        private int limit;

        private Builder() {
        }

        public final Builder partialClassName(String partialClassName) {
            this.checkNotIsSet(this.partialClassNameIsSet(), "partialClassName");
            this.partialClassName = Preconditions.checkNotNull(partialClassName);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder limit(int limit) {
            this.checkNotIsSet(this.limitIsSet(), "limit");
            this.limit = limit;
            this.initializedBitset |= 2L;
            return this;
        }

        public ClassNamesRequest build() {
            this.checkRequiredAttributes();
            return new ClassNamesRequest(this.partialClassName, this.limit);
        }

        private boolean partialClassNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean limitIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ClassNamesRequest is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.partialClassNameIsSet()) {
                attributes.add("partialClassName");
            }
            if (!this.limitIsSet()) {
                attributes.add("limit");
            }
            return "Cannot build ClassNamesRequest, some of required attributes are not set " + attributes;
        }
    }
}

