/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.common.Clock;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.ui.DataSeries;

class DataSeriesHelper {
    private final Clock clock;
    private final long dataPointIntervalMillis;

    DataSeriesHelper(Clock clock, long dataPointIntervalMillis) {
        this.clock = clock;
        this.dataPointIntervalMillis = dataPointIntervalMillis;
    }

    void addInitialUpslopeIfNeeded(long requestFrom, long captureTime, List<DataSeries> dataSeriesList, @Nullable DataSeries otherDataSeries) {
        if (captureTime == requestFrom) {
            return;
        }
        long priorCaptureTime = this.getPriorCaptureTime(captureTime);
        for (DataSeries dataSeries : dataSeriesList) {
            dataSeries.add(priorCaptureTime, 0.0);
        }
        if (otherDataSeries != null) {
            otherDataSeries.add(priorCaptureTime, 0.0);
        }
    }

    void addGapIfNeeded(long lastCaptureTime, long captureTime, List<DataSeries> dataSeriesList, @Nullable DataSeries otherDataSeries) {
        long millisecondsSinceLastPoint = captureTime - lastCaptureTime;
        if (millisecondsSinceLastPoint <= this.dataPointIntervalMillis) {
            return;
        }
        for (DataSeries dataSeries : dataSeriesList) {
            this.addGap(dataSeries, lastCaptureTime, captureTime);
        }
        if (otherDataSeries != null) {
            this.addGap(otherDataSeries, lastCaptureTime, captureTime);
        }
    }

    void addFinalDownslopeIfNeeded(long requestCaptureTimeTo, List<DataSeries> dataSeriesList, @Nullable DataSeries otherDataSeries, long lastCaptureTime) {
        long downslopeCaptureTime = this.finalDownslopeCaptureTime(requestCaptureTimeTo, lastCaptureTime);
        if (downslopeCaptureTime != 0L) {
            for (DataSeries dataSeries : dataSeriesList) {
                dataSeries.add(downslopeCaptureTime, 0.0);
            }
            if (otherDataSeries != null) {
                otherDataSeries.add(downslopeCaptureTime, 0.0);
            }
        }
    }

    void addInitialUpslopeIfNeeded(long requestFrom, long captureTime, DataSeries dataSeries) {
        if (captureTime == requestFrom) {
            return;
        }
        long priorCaptureTime = this.getPriorCaptureTime(captureTime);
        dataSeries.add(priorCaptureTime, 0.0);
    }

    void addGapIfNeeded(long lastCaptureTime, long captureTime, DataSeries dataSeries) {
        long millisecondsSinceLastPoint = captureTime - lastCaptureTime;
        if (millisecondsSinceLastPoint <= this.dataPointIntervalMillis) {
            return;
        }
        this.addGap(dataSeries, lastCaptureTime, captureTime);
    }

    void addFinalDownslopeIfNeeded(long requestCaptureTimeTo, DataSeries dataSeries, long lastCaptureTime) {
        long downslopeCaptureTime = this.finalDownslopeCaptureTime(requestCaptureTimeTo, lastCaptureTime);
        if (downslopeCaptureTime != 0L) {
            dataSeries.add(downslopeCaptureTime, 0.0);
        }
    }

    private void addGap(DataSeries dataSeries, long lastCaptureTime, long captureTime) {
        long currentCaptureTime = this.getCurrentCaptureTime(captureTime);
        if (currentCaptureTime - lastCaptureTime == 2L * this.dataPointIntervalMillis) {
            dataSeries.add(lastCaptureTime + this.dataPointIntervalMillis, 0.0);
        } else {
            dataSeries.add(lastCaptureTime + this.dataPointIntervalMillis, 0.0);
            dataSeries.addNull();
            dataSeries.add(currentCaptureTime - this.dataPointIntervalMillis, 0.0);
        }
    }

    private long finalDownslopeCaptureTime(long requestCaptureTimeTo, long lastCaptureTime) {
        if (lastCaptureTime == requestCaptureTimeTo) {
            return 0L;
        }
        long now = this.clock.currentTimeMillis();
        long lastCaptureAgoFromNow = now - lastCaptureTime;
        if (lastCaptureAgoFromNow < this.dataPointIntervalMillis / 5L) {
            return 0L;
        }
        if (lastCaptureAgoFromNow > this.dataPointIntervalMillis) {
            return lastCaptureTime + this.dataPointIntervalMillis;
        }
        return now;
    }

    private long getPriorCaptureTime(long captureTime) {
        return this.getCurrentCaptureTime(captureTime) - this.dataPointIntervalMillis;
    }

    private long getCurrentCaptureTime(long captureTime) {
        return AggregateDao.getNextRollupTime(captureTime, this.dataPointIntervalMillis);
    }
}

