/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.collector.ErrorPoint;
import org.glowroot.collector.ErrorSummary;
import org.glowroot.common.Clock;
import org.glowroot.common.ObjectMappers;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.store.ErrorMessageCount;
import org.glowroot.local.store.ErrorMessageQuery;
import org.glowroot.local.store.ErrorSummaryQuery;
import org.glowroot.local.store.QueryResult;
import org.glowroot.local.store.TraceDao;
import org.glowroot.local.store.TraceErrorPoint;
import org.glowroot.local.ui.DataSeries;
import org.glowroot.local.ui.DataSeriesHelper;
import org.glowroot.local.ui.ErrorCommonService;
import org.glowroot.local.ui.ErrorMessageRequest;
import org.glowroot.local.ui.ErrorSummaryRequest;
import org.glowroot.local.ui.GET;
import org.glowroot.local.ui.JsonService;
import org.glowroot.local.ui.QueryStrings;
import org.glowroot.local.ui.TabBarDataRequest;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.fasterxml.jackson.databind.DeserializationFeature;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.google.common.io.CharStreams;
import org.immutables.value.Value;

@JsonService
class ErrorJsonService {
    private static final ObjectMapper mapper = ObjectMappers.create();
    private final ErrorCommonService errorCommonService;
    private final TraceDao traceDao;
    private final AggregateDao aggregateDao;
    private final Clock clock;

    ErrorJsonService(ErrorCommonService errorCommonService, TraceDao traceDao, AggregateDao aggregateDao, Clock clock) {
        this.errorCommonService = errorCommonService;
        this.traceDao = traceDao;
        this.aggregateDao = aggregateDao;
        this.clock = clock;
    }

    @GET(value="/backend/error/messages")
    String getData(String queryString) throws Exception {
        ErrorMessageRequest request = QueryStrings.decode(queryString, ErrorMessageRequest.class);
        ErrorMessageQuery query = ErrorMessageQuery.builder().transactionType(request.transactionType()).transactionName(request.transactionName()).from(request.from()).to(request.to()).addAllIncludes(request.include()).addAllExcludes(request.exclude()).limit(request.errorMessageLimit()).build();
        long liveCaptureTime = this.clock.currentTimeMillis();
        QueryResult<ErrorMessageCount> queryResult = this.traceDao.readErrorMessageCounts(query);
        List<ErrorPoint> unfilteredErrorPoints = this.errorCommonService.readErrorPoints(query.transactionType(), query.transactionName(), query.from(), query.to(), liveCaptureTime);
        DataSeries dataSeries = new DataSeries(null);
        HashMap<Long, Long[]> dataSeriesExtra = Maps.newHashMap();
        if (query.includes().isEmpty() && query.excludes().isEmpty()) {
            this.populateDataSeries(query, unfilteredErrorPoints, dataSeries, dataSeriesExtra);
        } else {
            HashMap<Long, Long> transactionCountMap = Maps.newHashMap();
            for (ErrorPoint unfilteredErrorPoint : unfilteredErrorPoints) {
                transactionCountMap.put(unfilteredErrorPoint.captureTime(), unfilteredErrorPoint.transactionCount());
            }
            ImmutableList<TraceErrorPoint> traceErrorPoints = this.traceDao.readErrorPoints(query, this.aggregateDao.getDataPointIntervalMillis(query.from(), query.to()), liveCaptureTime);
            ArrayList<ErrorPoint> errorPoints = Lists.newArrayList();
            for (TraceErrorPoint traceErrorPoint : traceErrorPoints) {
                Long transactionCount = (Long)transactionCountMap.get(traceErrorPoint.captureTime());
                if (transactionCount == null) continue;
                errorPoints.add(ErrorPoint.of(traceErrorPoint.captureTime(), traceErrorPoint.errorCount(), transactionCount));
            }
            this.populateDataSeries(query, errorPoints, dataSeries, dataSeriesExtra);
        }
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeObjectField("dataSeries", dataSeries);
        jg.writeObjectField("dataSeriesExtra", dataSeriesExtra);
        jg.writeFieldName("errorMessages");
        jg.writeObject(queryResult.records());
        jg.writeBooleanField("moreErrorMessagesAvailable", queryResult.moreAvailable());
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    @GET(value="/backend/error/summaries")
    String getSummaries(String queryString) throws Exception {
        ErrorSummaryRequest request = QueryStrings.decode(queryString, ErrorSummaryRequest.class);
        ErrorSummary overallSummary = this.errorCommonService.readOverallErrorSummary(request.transactionType(), request.from(), request.to());
        ErrorSummaryQuery query = ErrorSummaryQuery.builder().transactionType(request.transactionType()).from(request.from()).to(request.to()).sortOrder(request.sortOrder()).limit(request.limit()).build();
        QueryResult<ErrorSummary> queryResult = this.errorCommonService.readTransactionErrorSummaries(query);
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeFieldName("overall");
        jg.writeObject(overallSummary);
        jg.writeFieldName("transactions");
        jg.writeObject(queryResult.records());
        jg.writeBooleanField("moreAvailable", queryResult.moreAvailable());
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    @GET(value="/backend/error/tab-bar-data")
    String getTabBarData(String queryString) throws Exception {
        TabBarDataRequest request = QueryStrings.decode(queryString, TabBarDataRequest.class);
        String transactionName = request.transactionName();
        long traceCount = transactionName == null ? this.traceDao.readOverallErrorCount(request.transactionType(), request.from(), request.to()) : this.traceDao.readTransactionErrorCount(request.transactionType(), transactionName, request.from(), request.to());
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeNumberField("traceCount", traceCount);
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    private void populateDataSeries(ErrorMessageQuery request, List<ErrorPoint> errorPoints, DataSeries dataSeries, Map<Long, Long[]> dataSeriesExtra) {
        DataSeriesHelper dataSeriesHelper = new DataSeriesHelper(this.clock, this.aggregateDao.getDataPointIntervalMillis(request.from(), request.to()));
        ErrorPoint lastErrorPoint = null;
        for (ErrorPoint errorPoint : errorPoints) {
            if (lastErrorPoint == null) {
                dataSeriesHelper.addInitialUpslopeIfNeeded(request.from(), errorPoint.captureTime(), dataSeries);
            } else {
                dataSeriesHelper.addGapIfNeeded(lastErrorPoint.captureTime(), errorPoint.captureTime(), dataSeries);
            }
            lastErrorPoint = errorPoint;
            long transactionCount = errorPoint.transactionCount();
            dataSeries.add(errorPoint.captureTime(), (double)(100L * errorPoint.errorCount()) / (double)transactionCount);
            dataSeriesExtra.put(errorPoint.captureTime(), new Long[]{errorPoint.errorCount(), transactionCount});
        }
        if (lastErrorPoint != null) {
            dataSeriesHelper.addFinalDownslopeIfNeeded(request.to(), dataSeries, lastErrorPoint.captureTime());
        }
    }

    static {
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    }

    @Value.Immutable
    static abstract class ErrorMessageRequestBase {
        ErrorMessageRequestBase() {
        }

        abstract long from();

        abstract long to();

        abstract String transactionType();

        @Nullable
        abstract String transactionName();

        abstract ImmutableList<String> include();

        abstract ImmutableList<String> exclude();

        abstract int errorMessageLimit();
    }

    @Value.Immutable
    static abstract class TabBarDataRequestBase {
        TabBarDataRequestBase() {
        }

        abstract long from();

        abstract long to();

        abstract String transactionType();

        @Nullable
        abstract String transactionName();
    }

    @Value.Immutable
    static abstract class ErrorSummaryRequestBase {
        ErrorSummaryRequestBase() {
        }

        abstract long from();

        abstract long to();

        abstract String transactionType();

        abstract AggregateDao.ErrorSummarySortOrder sortOrder();

        abstract int limit();
    }
}

