/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.File;
import javax.annotation.Nullable;
import org.glowroot.common.ChunkSource;
import org.glowroot.local.ui.ChunkedInputs;
import org.glowroot.local.ui.HttpServices;
import org.glowroot.local.ui.UnauthenticatedHttpService;
import org.glowroot.shaded.google.common.base.Charsets;
import org.glowroot.shaded.google.common.io.CharSource;
import org.glowroot.shaded.google.common.io.Files;
import org.glowroot.shaded.netty.channel.ChannelFuture;
import org.glowroot.shaded.netty.channel.ChannelHandlerContext;
import org.glowroot.shaded.netty.handler.codec.http.DefaultHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.FullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.HttpHeaders;
import org.glowroot.shaded.netty.handler.codec.http.HttpRequest;
import org.glowroot.shaded.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.shaded.netty.handler.codec.http.HttpVersion;

class GlowrootLogHttpService
implements UnauthenticatedHttpService {
    private final File baseDir;

    GlowrootLogHttpService(File baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    @Nullable
    public FullHttpResponse handleRequest(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        File glowrootLogFile = new File(this.baseDir, "glowroot.log");
        CharSource glowrootLogCharSource = Files.asCharSource(glowrootLogFile, Charsets.UTF_8);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set("Transfer-Encoding", (Object)"chunked");
        response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
        boolean keepAlive = HttpHeaders.isKeepAlive(request);
        if (keepAlive && !request.getProtocolVersion().isKeepAliveDefault()) {
            response.headers().set("Connection", (Object)"keep-alive");
        }
        HttpServices.preventCaching(response);
        ctx.write(response);
        ChannelFuture future = ctx.write(ChunkedInputs.from(ChunkSource.from(glowrootLogCharSource)));
        HttpServices.addErrorListener(future);
        if (!keepAlive) {
            HttpServices.addCloseListener(future);
        }
        return null;
    }
}

