/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.glowroot.common.Reflections;
import org.glowroot.common.Styles;
import org.glowroot.local.ui.GET;
import org.glowroot.local.ui.HttpService;
import org.glowroot.local.ui.HttpServices;
import org.glowroot.local.ui.HttpSessionManager;
import org.glowroot.local.ui.JsonServiceException;
import org.glowroot.local.ui.JsonServiceMapping;
import org.glowroot.local.ui.JsonServiceMatcher;
import org.glowroot.local.ui.LayoutService;
import org.glowroot.local.ui.POST;
import org.glowroot.local.ui.UnauthenticatedHttpService;
import org.glowroot.shaded.fasterxml.jackson.core.JsonFactory;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.Charsets;
import org.glowroot.shaded.google.common.base.Joiner;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.io.CharStreams;
import org.glowroot.shaded.google.common.io.Resources;
import org.glowroot.shaded.google.common.net.MediaType;
import org.glowroot.shaded.netty.buffer.ByteBuf;
import org.glowroot.shaded.netty.buffer.Unpooled;
import org.glowroot.shaded.netty.channel.Channel;
import org.glowroot.shaded.netty.channel.ChannelFuture;
import org.glowroot.shaded.netty.channel.ChannelFutureListener;
import org.glowroot.shaded.netty.channel.ChannelHandler;
import org.glowroot.shaded.netty.channel.ChannelHandlerContext;
import org.glowroot.shaded.netty.channel.ChannelInboundHandlerAdapter;
import org.glowroot.shaded.netty.channel.group.ChannelGroup;
import org.glowroot.shaded.netty.channel.group.DefaultChannelGroup;
import org.glowroot.shaded.netty.handler.codec.http.DefaultFullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.FullHttpRequest;
import org.glowroot.shaded.netty.handler.codec.http.FullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.HttpHeaders;
import org.glowroot.shaded.netty.handler.codec.http.HttpRequest;
import org.glowroot.shaded.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.shaded.netty.handler.codec.http.HttpVersion;
import org.glowroot.shaded.netty.handler.codec.http.QueryStringDecoder;
import org.glowroot.shaded.netty.util.concurrent.GlobalEventExecutor;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.immutables.value.Value;

@ChannelHandler.Sharable
class HttpServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerHandler.class);
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final long TEN_YEARS = TimeUnit.DAYS.toMillis(3650L);
    private static final long ONE_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final long FIVE_MINUTES = TimeUnit.MINUTES.toMillis(5L);
    private static final String RESOURCE_BASE = "org/glowroot/local/ui/app-dist";
    @Nullable
    private static final String RESOURCE_BASE_URL_PREFIX;
    private static final ImmutableMap<String, MediaType> mediaTypes;
    private final ChannelGroup allChannels;
    private final LayoutService layoutService;
    private final ImmutableMap<Pattern, HttpService> httpServices;
    private final ImmutableList<JsonServiceMapping> jsonServiceMappings;
    private final HttpSessionManager httpSessionManager;
    private final ThreadLocal<Channel> currentChannel = new ThreadLocal();

    HttpServerHandler(LayoutService layoutService, Map<Pattern, HttpService> httpServices, HttpSessionManager httpSessionManager, List<Object> jsonServices) {
        this.layoutService = layoutService;
        this.httpServices = ImmutableMap.copyOf(httpServices);
        this.httpSessionManager = httpSessionManager;
        ArrayList<JsonServiceMapping> jsonServiceMappings = Lists.newArrayList();
        for (Object jsonService : jsonServices) {
            for (Method method : jsonService.getClass().getDeclaredMethods()) {
                POST annotationPOST;
                GET annotationGET = method.getAnnotation(GET.class);
                if (annotationGET != null) {
                    jsonServiceMappings.add(JsonServiceMapping.builder().httpMethod(HttpMethod.GET).path(annotationGET.value()).service(jsonService).methodName(method.getName()).build());
                }
                if ((annotationPOST = method.getAnnotation(POST.class)) == null) continue;
                jsonServiceMappings.add(JsonServiceMapping.builder().httpMethod(HttpMethod.POST).path(annotationPOST.value()).service(jsonService).methodName(method.getName()).build());
            }
        }
        this.jsonServiceMappings = ImmutableList.copyOf(jsonServiceMappings);
        this.allChannels = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.allChannels.add(ctx.channel());
        super.channelActive(ctx);
    }

    void close() {
        this.allChannels.close().awaitUninterruptibly();
    }

    void closeAllButCurrent() {
        Channel current = this.currentChannel.get();
        for (Channel channel : this.allChannels) {
            if (channel == current) continue;
            channel.close().awaitUninterruptibly();
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        FullHttpRequest request = (FullHttpRequest)msg;
        logger.debug("messageReceived(): request.uri={}", (Object)request.getUri());
        Channel channel = ctx.channel();
        this.currentChannel.set(channel);
        try {
            FullHttpResponse response = this.handleRequest(ctx, request);
            if (response != null) {
                this.sendFullResponse(ctx, request, response);
            }
        }
        catch (Exception f) {
            logger.error(f.getMessage(), f);
            FullHttpResponse response = HttpServerHandler.newHttpResponseWithStackTrace(f, HttpResponseStatus.INTERNAL_SERVER_ERROR, null);
            this.sendFullResponse(ctx, request, response);
        }
        finally {
            this.currentChannel.remove();
            request.release();
        }
    }

    private void sendFullResponse(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse response) {
        boolean keepAlive = HttpHeaders.isKeepAlive(request);
        if (this.httpSessionManager.getSessionId(request) != null && this.httpSessionManager.getAuthenticatedUser(request) == null && !response.headers().contains("Set-Cookie")) {
            this.httpSessionManager.deleteSessionCookie(response);
        }
        response.headers().add("Glowroot-Layout-Version", (Object)this.layoutService.getLayoutVersion());
        if (response.headers().get("Glowroot-Port-Changed") != null) {
            response.headers().remove("Glowroot-Port-Changed");
            response.headers().add("Connection", (Object)"close");
            keepAlive = false;
        }
        response.headers().add("Content-Length", (Object)response.content().readableBytes());
        if (keepAlive && !request.getProtocolVersion().isKeepAliveDefault()) {
            response.headers().set("Connection", (Object)"keep-alive");
        }
        ChannelFuture f = ctx.write(response);
        if (!keepAlive) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (HttpServices.shouldLogException(cause)) {
            logger.warn(cause.getMessage(), cause);
        }
        ctx.close();
    }

    @Nullable
    private FullHttpResponse handleRequest(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        logger.debug("handleRequest(): request.uri={}", (Object)request.getUri());
        QueryStringDecoder decoder = new QueryStringDecoder(request.getUri());
        String path = decoder.path();
        logger.debug("handleRequest(): path={}", (Object)path);
        FullHttpResponse response = this.handleIfLoginOrLogoutRequest(path, request);
        if (response != null) {
            return response;
        }
        HttpService httpService = this.getHttpService(path);
        if (httpService != null) {
            return this.handleHttpService(ctx, request, httpService);
        }
        JsonServiceMatcher jsonServiceMatcher = this.getJsonServiceMatcher(request, path);
        if (jsonServiceMatcher != null) {
            return this.handleJsonServiceMappings(request, jsonServiceMatcher.jsonServiceMapping(), jsonServiceMatcher.matcher());
        }
        return this.handleStaticResource(path, request);
    }

    @Nullable
    private FullHttpResponse handleIfLoginOrLogoutRequest(String path, FullHttpRequest request) throws IOException {
        if (path.equals("/backend/authenticated-user")) {
            return this.handleAuthenticatedUserRequest(request);
        }
        if (path.equals("/backend/admin-login")) {
            return this.httpSessionManager.login(request, true);
        }
        if (path.equals("/backend/read-only-login")) {
            return this.httpSessionManager.login(request, false);
        }
        if (path.equals("/backend/sign-out")) {
            return this.httpSessionManager.signOut(request);
        }
        return null;
    }

    private FullHttpResponse handleAuthenticatedUserRequest(FullHttpRequest request) {
        String authenticatedUser = this.httpSessionManager.getAuthenticatedUser(request);
        if (authenticatedUser == null) {
            return HttpServices.createJsonResponse("null", HttpResponseStatus.OK);
        }
        return HttpServices.createJsonResponse("\"" + authenticatedUser + "\"", HttpResponseStatus.OK);
    }

    @Nullable
    private HttpService getHttpService(String path) throws Exception {
        for (Map.Entry entry : this.httpServices.entrySet()) {
            Matcher matcher = ((Pattern)entry.getKey()).matcher(path);
            if (!matcher.matches()) continue;
            return (HttpService)entry.getValue();
        }
        return null;
    }

    @Nullable
    private FullHttpResponse handleHttpService(ChannelHandlerContext ctx, FullHttpRequest request, HttpService httpService) throws Exception {
        if (!this.httpSessionManager.hasReadAccess(request) && !(httpService instanceof UnauthenticatedHttpService)) {
            return this.handleNotAuthenticated(request);
        }
        boolean isGetRequest = request.getMethod().name().equals(HttpMethod.GET.name());
        if (!isGetRequest && !this.httpSessionManager.hasAdminAccess(request)) {
            return this.handleNotAuthorized();
        }
        return httpService.handleRequest(ctx, request);
    }

    @Nullable
    private JsonServiceMatcher getJsonServiceMatcher(FullHttpRequest request, String path) {
        for (JsonServiceMapping jsonServiceMapping : this.jsonServiceMappings) {
            Matcher matcher;
            if (!jsonServiceMapping.httpMethod().name().equals(request.getMethod().name()) || !(matcher = jsonServiceMapping.pattern().matcher(path)).matches()) continue;
            return JsonServiceMatcher.of(jsonServiceMapping, matcher);
        }
        return null;
    }

    private FullHttpResponse handleJsonServiceMappings(FullHttpRequest request, JsonServiceMapping jsonServiceMapping, Matcher matcher) {
        Object responseObject;
        if (!this.httpSessionManager.hasReadAccess(request)) {
            return this.handleNotAuthenticated(request);
        }
        boolean isGetRequest = request.getMethod().name().equals(HttpMethod.GET.name());
        if (!isGetRequest && !this.httpSessionManager.hasAdminAccess(request)) {
            return this.handleNotAuthorized();
        }
        String requestText = HttpServerHandler.getRequestText(request);
        String[] args = new String[matcher.groupCount()];
        for (int i = 0; i < args.length; ++i) {
            String group = matcher.group(i + 1);
            Preconditions.checkNotNull(group);
            args[i] = group;
        }
        logger.debug("handleJsonRequest(): serviceMethodName={}, args={}, requestText={}", jsonServiceMapping.methodName(), args, requestText);
        try {
            responseObject = HttpServerHandler.callMethod(jsonServiceMapping.service(), jsonServiceMapping.methodName(), args, requestText);
        }
        catch (Exception e) {
            return HttpServerHandler.newHttpResponseFromException(e);
        }
        return this.buildJsonResponse(responseObject);
    }

    private FullHttpResponse buildJsonResponse(@Nullable Object responseObject) {
        FullHttpResponse response;
        if (responseObject == null) {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        } else if (responseObject instanceof FullHttpResponse) {
            response = (FullHttpResponse)responseObject;
        } else if (responseObject instanceof String) {
            ByteBuf content = Unpooled.copiedBuffer(responseObject.toString(), Charsets.ISO_8859_1);
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        } else {
            logger.warn("unexpected type of json service response: {}", (Object)responseObject.getClass().getName());
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        response.headers().add("Content-Type", (Object)MediaType.JSON_UTF_8);
        HttpServices.preventCaching(response);
        return response;
    }

    private FullHttpResponse handleNotAuthenticated(HttpRequest request) {
        if (this.httpSessionManager.getSessionId(request) != null) {
            return HttpServices.createJsonResponse("{\"timedOut\":true}", HttpResponseStatus.UNAUTHORIZED);
        }
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
    }

    private FullHttpResponse handleNotAuthorized() {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
    }

    private FullHttpResponse handleStaticResource(String path, HttpRequest request) throws IOException {
        URL url = HttpServerHandler.getSecureUrlForPath(RESOURCE_BASE + path);
        if (url == null) {
            logger.warn("unexpected path: {}", (Object)path);
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
        }
        Date expires = HttpServerHandler.getExpiresForPath(path);
        if (request.headers().contains("If-Modified-Since") && expires == null) {
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        }
        ByteBuf content = Unpooled.copiedBuffer(Resources.toByteArray(url));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        if (expires != null) {
            response.headers().add("Expires", (Object)expires);
        } else {
            response.headers().add("Last-Modified", (Object)new Date(0L));
            response.headers().add("Expires", (Object)new Date(System.currentTimeMillis() + TEN_YEARS));
        }
        int extensionStartIndex = path.lastIndexOf(46);
        Preconditions.checkState(extensionStartIndex != -1, "found path under %s with no extension: %s", RESOURCE_BASE, path);
        String extension = path.substring(extensionStartIndex + 1);
        MediaType mediaType = mediaTypes.get(extension);
        Preconditions.checkNotNull(mediaType, "found extension under %s with no media type: %s", RESOURCE_BASE, extension);
        response.headers().add("Content-Type", (Object)mediaType);
        response.headers().add("Content-Length", (Object)Resources.toByteArray(url).length);
        return response;
    }

    @Nullable
    private static URL getSecureUrlForPath(String path) {
        URL url = HttpServerHandler.getUrlForPath(path);
        if (url != null && RESOURCE_BASE_URL_PREFIX != null && url.toExternalForm().startsWith(RESOURCE_BASE_URL_PREFIX)) {
            return url;
        }
        return null;
    }

    @Nullable
    private static URL getUrlForPath(String path) {
        ClassLoader classLoader = HttpServerHandler.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(path);
        }
        return classLoader.getResource(path);
    }

    @Nullable
    private static Date getExpiresForPath(String path) {
        if (path.startsWith("org/glowroot/local/ui/app-dist/favicon.")) {
            return new Date(System.currentTimeMillis() + ONE_DAY);
        }
        if (path.endsWith(".js.map") || path.startsWith("/sources/")) {
            return new Date(System.currentTimeMillis() + FIVE_MINUTES);
        }
        return null;
    }

    @VisibleForTesting
    static FullHttpResponse newHttpResponseFromException(Exception exception) {
        Throwable cause;
        Exception e = exception;
        if (e instanceof InvocationTargetException && (cause = e.getCause()) instanceof Exception) {
            e = (Exception)cause;
        }
        if (e instanceof JsonServiceException) {
            JsonServiceException jsonServiceException = (JsonServiceException)e;
            return HttpServerHandler.newHttpResponseWithMessage(jsonServiceException.getStatus(), jsonServiceException.getMessage());
        }
        logger.error(e.getMessage(), e);
        if (e instanceof SQLException && ((SQLException)e).getErrorCode() == 57014) {
            return HttpServerHandler.newHttpResponseWithMessage(HttpResponseStatus.REQUEST_TIMEOUT, "Query timed out (timeout is configurable under Configuration > Advanced)");
        }
        return HttpServerHandler.newHttpResponseWithStackTrace(e, HttpResponseStatus.INTERNAL_SERVER_ERROR, null);
    }

    private static FullHttpResponse newHttpResponseWithMessage(HttpResponseStatus status, @Nullable String message) {
        StringBuilder sb = new StringBuilder();
        try {
            JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter(sb));
            jg.writeStartObject();
            jg.writeStringField("message", message);
            jg.writeEndObject();
            jg.close();
            return HttpServices.createJsonResponse(sb.toString(), status);
        }
        catch (IOException f) {
            logger.error(f.getMessage(), f);
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private static FullHttpResponse newHttpResponseWithStackTrace(Exception e, HttpResponseStatus status, @Nullable String simplifiedMessage) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        StringBuilder sb = new StringBuilder();
        try {
            String message;
            JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter(sb));
            jg.writeStartObject();
            if (simplifiedMessage == null) {
                Throwable cause = e;
                Throwable childCause = cause.getCause();
                while (childCause != null) {
                    cause = childCause;
                    childCause = cause.getCause();
                }
                message = cause.getMessage();
            } else {
                message = simplifiedMessage;
            }
            jg.writeStringField("message", message);
            jg.writeStringField("stackTrace", sw.toString());
            jg.writeEndObject();
            jg.close();
            return HttpServices.createJsonResponse(sb.toString(), status);
        }
        catch (IOException f) {
            logger.error(f.getMessage(), f);
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Nullable
    private static Object callMethod(Object object, String methodName, String[] args, String requestText) throws Exception {
        ArrayList<Class<String>> parameterTypes = Lists.newArrayList();
        ArrayList<String> parameters = Lists.newArrayList();
        for (int i = 0; i < args.length; ++i) {
            parameterTypes.add(String.class);
            parameters.add(args[i]);
        }
        Method method = null;
        try {
            method = Reflections.getDeclaredMethod(object.getClass(), methodName, parameterTypes.toArray(new Class[parameterTypes.size()]));
        }
        catch (Exception e) {
            logger.trace(e.getMessage(), e);
            parameterTypes.add(String.class);
            parameters.add(requestText);
            try {
                method = Reflections.getDeclaredMethod(object.getClass(), methodName, parameterTypes.toArray(new Class[parameterTypes.size()]));
            }
            catch (Exception f) {
                logger.trace(f.getMessage(), f);
                throw new NoSuchMethodException(methodName);
            }
        }
        if (logger.isDebugEnabled()) {
            String params = Joiner.on(", ").join(parameters);
            logger.debug("{}.{}(): {}", object.getClass().getSimpleName(), methodName, params);
        }
        return Reflections.invoke(method, object, parameters.toArray(new Object[parameters.size()]));
    }

    private static String getRequestText(FullHttpRequest request) {
        if (request.getMethod() == org.glowroot.shaded.netty.handler.codec.http.HttpMethod.POST) {
            return request.content().toString(Charsets.ISO_8859_1);
        }
        int index = request.getUri().indexOf(63);
        if (index == -1) {
            return "";
        }
        return request.getUri().substring(index + 1);
    }

    static {
        mediaTypes = ImmutableMap.builder().put("html", MediaType.HTML_UTF_8).put("js", MediaType.JAVASCRIPT_UTF_8).put("css", MediaType.CSS_UTF_8).put("ico", MediaType.ICO).put("woff", MediaType.WOFF).put("woff2", MediaType.create("application", "font-woff2")).put("swf", MediaType.create("application", "vnd.adobe.flash-movie")).put("map", MediaType.JSON_UTF_8).build();
        URL resourceBaseUrl = HttpServerHandler.getUrlForPath(RESOURCE_BASE);
        RESOURCE_BASE_URL_PREFIX = resourceBaseUrl == null ? null : resourceBaseUrl.toExternalForm();
    }

    static enum HttpMethod {
        GET,
        POST;

    }

    @Value.Immutable
    static abstract class JsonServiceMappingBase {
        JsonServiceMappingBase() {
        }

        abstract HttpMethod httpMethod();

        abstract String path();

        abstract Object service();

        abstract String methodName();

        Pattern pattern() {
            String path = this.path();
            if (path.contains("(")) {
                return Pattern.compile(path);
            }
            return Pattern.compile(Pattern.quote(path));
        }
    }

    @Value.Immutable
    @Styles.AllParameters
    static abstract class JsonServiceMatcherBase {
        JsonServiceMatcherBase() {
        }

        abstract JsonServiceMapping jsonServiceMapping();

        abstract Matcher matcher();
    }
}

