/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Date;
import org.glowroot.shaded.google.common.base.Charsets;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.net.MediaType;
import org.glowroot.shaded.netty.buffer.ByteBuf;
import org.glowroot.shaded.netty.buffer.Unpooled;
import org.glowroot.shaded.netty.channel.ChannelFuture;
import org.glowroot.shaded.netty.channel.ChannelFutureListener;
import org.glowroot.shaded.netty.handler.codec.http.DefaultFullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.FullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.HttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.shaded.netty.handler.codec.http.HttpVersion;
import org.glowroot.shaded.netty.util.concurrent.Future;
import org.glowroot.shaded.netty.util.concurrent.GenericFutureListener;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class HttpServices {
    private static final Logger logger = LoggerFactory.getLogger(HttpServices.class);
    private static final ImmutableSet<String> BROWSER_DISCONNECT_MESSAGES = ImmutableSet.of("An existing connection was forcibly closed by the remote host", "An established connection was aborted by the software in your host machine", "Connection reset by peer");

    private HttpServices() {
    }

    static void preventCaching(HttpResponse response) {
        response.headers().set("Cache-Control", (Object)"no-cache, no-store, must-revalidate");
        response.headers().set("Pragma", (Object)"no-cache");
        response.headers().set("Expires", (Object)new Date(0L));
    }

    static FullHttpResponse createJsonResponse(String content, HttpResponseStatus status) {
        ByteBuf byteBuf = Unpooled.copiedBuffer(content, Charsets.ISO_8859_1);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, byteBuf);
        response.headers().add("Content-Type", (Object)MediaType.JSON_UTF_8);
        HttpServices.preventCaching(response);
        return response;
    }

    static void addErrorListener(ChannelFuture future) {
        future.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<ChannelFuture>(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                Throwable cause = future.cause();
                if (cause == null) {
                    return;
                }
                if (HttpServices.shouldLogException(cause)) {
                    logger.error(cause.getMessage(), cause);
                }
                future.channel().close();
            }
        });
    }

    static void addCloseListener(ChannelFuture future) {
        future.addListener(ChannelFutureListener.CLOSE);
    }

    static boolean shouldLogException(Throwable t) {
        if (t instanceof InterruptedException) {
            logger.debug(t.getMessage(), t);
            return false;
        }
        if (t instanceof IOException && BROWSER_DISCONNECT_MESSAGES.contains(t.getMessage())) {
            logger.debug(t.getMessage(), t);
            return false;
        }
        if (t instanceof ClosedChannelException) {
            logger.debug(t.getMessage(), t);
            return false;
        }
        return true;
    }
}

