/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.net.URL;
import javax.annotation.Nullable;
import org.glowroot.local.ui.HttpServices;
import org.glowroot.local.ui.HttpSessionManager;
import org.glowroot.local.ui.LayoutService;
import org.glowroot.local.ui.UnauthenticatedHttpService;
import org.glowroot.shaded.google.common.base.Charsets;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.google.common.io.Resources;
import org.glowroot.shaded.netty.buffer.ByteBuf;
import org.glowroot.shaded.netty.buffer.Unpooled;
import org.glowroot.shaded.netty.channel.ChannelHandlerContext;
import org.glowroot.shaded.netty.handler.codec.http.DefaultFullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.FullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.HttpRequest;
import org.glowroot.shaded.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.shaded.netty.handler.codec.http.HttpVersion;

class IndexHtmlHttpService
implements UnauthenticatedHttpService {
    private static final String BASE_HREF;
    @Nullable
    private static final String GOOGLE_ANALYTICS_TRACKING_ID;
    private final HttpSessionManager httpSessionManager;
    private final LayoutService layoutJsonService;

    IndexHtmlHttpService(HttpSessionManager httpSessionManager, LayoutService layoutJsonService) {
        this.httpSessionManager = httpSessionManager;
        this.layoutJsonService = layoutJsonService;
    }

    @Override
    public FullHttpResponse handleRequest(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        URL url = Resources.getResource("org/glowroot/local/ui/app-dist/index.html");
        String indexHtml = Resources.toString(url, Charsets.UTF_8);
        String layout = this.httpSessionManager.hasReadAccess(request) ? this.layoutJsonService.getLayout() : this.layoutJsonService.getNeedsAuthenticationLayout();
        String authenticatedUser = this.httpSessionManager.getAuthenticatedUser(request);
        String layoutScript = "var layout=" + layout + ";var authenticatedUser = '" + Strings.nullToEmpty(authenticatedUser) + "'";
        indexHtml = indexHtml.replaceFirst("<base href=\"/\">", "<base href=\"" + BASE_HREF + "\"><script>" + layoutScript + "</script>");
        indexHtml = indexHtml.replaceFirst("<link rel=\"shortcut icon\" href=\"favicon\\.([0-9a-f]+)\\.ico\">", "<script>document.write('<link rel=\"shortcut icon\" href=\"' + document.getElementsByTagName(\"base\")[0].href + 'favicon.$1.ico\">');</script>");
        if (GOOGLE_ANALYTICS_TRACKING_ID != null) {
            indexHtml = indexHtml.replaceFirst("<div class=\"navbar-brand\">(\\s*)Glowroot(\\s*)</div>", "<a href=\"https://glowroot.org\" class=\"navbar-brand\">$1Glowroot$2</a>");
            indexHtml = indexHtml.replaceFirst("</body>", "  <script>(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)})(window,document,'script','//www.google-analytics.com/analytics.js','ga');ga('create', '" + GOOGLE_ANALYTICS_TRACKING_ID + "', 'auto');" + "</script>\n</body>");
        }
        ByteBuf content = Unpooled.copiedBuffer(indexHtml, Charsets.ISO_8859_1);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        HttpServices.preventCaching(response);
        response.headers().set("Content-Type", (Object)"text/html; charset=UTF-8");
        response.headers().set("Content-Length", (Object)indexHtml.length());
        response.headers().set("X-UA-Compatible", (Object)"IE=edge");
        return response;
    }

    static {
        GOOGLE_ANALYTICS_TRACKING_ID = System.getProperty("glowroot.internal.googleAnalyticsTrackingId");
        String uiBase = System.getProperty("glowroot.ui.base");
        BASE_HREF = Strings.isNullOrEmpty(uiBase) ? "/" : uiBase;
    }
}

