/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.CaptureKind;
import org.glowroot.local.ui.InstrumentationJsonService;
import org.glowroot.plugin.api.weaving.MethodModifier;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Optional;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class InstrumentationConfigDto
extends InstrumentationJsonService.InstrumentationConfigDtoBase {
    private final String className;
    private final Optional<String> declaringClassName;
    private final String methodName;
    private final ImmutableList<String> methodParameterTypes;
    private final Optional<String> methodReturnType;
    private final ImmutableList<MethodModifier> methodModifiers;
    private final CaptureKind captureKind;
    private final Optional<String> timerName;
    private final Optional<String> traceEntryTemplate;
    @Nullable
    private final Long traceEntryStackThresholdMillis;
    private final Optional<Boolean> traceEntryCaptureSelfNested;
    private final Optional<String> transactionType;
    private final Optional<String> transactionNameTemplate;
    private final Optional<String> transactionUserTemplate;
    private final ImmutableMap<String, String> transactionCustomAttributeTemplates;
    @Nullable
    private final Long transactionSlowThresholdMillis;
    private final Optional<String> enabledProperty;
    private final Optional<String> traceEntryEnabledProperty;
    @Nullable
    private final String version;

    private InstrumentationConfigDto(String className, Optional<String> declaringClassName, String methodName, ImmutableList<String> methodParameterTypes, Optional<String> methodReturnType, ImmutableList<MethodModifier> methodModifiers, CaptureKind captureKind, Optional<String> timerName, Optional<String> traceEntryTemplate, @Nullable Long traceEntryStackThresholdMillis, Optional<Boolean> traceEntryCaptureSelfNested, Optional<String> transactionType, Optional<String> transactionNameTemplate, Optional<String> transactionUserTemplate, ImmutableMap<String, String> transactionCustomAttributeTemplates, @Nullable Long transactionSlowThresholdMillis, Optional<String> enabledProperty, Optional<String> traceEntryEnabledProperty, @Nullable String version) {
        this.className = className;
        this.declaringClassName = declaringClassName;
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
        this.methodReturnType = methodReturnType;
        this.methodModifiers = methodModifiers;
        this.captureKind = captureKind;
        this.timerName = timerName;
        this.traceEntryTemplate = traceEntryTemplate;
        this.traceEntryStackThresholdMillis = traceEntryStackThresholdMillis;
        this.traceEntryCaptureSelfNested = traceEntryCaptureSelfNested;
        this.transactionType = transactionType;
        this.transactionNameTemplate = transactionNameTemplate;
        this.transactionUserTemplate = transactionUserTemplate;
        this.transactionCustomAttributeTemplates = transactionCustomAttributeTemplates;
        this.transactionSlowThresholdMillis = transactionSlowThresholdMillis;
        this.enabledProperty = enabledProperty;
        this.traceEntryEnabledProperty = traceEntryEnabledProperty;
        this.version = version;
    }

    @Override
    @JsonProperty(value="className")
    public String className() {
        return this.className;
    }

    @Override
    @JsonProperty(value="declaringClassName")
    public Optional<String> declaringClassName() {
        return this.declaringClassName;
    }

    @Override
    @JsonProperty(value="methodName")
    public String methodName() {
        return this.methodName;
    }

    @Override
    @JsonProperty(value="methodParameterTypes")
    public ImmutableList<String> methodParameterTypes() {
        return this.methodParameterTypes;
    }

    @Override
    @JsonProperty(value="methodReturnType")
    public Optional<String> methodReturnType() {
        return this.methodReturnType;
    }

    @Override
    @JsonProperty(value="methodModifiers")
    public ImmutableList<MethodModifier> methodModifiers() {
        return this.methodModifiers;
    }

    @Override
    @JsonProperty(value="captureKind")
    public CaptureKind captureKind() {
        return this.captureKind;
    }

    @Override
    @JsonProperty(value="timerName")
    public Optional<String> timerName() {
        return this.timerName;
    }

    @Override
    @JsonProperty(value="traceEntryTemplate")
    public Optional<String> traceEntryTemplate() {
        return this.traceEntryTemplate;
    }

    @Override
    @JsonProperty(value="traceEntryStackThresholdMillis")
    public Long traceEntryStackThresholdMillis() {
        return this.traceEntryStackThresholdMillis;
    }

    @Override
    @JsonProperty(value="traceEntryCaptureSelfNested")
    public Optional<Boolean> traceEntryCaptureSelfNested() {
        return this.traceEntryCaptureSelfNested;
    }

    @Override
    @JsonProperty(value="transactionType")
    public Optional<String> transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionNameTemplate")
    public Optional<String> transactionNameTemplate() {
        return this.transactionNameTemplate;
    }

    @Override
    @JsonProperty(value="transactionUserTemplate")
    public Optional<String> transactionUserTemplate() {
        return this.transactionUserTemplate;
    }

    @JsonProperty(value="transactionCustomAttributeTemplates")
    public ImmutableMap<String, String> transactionCustomAttributeTemplates() {
        return this.transactionCustomAttributeTemplates;
    }

    @Override
    @JsonProperty(value="transactionSlowThresholdMillis")
    public Long transactionSlowThresholdMillis() {
        return this.transactionSlowThresholdMillis;
    }

    @Override
    @JsonProperty(value="enabledProperty")
    public Optional<String> enabledProperty() {
        return this.enabledProperty;
    }

    @Override
    @JsonProperty(value="traceEntryEnabledProperty")
    public Optional<String> traceEntryEnabledProperty() {
        return this.traceEntryEnabledProperty;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final InstrumentationConfigDto withClassName(String value) {
        if (this.className == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfigDto(newValue, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withDeclaringClassName(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this.className, newValue, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withDeclaringClassName(Optional<String> optional) {
        if (this.declaringClassName == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this.className, newValue, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodName(String value) {
        if (this.methodName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, newValue, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodParameterTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, newValue, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodParameterTypes(Iterable<String> elements) {
        if (this.methodParameterTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, newValue, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodReturnType(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, newValue, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodReturnType(Optional<String> optional) {
        if (this.methodReturnType == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, newValue, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodModifiers(MethodModifier ... elements) {
        ImmutableList<MethodModifier> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, newValue, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withMethodModifiers(Iterable<? extends MethodModifier> elements) {
        if (this.methodModifiers == elements) {
            return this;
        }
        ImmutableList<MethodModifier> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, newValue, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withCaptureKind(CaptureKind value) {
        if (this.captureKind == value) {
            return this;
        }
        CaptureKind newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, newValue, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTimerName(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, newValue, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTimerName(Optional<String> optional) {
        if (this.timerName == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, newValue, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryTemplate(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, newValue, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryTemplate(Optional<String> optional) {
        if (this.traceEntryTemplate == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, newValue, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryStackThresholdMillis(@Nullable Long value) {
        if (this.traceEntryStackThresholdMillis == value) {
            return this;
        }
        Long newValue = value;
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, newValue, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryCaptureSelfNested(boolean value) {
        Optional<Boolean> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, newValue, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryCaptureSelfNested(Optional<Boolean> optional) {
        if (this.traceEntryCaptureSelfNested == optional) {
            return this;
        }
        Optional<Boolean> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, newValue, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionType(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, newValue, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionType(Optional<String> optional) {
        if (this.transactionType == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, newValue, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionNameTemplate(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, newValue, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionNameTemplate(Optional<String> optional) {
        if (this.transactionNameTemplate == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, newValue, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionUserTemplate(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, newValue, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionUserTemplate(Optional<String> optional) {
        if (this.transactionUserTemplate == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, newValue, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
        if (this.transactionCustomAttributeTemplates == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, newValue, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTransactionSlowThresholdMillis(@Nullable Long value) {
        if (this.transactionSlowThresholdMillis == value) {
            return this;
        }
        Long newValue = value;
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, newValue, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withEnabledProperty(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, newValue, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withEnabledProperty(Optional<String> optional) {
        if (this.enabledProperty == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, newValue, this.traceEntryEnabledProperty, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryEnabledProperty(String value) {
        Optional<String> newValue = Optional.of(value);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, newValue, this.version);
    }

    public final InstrumentationConfigDto withTraceEntryEnabledProperty(Optional<String> optional) {
        if (this.traceEntryEnabledProperty == optional) {
            return this;
        }
        Optional<String> newValue = Preconditions.checkNotNull(optional);
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, newValue, this.version);
    }

    public final InstrumentationConfigDto withVersion(@Nullable String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = value;
        return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof InstrumentationConfigDto && this.equalTo((InstrumentationConfigDto)another);
    }

    private boolean equalTo(InstrumentationConfigDto another) {
        return this.className.equals(another.className) && this.declaringClassName.equals(another.declaringClassName) && this.methodName.equals(another.methodName) && this.methodParameterTypes.equals(another.methodParameterTypes) && this.methodReturnType.equals(another.methodReturnType) && this.methodModifiers.equals(another.methodModifiers) && this.captureKind.equals((Object)another.captureKind) && this.timerName.equals(another.timerName) && this.traceEntryTemplate.equals(another.traceEntryTemplate) && Objects.equal(this.traceEntryStackThresholdMillis, another.traceEntryStackThresholdMillis) && this.traceEntryCaptureSelfNested.equals(another.traceEntryCaptureSelfNested) && this.transactionType.equals(another.transactionType) && this.transactionNameTemplate.equals(another.transactionNameTemplate) && this.transactionUserTemplate.equals(another.transactionUserTemplate) && this.transactionCustomAttributeTemplates.equals(another.transactionCustomAttributeTemplates) && Objects.equal(this.transactionSlowThresholdMillis, another.transactionSlowThresholdMillis) && this.enabledProperty.equals(another.enabledProperty) && this.traceEntryEnabledProperty.equals(another.traceEntryEnabledProperty) && Objects.equal(this.version, another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.className.hashCode();
        h = h * 17 + this.declaringClassName.hashCode();
        h = h * 17 + this.methodName.hashCode();
        h = h * 17 + this.methodParameterTypes.hashCode();
        h = h * 17 + this.methodReturnType.hashCode();
        h = h * 17 + this.methodModifiers.hashCode();
        h = h * 17 + this.captureKind.hashCode();
        h = h * 17 + this.timerName.hashCode();
        h = h * 17 + this.traceEntryTemplate.hashCode();
        h = h * 17 + Objects.hashCode(this.traceEntryStackThresholdMillis);
        h = h * 17 + this.traceEntryCaptureSelfNested.hashCode();
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + this.transactionNameTemplate.hashCode();
        h = h * 17 + this.transactionUserTemplate.hashCode();
        h = h * 17 + this.transactionCustomAttributeTemplates.hashCode();
        h = h * 17 + Objects.hashCode(this.transactionSlowThresholdMillis);
        h = h * 17 + this.enabledProperty.hashCode();
        h = h * 17 + this.traceEntryEnabledProperty.hashCode();
        h = h * 17 + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("InstrumentationConfigDto").add("className", this.className).add("declaringClassName", this.declaringClassName).add("methodName", this.methodName).add("methodParameterTypes", this.methodParameterTypes).add("methodReturnType", this.methodReturnType).add("methodModifiers", this.methodModifiers).add("captureKind", (Object)this.captureKind).add("timerName", this.timerName).add("traceEntryTemplate", this.traceEntryTemplate).add("traceEntryStackThresholdMillis", this.traceEntryStackThresholdMillis).add("traceEntryCaptureSelfNested", this.traceEntryCaptureSelfNested).add("transactionType", this.transactionType).add("transactionNameTemplate", this.transactionNameTemplate).add("transactionUserTemplate", this.transactionUserTemplate).add("transactionCustomAttributeTemplates", this.transactionCustomAttributeTemplates).add("transactionSlowThresholdMillis", this.transactionSlowThresholdMillis).add("enabledProperty", this.enabledProperty).add("traceEntryEnabledProperty", this.traceEntryEnabledProperty).add("version", this.version).toString();
    }

    @JsonCreator
    public static InstrumentationConfigDto fromAllAttributes(@JsonProperty(value="className") @Nullable String className, @JsonProperty(value="declaringClassName") @Nullable Optional<String> declaringClassName, @JsonProperty(value="methodName") @Nullable String methodName, @JsonProperty(value="methodParameterTypes") @Nullable ImmutableList<String> methodParameterTypes, @JsonProperty(value="methodReturnType") @Nullable Optional<String> methodReturnType, @JsonProperty(value="methodModifiers") @Nullable ImmutableList<MethodModifier> methodModifiers, @JsonProperty(value="captureKind") @Nullable CaptureKind captureKind, @JsonProperty(value="timerName") @Nullable Optional<String> timerName, @JsonProperty(value="traceEntryTemplate") @Nullable Optional<String> traceEntryTemplate, @JsonProperty(value="traceEntryStackThresholdMillis") @Nullable Long traceEntryStackThresholdMillis, @JsonProperty(value="traceEntryCaptureSelfNested") @Nullable Optional<Boolean> traceEntryCaptureSelfNested, @JsonProperty(value="transactionType") @Nullable Optional<String> transactionType, @JsonProperty(value="transactionNameTemplate") @Nullable Optional<String> transactionNameTemplate, @JsonProperty(value="transactionUserTemplate") @Nullable Optional<String> transactionUserTemplate, @JsonProperty(value="transactionCustomAttributeTemplates") @Nullable Map<String, String> transactionCustomAttributeTemplates, @JsonProperty(value="transactionSlowThresholdMillis") @Nullable Long transactionSlowThresholdMillis, @JsonProperty(value="enabledProperty") @Nullable Optional<String> enabledProperty, @JsonProperty(value="traceEntryEnabledProperty") @Nullable Optional<String> traceEntryEnabledProperty, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = InstrumentationConfigDto.builder();
        if (className != null) {
            builder.className(className);
        }
        if (declaringClassName != null) {
            builder.declaringClassName(declaringClassName);
        }
        if (methodName != null) {
            builder.methodName(methodName);
        }
        if (methodParameterTypes != null) {
            builder.addAllMethodParameterTypes(methodParameterTypes);
        }
        if (methodReturnType != null) {
            builder.methodReturnType(methodReturnType);
        }
        if (methodModifiers != null) {
            builder.addAllMethodModifiers(methodModifiers);
        }
        if (captureKind != null) {
            builder.captureKind(captureKind);
        }
        if (timerName != null) {
            builder.timerName(timerName);
        }
        if (traceEntryTemplate != null) {
            builder.traceEntryTemplate(traceEntryTemplate);
        }
        if (traceEntryStackThresholdMillis != null) {
            builder.traceEntryStackThresholdMillis(traceEntryStackThresholdMillis);
        }
        if (traceEntryCaptureSelfNested != null) {
            builder.traceEntryCaptureSelfNested(traceEntryCaptureSelfNested);
        }
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (transactionNameTemplate != null) {
            builder.transactionNameTemplate(transactionNameTemplate);
        }
        if (transactionUserTemplate != null) {
            builder.transactionUserTemplate(transactionUserTemplate);
        }
        if (transactionCustomAttributeTemplates != null) {
            builder.putAllTransactionCustomAttributeTemplates(transactionCustomAttributeTemplates);
        }
        if (transactionSlowThresholdMillis != null) {
            builder.transactionSlowThresholdMillis(transactionSlowThresholdMillis);
        }
        if (enabledProperty != null) {
            builder.enabledProperty(enabledProperty);
        }
        if (traceEntryEnabledProperty != null) {
            builder.traceEntryEnabledProperty(traceEntryEnabledProperty);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static InstrumentationConfigDto copyOf(InstrumentationJsonService.InstrumentationConfigDtoBase instance) {
        if (instance instanceof InstrumentationConfigDto) {
            return (InstrumentationConfigDto)instance;
        }
        return InstrumentationConfigDto.builder().className(instance.className()).declaringClassName(instance.declaringClassName()).methodName(instance.methodName()).addAllMethodParameterTypes(instance.methodParameterTypes()).methodReturnType(instance.methodReturnType()).addAllMethodModifiers(instance.methodModifiers()).captureKind(instance.captureKind()).timerName(instance.timerName()).traceEntryTemplate(instance.traceEntryTemplate()).traceEntryStackThresholdMillis(instance.traceEntryStackThresholdMillis()).traceEntryCaptureSelfNested(instance.traceEntryCaptureSelfNested()).transactionType(instance.transactionType()).transactionNameTemplate(instance.transactionNameTemplate()).transactionUserTemplate(instance.transactionUserTemplate()).putAllTransactionCustomAttributeTemplates(instance.transactionCustomAttributeTemplates()).transactionSlowThresholdMillis(instance.transactionSlowThresholdMillis()).enabledProperty(instance.enabledProperty()).traceEntryEnabledProperty(instance.traceEntryEnabledProperty()).version(instance.version()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_CLASS_NAME = 1L;
        private static final long INITIALIZED_BIT_METHOD_NAME = 2L;
        private static final long INITIALIZED_BIT_CAPTURE_KIND = 4L;
        private static final long NONDEFAULT_BIT_DECLARING_CLASS_NAME = 1L;
        private static final long NONDEFAULT_BIT_METHOD_RETURN_TYPE = 2L;
        private static final long NONDEFAULT_BIT_TIMER_NAME = 4L;
        private static final long NONDEFAULT_BIT_TRACE_ENTRY_TEMPLATE = 8L;
        private static final long NONDEFAULT_BIT_TRACE_ENTRY_STACK_THRESHOLD_MILLIS = 16L;
        private static final long NONDEFAULT_BIT_TRACE_ENTRY_CAPTURE_SELF_NESTED = 32L;
        private static final long NONDEFAULT_BIT_TRANSACTION_TYPE = 64L;
        private static final long NONDEFAULT_BIT_TRANSACTION_NAME_TEMPLATE = 128L;
        private static final long NONDEFAULT_BIT_TRANSACTION_USER_TEMPLATE = 256L;
        private static final long NONDEFAULT_BIT_TRANSACTION_SLOW_THRESHOLD_MILLIS = 512L;
        private static final long NONDEFAULT_BIT_ENABLED_PROPERTY = 1024L;
        private static final long NONDEFAULT_BIT_TRACE_ENTRY_ENABLED_PROPERTY = 2048L;
        private static final long NONDEFAULT_BIT_VERSION = 4096L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private String className;
        private Optional<String> declaringClassName = Optional.absent();
        @Nullable
        private String methodName;
        private ImmutableList.Builder<String> methodParameterTypesBuilder = ImmutableList.builder();
        private Optional<String> methodReturnType = Optional.absent();
        private ImmutableList.Builder<MethodModifier> methodModifiersBuilder = ImmutableList.builder();
        @Nullable
        private CaptureKind captureKind;
        private Optional<String> timerName = Optional.absent();
        private Optional<String> traceEntryTemplate = Optional.absent();
        @Nullable
        private Long traceEntryStackThresholdMillis;
        private Optional<Boolean> traceEntryCaptureSelfNested = Optional.absent();
        private Optional<String> transactionType = Optional.absent();
        private Optional<String> transactionNameTemplate = Optional.absent();
        private Optional<String> transactionUserTemplate = Optional.absent();
        private ImmutableMap.Builder<String, String> transactionCustomAttributeTemplatesBuilder = ImmutableMap.builder();
        @Nullable
        private Long transactionSlowThresholdMillis;
        private Optional<String> enabledProperty = Optional.absent();
        private Optional<String> traceEntryEnabledProperty = Optional.absent();
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder className(String className) {
            this.checkNotIsSet(this.classNameIsSet(), "className");
            this.className = Preconditions.checkNotNull(className);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder declaringClassName(String declaringClassName) {
            this.checkNotIsSet(this.declaringClassNameIsSet(), "declaringClassName");
            this.declaringClassName = Optional.of(declaringClassName);
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder declaringClassName(Optional<String> declaringClassName) {
            this.checkNotIsSet(this.declaringClassNameIsSet(), "declaringClassName");
            this.declaringClassName = Preconditions.checkNotNull(declaringClassName);
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder methodName(String methodName) {
            this.checkNotIsSet(this.methodNameIsSet(), "methodName");
            this.methodName = Preconditions.checkNotNull(methodName);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addMethodParameterTypes(String element) {
            this.methodParameterTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addMethodParameterTypes(String ... elements) {
            this.methodParameterTypesBuilder.add(elements);
            return this;
        }

        public final Builder addAllMethodParameterTypes(Iterable<String> elements) {
            this.methodParameterTypesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder methodReturnType(String methodReturnType) {
            this.checkNotIsSet(this.methodReturnTypeIsSet(), "methodReturnType");
            this.methodReturnType = Optional.of(methodReturnType);
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder methodReturnType(Optional<String> methodReturnType) {
            this.checkNotIsSet(this.methodReturnTypeIsSet(), "methodReturnType");
            this.methodReturnType = Preconditions.checkNotNull(methodReturnType);
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder addMethodModifiers(MethodModifier element) {
            this.methodModifiersBuilder.add((Object)element);
            return this;
        }

        public final Builder addMethodModifiers(MethodModifier ... elements) {
            this.methodModifiersBuilder.add((Object[])elements);
            return this;
        }

        public final Builder addAllMethodModifiers(Iterable<? extends MethodModifier> elements) {
            this.methodModifiersBuilder.addAll(elements);
            return this;
        }

        public final Builder captureKind(CaptureKind captureKind) {
            this.checkNotIsSet(this.captureKindIsSet(), "captureKind");
            this.captureKind = Preconditions.checkNotNull(captureKind);
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder timerName(String timerName) {
            this.checkNotIsSet(this.timerNameIsSet(), "timerName");
            this.timerName = Optional.of(timerName);
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder timerName(Optional<String> timerName) {
            this.checkNotIsSet(this.timerNameIsSet(), "timerName");
            this.timerName = Preconditions.checkNotNull(timerName);
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder traceEntryTemplate(String traceEntryTemplate) {
            this.checkNotIsSet(this.traceEntryTemplateIsSet(), "traceEntryTemplate");
            this.traceEntryTemplate = Optional.of(traceEntryTemplate);
            this.nondefaultBitset |= 8L;
            return this;
        }

        public final Builder traceEntryTemplate(Optional<String> traceEntryTemplate) {
            this.checkNotIsSet(this.traceEntryTemplateIsSet(), "traceEntryTemplate");
            this.traceEntryTemplate = Preconditions.checkNotNull(traceEntryTemplate);
            this.nondefaultBitset |= 8L;
            return this;
        }

        public final Builder traceEntryStackThresholdMillis(@Nullable Long traceEntryStackThresholdMillis) {
            this.checkNotIsSet(this.traceEntryStackThresholdMillisIsSet(), "traceEntryStackThresholdMillis");
            this.traceEntryStackThresholdMillis = traceEntryStackThresholdMillis;
            this.nondefaultBitset |= 0x10L;
            return this;
        }

        public final Builder traceEntryCaptureSelfNested(boolean traceEntryCaptureSelfNested) {
            this.checkNotIsSet(this.traceEntryCaptureSelfNestedIsSet(), "traceEntryCaptureSelfNested");
            this.traceEntryCaptureSelfNested = Optional.of(traceEntryCaptureSelfNested);
            this.nondefaultBitset |= 0x20L;
            return this;
        }

        public final Builder traceEntryCaptureSelfNested(Optional<Boolean> traceEntryCaptureSelfNested) {
            this.checkNotIsSet(this.traceEntryCaptureSelfNestedIsSet(), "traceEntryCaptureSelfNested");
            this.traceEntryCaptureSelfNested = Preconditions.checkNotNull(traceEntryCaptureSelfNested);
            this.nondefaultBitset |= 0x20L;
            return this;
        }

        public final Builder transactionType(String transactionType) {
            this.checkNotIsSet(this.transactionTypeIsSet(), "transactionType");
            this.transactionType = Optional.of(transactionType);
            this.nondefaultBitset |= 0x40L;
            return this;
        }

        public final Builder transactionType(Optional<String> transactionType) {
            this.checkNotIsSet(this.transactionTypeIsSet(), "transactionType");
            this.transactionType = Preconditions.checkNotNull(transactionType);
            this.nondefaultBitset |= 0x40L;
            return this;
        }

        public final Builder transactionNameTemplate(String transactionNameTemplate) {
            this.checkNotIsSet(this.transactionNameTemplateIsSet(), "transactionNameTemplate");
            this.transactionNameTemplate = Optional.of(transactionNameTemplate);
            this.nondefaultBitset |= 0x80L;
            return this;
        }

        public final Builder transactionNameTemplate(Optional<String> transactionNameTemplate) {
            this.checkNotIsSet(this.transactionNameTemplateIsSet(), "transactionNameTemplate");
            this.transactionNameTemplate = Preconditions.checkNotNull(transactionNameTemplate);
            this.nondefaultBitset |= 0x80L;
            return this;
        }

        public final Builder transactionUserTemplate(String transactionUserTemplate) {
            this.checkNotIsSet(this.transactionUserTemplateIsSet(), "transactionUserTemplate");
            this.transactionUserTemplate = Optional.of(transactionUserTemplate);
            this.nondefaultBitset |= 0x100L;
            return this;
        }

        public final Builder transactionUserTemplate(Optional<String> transactionUserTemplate) {
            this.checkNotIsSet(this.transactionUserTemplateIsSet(), "transactionUserTemplate");
            this.transactionUserTemplate = Preconditions.checkNotNull(transactionUserTemplate);
            this.nondefaultBitset |= 0x100L;
            return this;
        }

        public final Builder putTransactionCustomAttributeTemplates(String key, String value) {
            this.transactionCustomAttributeTemplatesBuilder.put(key, value);
            return this;
        }

        public final Builder putTransactionCustomAttributeTemplates(Map.Entry<String, ? extends String> entry) {
            this.transactionCustomAttributeTemplatesBuilder.put(entry);
            return this;
        }

        public final Builder putAllTransactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
            this.transactionCustomAttributeTemplatesBuilder.putAll(entries);
            return this;
        }

        public final Builder transactionSlowThresholdMillis(@Nullable Long transactionSlowThresholdMillis) {
            this.checkNotIsSet(this.transactionSlowThresholdMillisIsSet(), "transactionSlowThresholdMillis");
            this.transactionSlowThresholdMillis = transactionSlowThresholdMillis;
            this.nondefaultBitset |= 0x200L;
            return this;
        }

        public final Builder enabledProperty(String enabledProperty) {
            this.checkNotIsSet(this.enabledPropertyIsSet(), "enabledProperty");
            this.enabledProperty = Optional.of(enabledProperty);
            this.nondefaultBitset |= 0x400L;
            return this;
        }

        public final Builder enabledProperty(Optional<String> enabledProperty) {
            this.checkNotIsSet(this.enabledPropertyIsSet(), "enabledProperty");
            this.enabledProperty = Preconditions.checkNotNull(enabledProperty);
            this.nondefaultBitset |= 0x400L;
            return this;
        }

        public final Builder traceEntryEnabledProperty(String traceEntryEnabledProperty) {
            this.checkNotIsSet(this.traceEntryEnabledPropertyIsSet(), "traceEntryEnabledProperty");
            this.traceEntryEnabledProperty = Optional.of(traceEntryEnabledProperty);
            this.nondefaultBitset |= 0x800L;
            return this;
        }

        public final Builder traceEntryEnabledProperty(Optional<String> traceEntryEnabledProperty) {
            this.checkNotIsSet(this.traceEntryEnabledPropertyIsSet(), "traceEntryEnabledProperty");
            this.traceEntryEnabledProperty = Preconditions.checkNotNull(traceEntryEnabledProperty);
            this.nondefaultBitset |= 0x800L;
            return this;
        }

        public final Builder version(@Nullable String version) {
            this.checkNotIsSet(this.versionIsSet(), "version");
            this.version = version;
            this.nondefaultBitset |= 0x1000L;
            return this;
        }

        public InstrumentationConfigDto build() {
            this.checkRequiredAttributes();
            return new InstrumentationConfigDto(this.className, this.declaringClassName, this.methodName, (ImmutableList)this.methodParameterTypesBuilder.build(), this.methodReturnType, (ImmutableList)this.methodModifiersBuilder.build(), this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplatesBuilder.build(), this.transactionSlowThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty, this.version);
        }

        private boolean declaringClassNameIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean methodReturnTypeIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean timerNameIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean traceEntryTemplateIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }

        private boolean traceEntryStackThresholdMillisIsSet() {
            return (this.nondefaultBitset & 0x10L) != 0L;
        }

        private boolean traceEntryCaptureSelfNestedIsSet() {
            return (this.nondefaultBitset & 0x20L) != 0L;
        }

        private boolean transactionTypeIsSet() {
            return (this.nondefaultBitset & 0x40L) != 0L;
        }

        private boolean transactionNameTemplateIsSet() {
            return (this.nondefaultBitset & 0x80L) != 0L;
        }

        private boolean transactionUserTemplateIsSet() {
            return (this.nondefaultBitset & 0x100L) != 0L;
        }

        private boolean transactionSlowThresholdMillisIsSet() {
            return (this.nondefaultBitset & 0x200L) != 0L;
        }

        private boolean enabledPropertyIsSet() {
            return (this.nondefaultBitset & 0x400L) != 0L;
        }

        private boolean traceEntryEnabledPropertyIsSet() {
            return (this.nondefaultBitset & 0x800L) != 0L;
        }

        private boolean versionIsSet() {
            return (this.nondefaultBitset & 0x1000L) != 0L;
        }

        private boolean classNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean methodNameIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean captureKindIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of InstrumentationConfigDto is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.classNameIsSet()) {
                attributes.add("className");
            }
            if (!this.methodNameIsSet()) {
                attributes.add("methodName");
            }
            if (!this.captureKindIsSet()) {
                attributes.add("captureKind");
            }
            return "Cannot build InstrumentationConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

