/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.AnonymousAccess;
import org.glowroot.config.RollupConfig;
import org.glowroot.local.ui.LayoutBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Doubles;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
final class Layout
extends LayoutBase {
    private final boolean jvmHeapDump;
    private final String footerMessage;
    private final boolean adminPasswordEnabled;
    private final boolean readOnlyPasswordEnabled;
    private final AnonymousAccess anonymousAccess;
    private final ImmutableList<String> transactionTypes;
    private final String defaultTransactionType;
    private final ImmutableList<Double> defaultPercentiles;
    private final ImmutableList<String> transactionCustomAttributes;
    private final ImmutableList<RollupConfig> rollupConfigs;
    private final ImmutableList<Long> rollupExpirationMillis;
    private final long gaugeCollectionIntervalMillis;
    private final String version;

    private Layout(boolean jvmHeapDump, String footerMessage, boolean adminPasswordEnabled, boolean readOnlyPasswordEnabled, AnonymousAccess anonymousAccess, ImmutableList<String> transactionTypes, String defaultTransactionType, ImmutableList<Double> defaultPercentiles, ImmutableList<String> transactionCustomAttributes, ImmutableList<RollupConfig> rollupConfigs, ImmutableList<Long> rollupExpirationMillis, long gaugeCollectionIntervalMillis) {
        this.jvmHeapDump = jvmHeapDump;
        this.footerMessage = footerMessage;
        this.adminPasswordEnabled = adminPasswordEnabled;
        this.readOnlyPasswordEnabled = readOnlyPasswordEnabled;
        this.anonymousAccess = anonymousAccess;
        this.transactionTypes = transactionTypes;
        this.defaultTransactionType = defaultTransactionType;
        this.defaultPercentiles = defaultPercentiles;
        this.transactionCustomAttributes = transactionCustomAttributes;
        this.rollupConfigs = rollupConfigs;
        this.rollupExpirationMillis = rollupExpirationMillis;
        this.gaugeCollectionIntervalMillis = gaugeCollectionIntervalMillis;
        this.version = Preconditions.checkNotNull(super.version());
    }

    @Override
    @JsonProperty(value="jvmHeapDump")
    public boolean jvmHeapDump() {
        return this.jvmHeapDump;
    }

    @Override
    @JsonProperty(value="footerMessage")
    public String footerMessage() {
        return this.footerMessage;
    }

    @Override
    @JsonProperty(value="adminPasswordEnabled")
    public boolean adminPasswordEnabled() {
        return this.adminPasswordEnabled;
    }

    @Override
    @JsonProperty(value="readOnlyPasswordEnabled")
    public boolean readOnlyPasswordEnabled() {
        return this.readOnlyPasswordEnabled;
    }

    @Override
    @JsonProperty(value="anonymousAccess")
    public AnonymousAccess anonymousAccess() {
        return this.anonymousAccess;
    }

    @Override
    @JsonProperty(value="transactionTypes")
    public ImmutableList<String> transactionTypes() {
        return this.transactionTypes;
    }

    @Override
    @JsonProperty(value="defaultTransactionType")
    public String defaultTransactionType() {
        return this.defaultTransactionType;
    }

    @Override
    @JsonProperty(value="defaultPercentiles")
    public ImmutableList<Double> defaultPercentiles() {
        return this.defaultPercentiles;
    }

    @Override
    @JsonProperty(value="transactionCustomAttributes")
    public ImmutableList<String> transactionCustomAttributes() {
        return this.transactionCustomAttributes;
    }

    @Override
    @JsonProperty(value="rollupConfigs")
    public ImmutableList<RollupConfig> rollupConfigs() {
        return this.rollupConfigs;
    }

    @Override
    @JsonProperty(value="rollupExpirationMillis")
    public ImmutableList<Long> rollupExpirationMillis() {
        return this.rollupExpirationMillis;
    }

    @Override
    @JsonProperty(value="gaugeCollectionIntervalMillis")
    public long gaugeCollectionIntervalMillis() {
        return this.gaugeCollectionIntervalMillis;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final Layout withJvmHeapDump(boolean value) {
        if (this.jvmHeapDump == value) {
            return this;
        }
        boolean newValue = value;
        return new Layout(newValue, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.defaultPercentiles, this.transactionCustomAttributes, this.rollupConfigs, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withFooterMessage(String value) {
        if (this.footerMessage == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Layout(this.jvmHeapDump, newValue, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.defaultPercentiles, this.transactionCustomAttributes, this.rollupConfigs, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withAdminPasswordEnabled(boolean value) {
        if (this.adminPasswordEnabled == value) {
            return this;
        }
        boolean newValue = value;
        return new Layout(this.jvmHeapDump, this.footerMessage, newValue, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.defaultPercentiles, this.transactionCustomAttributes, this.rollupConfigs, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withReadOnlyPasswordEnabled(boolean value) {
        if (this.readOnlyPasswordEnabled == value) {
            return this;
        }
        boolean newValue = value;
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, newValue, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.defaultPercentiles, this.transactionCustomAttributes, this.rollupConfigs, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withAnonymousAccess(AnonymousAccess value) {
        if (this.anonymousAccess == value) {
            return this;
        }
        AnonymousAccess newValue = Preconditions.checkNotNull(value);
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, newValue, this.transactionTypes, this.defaultTransactionType, this.defaultPercentiles, this.transactionCustomAttributes, this.rollupConfigs, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withTransactionTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, newValue, this.defaultTransactionType, this.defaultPercentiles, this.transactionCustomAttributes, this.rollupConfigs, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withTransactionTypes(Iterable<String> elements) {
        if (this.transactionTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, newValue, this.defaultTransactionType, this.defaultPercentiles, this.transactionCustomAttributes, this.rollupConfigs, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withDefaultTransactionType(String value) {
        if (this.defaultTransactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, newValue, this.defaultPercentiles, this.transactionCustomAttributes, this.rollupConfigs, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withDefaultPercentiles(double ... elements) {
        ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, newValue, this.transactionCustomAttributes, this.rollupConfigs, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withDefaultPercentiles(Iterable<Double> elements) {
        if (this.defaultPercentiles == elements) {
            return this;
        }
        ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, newValue, this.transactionCustomAttributes, this.rollupConfigs, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withTransactionCustomAttributes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.defaultPercentiles, newValue, this.rollupConfigs, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withTransactionCustomAttributes(Iterable<String> elements) {
        if (this.transactionCustomAttributes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.defaultPercentiles, newValue, this.rollupConfigs, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withRollupConfigs(RollupConfig ... elements) {
        ImmutableList<RollupConfig> newValue = ImmutableList.copyOf(elements);
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.defaultPercentiles, this.transactionCustomAttributes, newValue, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withRollupConfigs(Iterable<? extends RollupConfig> elements) {
        if (this.rollupConfigs == elements) {
            return this;
        }
        ImmutableList<RollupConfig> newValue = ImmutableList.copyOf(elements);
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.defaultPercentiles, this.transactionCustomAttributes, newValue, this.rollupExpirationMillis, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withRollupExpirationMillis(long ... elements) {
        ImmutableList<Long> newValue = ImmutableList.copyOf(Longs.asList(elements));
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.defaultPercentiles, this.transactionCustomAttributes, this.rollupConfigs, newValue, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withRollupExpirationMillis(Iterable<Long> elements) {
        if (this.rollupExpirationMillis == elements) {
            return this;
        }
        ImmutableList<Long> newValue = ImmutableList.copyOf(elements);
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.defaultPercentiles, this.transactionCustomAttributes, this.rollupConfigs, newValue, this.gaugeCollectionIntervalMillis);
    }

    public final Layout withGaugeCollectionIntervalMillis(long value) {
        if (this.gaugeCollectionIntervalMillis == value) {
            return this;
        }
        long newValue = value;
        return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.defaultPercentiles, this.transactionCustomAttributes, this.rollupConfigs, this.rollupExpirationMillis, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof Layout && this.equalTo((Layout)another);
    }

    private boolean equalTo(Layout another) {
        return this.jvmHeapDump == another.jvmHeapDump && this.footerMessage.equals(another.footerMessage) && this.adminPasswordEnabled == another.adminPasswordEnabled && this.readOnlyPasswordEnabled == another.readOnlyPasswordEnabled && this.anonymousAccess.equals((Object)another.anonymousAccess) && this.transactionTypes.equals(another.transactionTypes) && this.defaultTransactionType.equals(another.defaultTransactionType) && this.defaultPercentiles.equals(another.defaultPercentiles) && this.transactionCustomAttributes.equals(another.transactionCustomAttributes) && this.rollupConfigs.equals(another.rollupConfigs) && this.rollupExpirationMillis.equals(another.rollupExpirationMillis) && this.gaugeCollectionIntervalMillis == another.gaugeCollectionIntervalMillis && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode(this.jvmHeapDump);
        h = h * 17 + this.footerMessage.hashCode();
        h = h * 17 + Booleans.hashCode(this.adminPasswordEnabled);
        h = h * 17 + Booleans.hashCode(this.readOnlyPasswordEnabled);
        h = h * 17 + this.anonymousAccess.hashCode();
        h = h * 17 + this.transactionTypes.hashCode();
        h = h * 17 + this.defaultTransactionType.hashCode();
        h = h * 17 + this.defaultPercentiles.hashCode();
        h = h * 17 + this.transactionCustomAttributes.hashCode();
        h = h * 17 + this.rollupConfigs.hashCode();
        h = h * 17 + this.rollupExpirationMillis.hashCode();
        h = h * 17 + Longs.hashCode(this.gaugeCollectionIntervalMillis);
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Layout").add("jvmHeapDump", this.jvmHeapDump).add("footerMessage", this.footerMessage).add("adminPasswordEnabled", this.adminPasswordEnabled).add("readOnlyPasswordEnabled", this.readOnlyPasswordEnabled).add("anonymousAccess", (Object)this.anonymousAccess).add("transactionTypes", this.transactionTypes).add("defaultTransactionType", this.defaultTransactionType).add("defaultPercentiles", this.defaultPercentiles).add("transactionCustomAttributes", this.transactionCustomAttributes).add("rollupConfigs", this.rollupConfigs).add("rollupExpirationMillis", this.rollupExpirationMillis).add("gaugeCollectionIntervalMillis", this.gaugeCollectionIntervalMillis).add("version", this.version).toString();
    }

    @JsonCreator
    public static Layout fromAllAttributes(@JsonProperty(value="jvmHeapDump") @Nullable Boolean jvmHeapDump, @JsonProperty(value="footerMessage") @Nullable String footerMessage, @JsonProperty(value="adminPasswordEnabled") @Nullable Boolean adminPasswordEnabled, @JsonProperty(value="readOnlyPasswordEnabled") @Nullable Boolean readOnlyPasswordEnabled, @JsonProperty(value="anonymousAccess") @Nullable AnonymousAccess anonymousAccess, @JsonProperty(value="transactionTypes") @Nullable ImmutableList<String> transactionTypes, @JsonProperty(value="defaultTransactionType") @Nullable String defaultTransactionType, @JsonProperty(value="defaultPercentiles") @Nullable ImmutableList<Double> defaultPercentiles, @JsonProperty(value="transactionCustomAttributes") @Nullable ImmutableList<String> transactionCustomAttributes, @JsonProperty(value="rollupConfigs") @Nullable ImmutableList<RollupConfig> rollupConfigs, @JsonProperty(value="rollupExpirationMillis") @Nullable ImmutableList<Long> rollupExpirationMillis, @JsonProperty(value="gaugeCollectionIntervalMillis") @Nullable Long gaugeCollectionIntervalMillis) {
        Builder builder = Layout.builder();
        if (jvmHeapDump != null) {
            builder.jvmHeapDump(jvmHeapDump);
        }
        if (footerMessage != null) {
            builder.footerMessage(footerMessage);
        }
        if (adminPasswordEnabled != null) {
            builder.adminPasswordEnabled(adminPasswordEnabled);
        }
        if (readOnlyPasswordEnabled != null) {
            builder.readOnlyPasswordEnabled(readOnlyPasswordEnabled);
        }
        if (anonymousAccess != null) {
            builder.anonymousAccess(anonymousAccess);
        }
        if (transactionTypes != null) {
            builder.addAllTransactionTypes(transactionTypes);
        }
        if (defaultTransactionType != null) {
            builder.defaultTransactionType(defaultTransactionType);
        }
        if (defaultPercentiles != null) {
            builder.addAllDefaultPercentiles(defaultPercentiles);
        }
        if (transactionCustomAttributes != null) {
            builder.addAllTransactionCustomAttributes(transactionCustomAttributes);
        }
        if (rollupConfigs != null) {
            builder.addAllRollupConfigs(rollupConfigs);
        }
        if (rollupExpirationMillis != null) {
            builder.addAllRollupExpirationMillis(rollupExpirationMillis);
        }
        if (gaugeCollectionIntervalMillis != null) {
            builder.gaugeCollectionIntervalMillis(gaugeCollectionIntervalMillis);
        }
        return builder.build();
    }

    static Layout copyOf(LayoutBase instance) {
        if (instance instanceof Layout) {
            return (Layout)instance;
        }
        return Layout.builder().jvmHeapDump(instance.jvmHeapDump()).footerMessage(instance.footerMessage()).adminPasswordEnabled(instance.adminPasswordEnabled()).readOnlyPasswordEnabled(instance.readOnlyPasswordEnabled()).anonymousAccess(instance.anonymousAccess()).addAllTransactionTypes(instance.transactionTypes()).defaultTransactionType(instance.defaultTransactionType()).addAllDefaultPercentiles(instance.defaultPercentiles()).addAllTransactionCustomAttributes(instance.transactionCustomAttributes()).addAllRollupConfigs(instance.rollupConfigs()).addAllRollupExpirationMillis(instance.rollupExpirationMillis()).gaugeCollectionIntervalMillis(instance.gaugeCollectionIntervalMillis()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 127L;
        private static final long INITIALIZED_BIT_JVM_HEAP_DUMP = 1L;
        private static final long INITIALIZED_BIT_FOOTER_MESSAGE = 2L;
        private static final long INITIALIZED_BIT_ADMIN_PASSWORD_ENABLED = 4L;
        private static final long INITIALIZED_BIT_READ_ONLY_PASSWORD_ENABLED = 8L;
        private static final long INITIALIZED_BIT_ANONYMOUS_ACCESS = 16L;
        private static final long INITIALIZED_BIT_DEFAULT_TRANSACTION_TYPE = 32L;
        private static final long INITIALIZED_BIT_GAUGE_COLLECTION_INTERVAL_MILLIS = 64L;
        private long initializedBitset;
        private boolean jvmHeapDump;
        @Nullable
        private String footerMessage;
        private boolean adminPasswordEnabled;
        private boolean readOnlyPasswordEnabled;
        @Nullable
        private AnonymousAccess anonymousAccess;
        private ImmutableList.Builder<String> transactionTypesBuilder = ImmutableList.builder();
        @Nullable
        private String defaultTransactionType;
        private ImmutableList.Builder<Double> defaultPercentilesBuilder = ImmutableList.builder();
        private ImmutableList.Builder<String> transactionCustomAttributesBuilder = ImmutableList.builder();
        private ImmutableList.Builder<RollupConfig> rollupConfigsBuilder = ImmutableList.builder();
        private ImmutableList.Builder<Long> rollupExpirationMillisBuilder = ImmutableList.builder();
        private long gaugeCollectionIntervalMillis;

        private Builder() {
        }

        public final Builder jvmHeapDump(boolean jvmHeapDump) {
            this.checkNotIsSet(this.jvmHeapDumpIsSet(), "jvmHeapDump");
            this.jvmHeapDump = jvmHeapDump;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder footerMessage(String footerMessage) {
            this.checkNotIsSet(this.footerMessageIsSet(), "footerMessage");
            this.footerMessage = Preconditions.checkNotNull(footerMessage);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder adminPasswordEnabled(boolean adminPasswordEnabled) {
            this.checkNotIsSet(this.adminPasswordEnabledIsSet(), "adminPasswordEnabled");
            this.adminPasswordEnabled = adminPasswordEnabled;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder readOnlyPasswordEnabled(boolean readOnlyPasswordEnabled) {
            this.checkNotIsSet(this.readOnlyPasswordEnabledIsSet(), "readOnlyPasswordEnabled");
            this.readOnlyPasswordEnabled = readOnlyPasswordEnabled;
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder anonymousAccess(AnonymousAccess anonymousAccess) {
            this.checkNotIsSet(this.anonymousAccessIsSet(), "anonymousAccess");
            this.anonymousAccess = Preconditions.checkNotNull(anonymousAccess);
            this.initializedBitset |= 0x10L;
            return this;
        }

        public final Builder addTransactionTypes(String element) {
            this.transactionTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addTransactionTypes(String ... elements) {
            this.transactionTypesBuilder.add(elements);
            return this;
        }

        public final Builder addAllTransactionTypes(Iterable<String> elements) {
            this.transactionTypesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder defaultTransactionType(String defaultTransactionType) {
            this.checkNotIsSet(this.defaultTransactionTypeIsSet(), "defaultTransactionType");
            this.defaultTransactionType = Preconditions.checkNotNull(defaultTransactionType);
            this.initializedBitset |= 0x20L;
            return this;
        }

        public final Builder addDefaultPercentiles(double element) {
            this.defaultPercentilesBuilder.add((Object)element);
            return this;
        }

        public final Builder addDefaultPercentiles(double ... elements) {
            this.defaultPercentilesBuilder.addAll(Doubles.asList(elements));
            return this;
        }

        public final Builder addAllDefaultPercentiles(Iterable<Double> elements) {
            this.defaultPercentilesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder addTransactionCustomAttributes(String element) {
            this.transactionCustomAttributesBuilder.add((Object)element);
            return this;
        }

        public final Builder addTransactionCustomAttributes(String ... elements) {
            this.transactionCustomAttributesBuilder.add(elements);
            return this;
        }

        public final Builder addAllTransactionCustomAttributes(Iterable<String> elements) {
            this.transactionCustomAttributesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder addRollupConfigs(RollupConfig element) {
            this.rollupConfigsBuilder.add((Object)element);
            return this;
        }

        public final Builder addRollupConfigs(RollupConfig ... elements) {
            this.rollupConfigsBuilder.add(elements);
            return this;
        }

        public final Builder addAllRollupConfigs(Iterable<? extends RollupConfig> elements) {
            this.rollupConfigsBuilder.addAll(elements);
            return this;
        }

        public final Builder addRollupExpirationMillis(long element) {
            this.rollupExpirationMillisBuilder.add((Object)element);
            return this;
        }

        public final Builder addRollupExpirationMillis(long ... elements) {
            this.rollupExpirationMillisBuilder.addAll(Longs.asList(elements));
            return this;
        }

        public final Builder addAllRollupExpirationMillis(Iterable<Long> elements) {
            this.rollupExpirationMillisBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder gaugeCollectionIntervalMillis(long gaugeCollectionIntervalMillis) {
            this.checkNotIsSet(this.gaugeCollectionIntervalMillisIsSet(), "gaugeCollectionIntervalMillis");
            this.gaugeCollectionIntervalMillis = gaugeCollectionIntervalMillis;
            this.initializedBitset |= 0x40L;
            return this;
        }

        public Layout build() {
            this.checkRequiredAttributes();
            return new Layout(this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, (ImmutableList)this.transactionTypesBuilder.build(), this.defaultTransactionType, (ImmutableList)this.defaultPercentilesBuilder.build(), (ImmutableList)this.transactionCustomAttributesBuilder.build(), (ImmutableList)this.rollupConfigsBuilder.build(), (ImmutableList)this.rollupExpirationMillisBuilder.build(), this.gaugeCollectionIntervalMillis);
        }

        private boolean jvmHeapDumpIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean footerMessageIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean adminPasswordEnabledIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean readOnlyPasswordEnabledIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean anonymousAccessIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private boolean defaultTransactionTypeIsSet() {
            return (this.initializedBitset & 0x20L) != 0L;
        }

        private boolean gaugeCollectionIntervalMillisIsSet() {
            return (this.initializedBitset & 0x40L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Layout is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 127L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.jvmHeapDumpIsSet()) {
                attributes.add("jvmHeapDump");
            }
            if (!this.footerMessageIsSet()) {
                attributes.add("footerMessage");
            }
            if (!this.adminPasswordEnabledIsSet()) {
                attributes.add("adminPasswordEnabled");
            }
            if (!this.readOnlyPasswordEnabledIsSet()) {
                attributes.add("readOnlyPasswordEnabled");
            }
            if (!this.anonymousAccessIsSet()) {
                attributes.add("anonymousAccess");
            }
            if (!this.defaultTransactionTypeIsSet()) {
                attributes.add("defaultTransactionType");
            }
            if (!this.gaugeCollectionIntervalMillisIsSet()) {
                attributes.add("gaugeCollectionIntervalMillis");
            }
            return "Cannot build Layout, some of required attributes are not set " + attributes;
        }
    }
}

