/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.common.ObjectMappers;
import org.glowroot.config.ConfigService;
import org.glowroot.config.PluginDescriptor;
import org.glowroot.config.UserInterfaceConfig;
import org.glowroot.jvm.HeapDumps;
import org.glowroot.jvm.OptionalService;
import org.glowroot.local.ui.Layout;
import org.glowroot.plugin.api.config.ConfigListener;
import org.glowroot.shaded.fasterxml.jackson.core.JsonFactory;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.google.common.io.CharStreams;

class LayoutService {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final ObjectMapper mapper = ObjectMappers.create();
    private final String version;
    private final ConfigService configService;
    private final ImmutableList<PluginDescriptor> pluginDescriptors;
    private final OptionalService<HeapDumps> heapDumps;
    private final long gaugeCollectionIntervalMillis;
    @Nullable
    private volatile Layout layout;

    LayoutService(String version, ConfigService configService, List<PluginDescriptor> pluginDescriptors, OptionalService<HeapDumps> heapDumps, long gaugeCollectionIntervalMillis) {
        this.version = version;
        this.configService = configService;
        this.pluginDescriptors = ImmutableList.copyOf(pluginDescriptors);
        this.heapDumps = heapDumps;
        this.gaugeCollectionIntervalMillis = gaugeCollectionIntervalMillis;
        ConfigListener listener = new ConfigListener(){

            @Override
            public void onChange() {
                LayoutService.this.layout = null;
            }
        };
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            configService.addPluginConfigListener(pluginDescriptor.id(), listener);
        }
        configService.addConfigListener(listener);
    }

    String getLayout() throws IOException {
        Layout localLayout = this.layout;
        if (localLayout == null) {
            this.layout = localLayout = LayoutService.buildLayout(this.version, this.configService, this.pluginDescriptors, this.heapDumps.getService(), this.gaugeCollectionIntervalMillis);
        }
        return mapper.writeValueAsString(localLayout);
    }

    String getLayoutVersion() {
        Layout localLayout = this.layout;
        if (localLayout == null) {
            this.layout = localLayout = LayoutService.buildLayout(this.version, this.configService, this.pluginDescriptors, this.heapDumps.getService(), this.gaugeCollectionIntervalMillis);
        }
        return localLayout.version();
    }

    String getNeedsAuthenticationLayout() throws IOException {
        UserInterfaceConfig userInterfaceConfig = this.configService.getUserInterfaceConfig();
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeBooleanField("needsAuthentication", true);
        jg.writeBooleanField("readOnlyPasswordEnabled", userInterfaceConfig.readOnlyPasswordEnabled());
        jg.writeStringField("footerMessage", "Glowroot version " + this.version);
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    private static Layout buildLayout(String version, ConfigService configService, List<PluginDescriptor> pluginDescriptors, @Nullable HeapDumps heapDumps, long gaugeCollectionIntervalMillis) {
        ArrayList<String> transactionTypes = Lists.newArrayList(configService.getAllTransactionTypes());
        String defaultDisplayedTransactionType = configService.getDefaultDisplayedTransactionType();
        ArrayList<String> orderedTransactionTypes = Lists.newArrayList();
        if (transactionTypes.isEmpty()) {
            defaultDisplayedTransactionType = "NO TRANSACTION TYPES DEFINED";
        } else {
            if (!transactionTypes.contains(defaultDisplayedTransactionType)) {
                defaultDisplayedTransactionType = (String)transactionTypes.iterator().next();
            }
            transactionTypes.remove(defaultDisplayedTransactionType);
        }
        orderedTransactionTypes.add(defaultDisplayedTransactionType);
        orderedTransactionTypes.addAll(Ordering.from(String.CASE_INSENSITIVE_ORDER).sortedCopy(transactionTypes));
        TreeSet<String> transactionCustomAttributes = Sets.newTreeSet();
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            transactionCustomAttributes.addAll(pluginDescriptor.transactionCustomAttributes());
        }
        ArrayList<Long> rollupExpirationMillis = Lists.newArrayList();
        Iterator iterator = configService.getStorageConfig().rollupExpirationHours().iterator();
        while (iterator.hasNext()) {
            long hours = ((Integer)iterator.next()).intValue();
            rollupExpirationMillis.add(TimeUnit.HOURS.toMillis(hours));
        }
        UserInterfaceConfig userInterfaceConfig = configService.getUserInterfaceConfig();
        return Layout.builder().jvmHeapDump(heapDumps != null).footerMessage("Glowroot version " + version).adminPasswordEnabled(userInterfaceConfig.adminPasswordEnabled()).readOnlyPasswordEnabled(userInterfaceConfig.readOnlyPasswordEnabled()).anonymousAccess(userInterfaceConfig.anonymousAccess()).addAllTransactionTypes(orderedTransactionTypes).defaultTransactionType(defaultDisplayedTransactionType).addAllDefaultPercentiles(configService.getTransactionConfig().defaultDisplayedPercentiles()).addAllTransactionCustomAttributes(transactionCustomAttributes).addAllRollupConfigs(configService.getRollupConfigs()).addAllRollupExpirationMillis(rollupExpirationMillis).gaugeCollectionIntervalMillis(gaugeCollectionIntervalMillis).build();
    }
}

