/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.local.ui.GlowrootLogHttpService;
import org.glowroot.local.ui.HttpServer;
import org.glowroot.local.ui.HttpService;
import org.glowroot.local.ui.HttpSessionManager;
import org.glowroot.local.ui.IndexHtmlHttpService;
import org.glowroot.local.ui.LayoutHttpService;
import org.glowroot.local.ui.LayoutService;
import org.glowroot.local.ui.TraceDetailHttpService;
import org.glowroot.local.ui.TraceExportHttpService;
import org.glowroot.shaded.google.common.base.Stopwatch;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class LazyHttpServer {
    private static final Logger logger = LoggerFactory.getLogger(LazyHttpServer.class);
    private static final Logger startupLogger = LoggerFactory.getLogger("org.glowroot");
    private static final int NUM_WORKER_THREADS = Integer.getInteger("glowroot.internal.ui.workerThreads", 2);
    private final String bindAddress;
    private final int port;
    private final HttpSessionManager httpSessionManager;
    private final IndexHtmlHttpService indexHtmlHttpService;
    private final LayoutHttpService layoutHttpService;
    private final LayoutService layoutService;
    private final TraceDetailHttpService traceDetailHttpService;
    private final TraceExportHttpService traceExportHttpService;
    private final GlowrootLogHttpService glowrootLogHttpService;
    private final List<Object> jsonServices;
    private volatile boolean initialized;
    @Nullable
    private volatile HttpServer httpServer;

    LazyHttpServer(String bindAddress, int port, HttpSessionManager httpSessionManager, IndexHtmlHttpService indexHtmlHttpService, LayoutHttpService layoutHttpService, LayoutService layoutService, TraceDetailHttpService traceDetailHttpService, TraceExportHttpService traceExportHttpService, GlowrootLogHttpService glowrootLogHttpService, List<Object> jsonServices) {
        this.bindAddress = bindAddress;
        this.port = port;
        this.httpSessionManager = httpSessionManager;
        this.indexHtmlHttpService = indexHtmlHttpService;
        this.layoutHttpService = layoutHttpService;
        this.layoutService = layoutService;
        this.traceDetailHttpService = traceDetailHttpService;
        this.traceExportHttpService = traceExportHttpService;
        this.glowrootLogHttpService = glowrootLogHttpService;
        this.jsonServices = jsonServices;
    }

    void init(final Instrumentation instrumentation, final ConfigJsonService configJsonService) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    LazyHttpServer.waitForMain(instrumentation);
                    LazyHttpServer.this.initNonLazy(configJsonService);
                    int port = LazyHttpServer.this.httpServer != null ? LazyHttpServer.this.httpServer.getPort() : -1;
                    startupLogger.info("Glowroot listening at http://localhost:{}", (Object)port);
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
            }
        });
    }

    void initNonLazy(ConfigJsonService configJsonService) throws InterruptedException {
        HttpServer httpServer = this.build();
        this.initialized = true;
        if (httpServer != null) {
            this.httpServer = httpServer;
            configJsonService.setHttpServer(httpServer);
        }
    }

    @Nullable
    HttpServer get() throws InterruptedException {
        for (int i = 0; i < 5000; ++i) {
            if (this.initialized) {
                return this.httpServer;
            }
            Thread.sleep(100L);
        }
        logger.warn("timeout occurred waiting for http server to initialize");
        return null;
    }

    @Nullable
    HttpServer getNonLazy() {
        return this.httpServer;
    }

    @Nullable
    private HttpServer build() throws InterruptedException {
        HashMap<Pattern, HttpService> httpServices = Maps.newHashMap();
        httpServices.put(Pattern.compile("^/$"), this.indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/transaction/.*$"), this.indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/error/.*$"), this.indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/jvm/.*$"), this.indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/config/.*$"), this.indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/login$"), this.indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/backend/layout$"), this.layoutHttpService);
        httpServices.put(Pattern.compile("^/export/trace/.*$"), this.traceExportHttpService);
        httpServices.put(Pattern.compile("^/backend/trace/queries$"), this.traceDetailHttpService);
        httpServices.put(Pattern.compile("^/backend/trace/entries$"), this.traceDetailHttpService);
        httpServices.put(Pattern.compile("^/backend/trace/profile$"), this.traceDetailHttpService);
        httpServices.put(Pattern.compile("^/backend/jvm/glowroot-log$"), this.glowrootLogHttpService);
        try {
            return new HttpServer(this.bindAddress, this.port, NUM_WORKER_THREADS, this.layoutService, httpServices, this.httpSessionManager, this.jsonServices);
        }
        catch (Exception e) {
            logger.error("error binding to any port, the user interface will not be available", e);
            return null;
        }
    }

    private static void waitForMain(Instrumentation instrumentation) throws InterruptedException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (stopwatch.elapsed(TimeUnit.SECONDS) < 60L) {
            Thread.sleep(100L);
            for (Class clazz : instrumentation.getInitiatedClasses(null)) {
                if (!clazz.getName().equals("sun.misc.Launcher")) continue;
                return;
            }
        }
        logger.error("sun.launcher.LauncherHelper was never loaded");
    }
}

