/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.collector.CollectorModule;
import org.glowroot.common.Clock;
import org.glowroot.common.JavaVersion;
import org.glowroot.config.ConfigModule;
import org.glowroot.config.ConfigService;
import org.glowroot.jvm.JvmModule;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.store.DataSource;
import org.glowroot.local.store.GaugePointDao;
import org.glowroot.local.store.MailService;
import org.glowroot.local.store.StorageModule;
import org.glowroot.local.store.TraceDao;
import org.glowroot.local.ui.AdminJsonService;
import org.glowroot.local.ui.AlertJsonService;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.local.ui.ErrorCommonService;
import org.glowroot.local.ui.ErrorJsonService;
import org.glowroot.local.ui.GaugeJsonService;
import org.glowroot.local.ui.GlowrootLogHttpService;
import org.glowroot.local.ui.HttpServer;
import org.glowroot.local.ui.HttpSessionManager;
import org.glowroot.local.ui.IndexHtmlHttpService;
import org.glowroot.local.ui.InstrumentationJsonService;
import org.glowroot.local.ui.JvmJsonService;
import org.glowroot.local.ui.LayoutHttpService;
import org.glowroot.local.ui.LayoutService;
import org.glowroot.local.ui.LazyHttpServer;
import org.glowroot.local.ui.TraceCommonService;
import org.glowroot.local.ui.TraceDetailHttpService;
import org.glowroot.local.ui.TraceExportHttpService;
import org.glowroot.local.ui.TraceJsonService;
import org.glowroot.local.ui.TracePointJsonService;
import org.glowroot.local.ui.TransactionCommonService;
import org.glowroot.local.ui.TransactionJsonService;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.transaction.TransactionCollector;
import org.glowroot.transaction.TransactionModule;
import org.glowroot.transaction.TransactionRegistry;
import org.glowroot.weaving.AnalyzedWorld;

public class LocalUiModule {
    private final LazyHttpServer lazyHttpServer;

    public LocalUiModule(Ticker ticker, Clock clock, File baseDir, JvmModule jvmModule, ConfigModule configModule, StorageModule storageModule, CollectorModule collectorModule, TransactionModule transactionModule, @Nullable Instrumentation instrumentation, Map<String, String> properties, String version) throws InterruptedException {
        ConfigService configService = configModule.getConfigService();
        AggregateDao aggregateDao = storageModule.getAggregateDao();
        TraceDao traceDao = storageModule.getTraceDao();
        GaugePointDao gaugePointDao = storageModule.getGaugePointDao();
        DataSource dataSource = storageModule.getDataSource();
        TransactionCollector transactionCollector = collectorModule.getTransactionCollector();
        AnalyzedWorld analyzedWorld = transactionModule.getAnalyzedWorld();
        TransactionRegistry transactionRegistry = transactionModule.getTransactionRegistry();
        LayoutService layoutService = new LayoutService(version, configService, configModule.getPluginDescriptors(), jvmModule.getHeapDumps(), collectorModule.getGaugeCollectionIntervalMillis());
        HttpSessionManager httpSessionManager = new HttpSessionManager(configService, clock, layoutService);
        IndexHtmlHttpService indexHtmlHttpService = new IndexHtmlHttpService(httpSessionManager, layoutService);
        LayoutHttpService layoutHttpService = new LayoutHttpService(httpSessionManager, layoutService);
        TransactionCommonService transactionCommonService = new TransactionCommonService(aggregateDao, collectorModule.getAggregateCollector(), configService);
        TraceCommonService traceCommonService = new TraceCommonService(traceDao, transactionRegistry, transactionCollector, clock, ticker);
        TransactionJsonService transactionJsonService = new TransactionJsonService(transactionCommonService, traceDao, transactionRegistry, transactionCollector, aggregateDao, clock);
        TracePointJsonService tracePointJsonService = new TracePointJsonService(traceDao, transactionRegistry, transactionCollector, configService, ticker, clock);
        TraceJsonService traceJsonService = new TraceJsonService(traceCommonService);
        TraceDetailHttpService traceDetailHttpService = new TraceDetailHttpService(traceCommonService);
        TraceExportHttpService traceExportHttpService = new TraceExportHttpService(traceCommonService, version);
        GlowrootLogHttpService glowrootLogHttpService = new GlowrootLogHttpService(baseDir);
        ErrorCommonService errorCommonService = new ErrorCommonService(aggregateDao, collectorModule.getAggregateCollector(), configService.getRollupConfigs());
        ErrorJsonService errorJsonService = new ErrorJsonService(errorCommonService, traceDao, aggregateDao, clock);
        JvmJsonService jvmJsonService = new JvmJsonService(jvmModule.getLazyPlatformMBeanServer(), gaugePointDao, configService, transactionRegistry, transactionCollector, jvmModule.getThreadAllocatedBytes(), jvmModule.getHeapDumps(), jvmModule.getProcessId(), collectorModule.getGaugeCollectionIntervalMillis(), clock);
        ConfigJsonService configJsonService = new ConfigJsonService(configService, storageModule.getRollupCappedDatabases(), storageModule.getTraceCappedDatabase(), configModule.getPluginDescriptors(), httpSessionManager, transactionModule, new MailService());
        InstrumentationJsonService instrumentationJsonService = new InstrumentationJsonService(configService, transactionModule.getAdviceCache(), transactionModule, analyzedWorld, instrumentation);
        GaugeJsonService gaugeJsonService = new GaugeJsonService(configService, jvmModule.getLazyPlatformMBeanServer());
        AlertJsonService alertJsonService = new AlertJsonService(configService);
        AdminJsonService adminJsonService = new AdminJsonService(aggregateDao, traceDao, gaugePointDao, collectorModule.getAggregateCollector(), configService, transactionModule.getAdviceCache(), analyzedWorld, instrumentation, transactionCollector, dataSource, transactionRegistry);
        ArrayList<Object> jsonServices = Lists.newArrayList();
        jsonServices.add(transactionJsonService);
        jsonServices.add(tracePointJsonService);
        jsonServices.add(traceJsonService);
        jsonServices.add(errorJsonService);
        jsonServices.add(jvmJsonService);
        jsonServices.add(configJsonService);
        jsonServices.add(instrumentationJsonService);
        jsonServices.add(gaugeJsonService);
        jsonServices.add(alertJsonService);
        jsonServices.add(adminJsonService);
        int port = configService.getUserInterfaceConfig().port();
        String bindAddress = LocalUiModule.getBindAddress(properties);
        this.lazyHttpServer = new LazyHttpServer(bindAddress, port, httpSessionManager, indexHtmlHttpService, layoutHttpService, layoutService, traceDetailHttpService, traceExportHttpService, glowrootLogHttpService, jsonServices);
        if (instrumentation == null || JavaVersion.isJava6()) {
            this.lazyHttpServer.initNonLazy(configJsonService);
        } else {
            Preconditions.checkNotNull(instrumentation);
            this.lazyHttpServer.init(instrumentation, configJsonService);
        }
    }

    public int getPort() throws InterruptedException {
        return LocalUiModule.getPort(this.lazyHttpServer.get());
    }

    public int getNonLazyPort() {
        return LocalUiModule.getPort(this.lazyHttpServer.getNonLazy());
    }

    @OnlyUsedByTests
    public void close() throws InterruptedException {
        HttpServer httpServer = this.lazyHttpServer.get();
        if (httpServer != null) {
            httpServer.close();
        }
    }

    private static int getPort(@Nullable HttpServer httpServer) {
        return httpServer == null ? -1 : httpServer.getPort();
    }

    private static String getBindAddress(Map<String, String> properties) {
        String bindAddress = properties.get("ui.bind.address");
        if (Strings.isNullOrEmpty(bindAddress)) {
            return "0.0.0.0";
        }
        return bindAddress;
    }
}

