/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.TransactionJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
final class Query
extends TransactionJsonService.QueryBase {
    private final String queryType;
    private final String queryText;
    private final long totalMicros;
    private final long executionCount;
    private final long totalRows;

    private Query(String queryType, String queryText, long totalMicros, long executionCount, long totalRows) {
        this.queryType = queryType;
        this.queryText = queryText;
        this.totalMicros = totalMicros;
        this.executionCount = executionCount;
        this.totalRows = totalRows;
    }

    @Override
    @JsonProperty(value="queryType")
    public String queryType() {
        return this.queryType;
    }

    @Override
    @JsonProperty(value="queryText")
    public String queryText() {
        return this.queryText;
    }

    @Override
    @JsonProperty(value="totalMicros")
    public long totalMicros() {
        return this.totalMicros;
    }

    @Override
    @JsonProperty(value="executionCount")
    public long executionCount() {
        return this.executionCount;
    }

    @Override
    @JsonProperty(value="totalRows")
    public long totalRows() {
        return this.totalRows;
    }

    public final Query withQueryType(String value) {
        if (this.queryType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Query(newValue, this.queryText, this.totalMicros, this.executionCount, this.totalRows);
    }

    public final Query withQueryText(String value) {
        if (this.queryText == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Query(this.queryType, newValue, this.totalMicros, this.executionCount, this.totalRows);
    }

    public final Query withTotalMicros(long value) {
        if (this.totalMicros == value) {
            return this;
        }
        long newValue = value;
        return new Query(this.queryType, this.queryText, newValue, this.executionCount, this.totalRows);
    }

    public final Query withExecutionCount(long value) {
        if (this.executionCount == value) {
            return this;
        }
        long newValue = value;
        return new Query(this.queryType, this.queryText, this.totalMicros, newValue, this.totalRows);
    }

    public final Query withTotalRows(long value) {
        if (this.totalRows == value) {
            return this;
        }
        long newValue = value;
        return new Query(this.queryType, this.queryText, this.totalMicros, this.executionCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof Query && this.equalTo((Query)another);
    }

    private boolean equalTo(Query another) {
        return this.queryType.equals(another.queryType) && this.queryText.equals(another.queryText) && this.totalMicros == another.totalMicros && this.executionCount == another.executionCount && this.totalRows == another.totalRows;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.queryType.hashCode();
        h = h * 17 + this.queryText.hashCode();
        h = h * 17 + Longs.hashCode(this.totalMicros);
        h = h * 17 + Longs.hashCode(this.executionCount);
        h = h * 17 + Longs.hashCode(this.totalRows);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Query").add("queryType", this.queryType).add("queryText", this.queryText).add("totalMicros", this.totalMicros).add("executionCount", this.executionCount).add("totalRows", this.totalRows).toString();
    }

    @JsonCreator
    public static Query fromAllAttributes(@JsonProperty(value="queryType") @Nullable String queryType, @JsonProperty(value="queryText") @Nullable String queryText, @JsonProperty(value="totalMicros") @Nullable Long totalMicros, @JsonProperty(value="executionCount") @Nullable Long executionCount, @JsonProperty(value="totalRows") @Nullable Long totalRows) {
        Builder builder = Query.builder();
        if (queryType != null) {
            builder.queryType(queryType);
        }
        if (queryText != null) {
            builder.queryText(queryText);
        }
        if (totalMicros != null) {
            builder.totalMicros(totalMicros);
        }
        if (executionCount != null) {
            builder.executionCount(executionCount);
        }
        if (totalRows != null) {
            builder.totalRows(totalRows);
        }
        return builder.build();
    }

    static Query copyOf(TransactionJsonService.QueryBase instance) {
        if (instance instanceof Query) {
            return (Query)instance;
        }
        return Query.builder().queryType(instance.queryType()).queryText(instance.queryText()).totalMicros(instance.totalMicros()).executionCount(instance.executionCount()).totalRows(instance.totalRows()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 31L;
        private static final long INITIALIZED_BIT_QUERY_TYPE = 1L;
        private static final long INITIALIZED_BIT_QUERY_TEXT = 2L;
        private static final long INITIALIZED_BIT_TOTAL_MICROS = 4L;
        private static final long INITIALIZED_BIT_EXECUTION_COUNT = 8L;
        private static final long INITIALIZED_BIT_TOTAL_ROWS = 16L;
        private long initializedBitset;
        @Nullable
        private String queryType;
        @Nullable
        private String queryText;
        private long totalMicros;
        private long executionCount;
        private long totalRows;

        private Builder() {
        }

        public final Builder queryType(String queryType) {
            this.checkNotIsSet(this.queryTypeIsSet(), "queryType");
            this.queryType = Preconditions.checkNotNull(queryType);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder queryText(String queryText) {
            this.checkNotIsSet(this.queryTextIsSet(), "queryText");
            this.queryText = Preconditions.checkNotNull(queryText);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder totalMicros(long totalMicros) {
            this.checkNotIsSet(this.totalMicrosIsSet(), "totalMicros");
            this.totalMicros = totalMicros;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder executionCount(long executionCount) {
            this.checkNotIsSet(this.executionCountIsSet(), "executionCount");
            this.executionCount = executionCount;
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder totalRows(long totalRows) {
            this.checkNotIsSet(this.totalRowsIsSet(), "totalRows");
            this.totalRows = totalRows;
            this.initializedBitset |= 0x10L;
            return this;
        }

        public Query build() {
            this.checkRequiredAttributes();
            return new Query(this.queryType, this.queryText, this.totalMicros, this.executionCount, this.totalRows);
        }

        private boolean queryTypeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean queryTextIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean totalMicrosIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean executionCountIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean totalRowsIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Query is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 31L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.queryTypeIsSet()) {
                attributes.add("queryType");
            }
            if (!this.queryTextIsSet()) {
                attributes.add("queryText");
            }
            if (!this.totalMicrosIsSet()) {
                attributes.add("totalMicros");
            }
            if (!this.executionCountIsSet()) {
                attributes.add("executionCount");
            }
            if (!this.totalRowsIsSet()) {
                attributes.add("totalRows");
            }
            return "Cannot build Query, some of required attributes are not set " + attributes;
        }
    }
}

