/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Ints;

@ParametersAreNonnullByDefault
@Immutable
final class StorageConfigDto
extends ConfigJsonService.StorageConfigDtoBase {
    private final ImmutableList<Integer> rollupExpirationHours;
    private final int traceExpirationHours;
    private final ImmutableList<Integer> rollupCappedDatabaseSizesMb;
    private final int traceCappedDatabaseSizeMb;
    private final String version;

    private StorageConfigDto(ImmutableList<Integer> rollupExpirationHours, int traceExpirationHours, ImmutableList<Integer> rollupCappedDatabaseSizesMb, int traceCappedDatabaseSizeMb, String version) {
        this.rollupExpirationHours = rollupExpirationHours;
        this.traceExpirationHours = traceExpirationHours;
        this.rollupCappedDatabaseSizesMb = rollupCappedDatabaseSizesMb;
        this.traceCappedDatabaseSizeMb = traceCappedDatabaseSizeMb;
        this.version = version;
    }

    @Override
    @JsonProperty(value="rollupExpirationHours")
    public ImmutableList<Integer> rollupExpirationHours() {
        return this.rollupExpirationHours;
    }

    @Override
    @JsonProperty(value="traceExpirationHours")
    public int traceExpirationHours() {
        return this.traceExpirationHours;
    }

    @Override
    @JsonProperty(value="rollupCappedDatabaseSizesMb")
    public ImmutableList<Integer> rollupCappedDatabaseSizesMb() {
        return this.rollupCappedDatabaseSizesMb;
    }

    @Override
    @JsonProperty(value="traceCappedDatabaseSizeMb")
    public int traceCappedDatabaseSizeMb() {
        return this.traceCappedDatabaseSizeMb;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final StorageConfigDto withRollupExpirationHours(int ... elements) {
        ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
        return new StorageConfigDto(newValue, this.traceExpirationHours, this.rollupCappedDatabaseSizesMb, this.traceCappedDatabaseSizeMb, this.version);
    }

    public final StorageConfigDto withRollupExpirationHours(Iterable<Integer> elements) {
        if (this.rollupExpirationHours == elements) {
            return this;
        }
        ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
        return new StorageConfigDto(newValue, this.traceExpirationHours, this.rollupCappedDatabaseSizesMb, this.traceCappedDatabaseSizeMb, this.version);
    }

    public final StorageConfigDto withTraceExpirationHours(int value) {
        if (this.traceExpirationHours == value) {
            return this;
        }
        int newValue = value;
        return new StorageConfigDto(this.rollupExpirationHours, newValue, this.rollupCappedDatabaseSizesMb, this.traceCappedDatabaseSizeMb, this.version);
    }

    public final StorageConfigDto withRollupCappedDatabaseSizesMb(int ... elements) {
        ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
        return new StorageConfigDto(this.rollupExpirationHours, this.traceExpirationHours, newValue, this.traceCappedDatabaseSizeMb, this.version);
    }

    public final StorageConfigDto withRollupCappedDatabaseSizesMb(Iterable<Integer> elements) {
        if (this.rollupCappedDatabaseSizesMb == elements) {
            return this;
        }
        ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
        return new StorageConfigDto(this.rollupExpirationHours, this.traceExpirationHours, newValue, this.traceCappedDatabaseSizeMb, this.version);
    }

    public final StorageConfigDto withTraceCappedDatabaseSizeMb(int value) {
        if (this.traceCappedDatabaseSizeMb == value) {
            return this;
        }
        int newValue = value;
        return new StorageConfigDto(this.rollupExpirationHours, this.traceExpirationHours, this.rollupCappedDatabaseSizesMb, newValue, this.version);
    }

    public final StorageConfigDto withVersion(String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new StorageConfigDto(this.rollupExpirationHours, this.traceExpirationHours, this.rollupCappedDatabaseSizesMb, this.traceCappedDatabaseSizeMb, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof StorageConfigDto && this.equalTo((StorageConfigDto)another);
    }

    private boolean equalTo(StorageConfigDto another) {
        return this.rollupExpirationHours.equals(another.rollupExpirationHours) && this.traceExpirationHours == another.traceExpirationHours && this.rollupCappedDatabaseSizesMb.equals(another.rollupCappedDatabaseSizesMb) && this.traceCappedDatabaseSizeMb == another.traceCappedDatabaseSizeMb && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.rollupExpirationHours.hashCode();
        h = h * 17 + this.traceExpirationHours;
        h = h * 17 + this.rollupCappedDatabaseSizesMb.hashCode();
        h = h * 17 + this.traceCappedDatabaseSizeMb;
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("StorageConfigDto").add("rollupExpirationHours", this.rollupExpirationHours).add("traceExpirationHours", this.traceExpirationHours).add("rollupCappedDatabaseSizesMb", this.rollupCappedDatabaseSizesMb).add("traceCappedDatabaseSizeMb", this.traceCappedDatabaseSizeMb).add("version", this.version).toString();
    }

    @JsonCreator
    public static StorageConfigDto fromAllAttributes(@JsonProperty(value="rollupExpirationHours") @Nullable ImmutableList<Integer> rollupExpirationHours, @JsonProperty(value="traceExpirationHours") @Nullable Integer traceExpirationHours, @JsonProperty(value="rollupCappedDatabaseSizesMb") @Nullable ImmutableList<Integer> rollupCappedDatabaseSizesMb, @JsonProperty(value="traceCappedDatabaseSizeMb") @Nullable Integer traceCappedDatabaseSizeMb, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = StorageConfigDto.builder();
        if (rollupExpirationHours != null) {
            builder.addAllRollupExpirationHours(rollupExpirationHours);
        }
        if (traceExpirationHours != null) {
            builder.traceExpirationHours(traceExpirationHours);
        }
        if (rollupCappedDatabaseSizesMb != null) {
            builder.addAllRollupCappedDatabaseSizesMb(rollupCappedDatabaseSizesMb);
        }
        if (traceCappedDatabaseSizeMb != null) {
            builder.traceCappedDatabaseSizeMb(traceCappedDatabaseSizeMb);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static StorageConfigDto copyOf(ConfigJsonService.StorageConfigDtoBase instance) {
        if (instance instanceof StorageConfigDto) {
            return (StorageConfigDto)instance;
        }
        return StorageConfigDto.builder().addAllRollupExpirationHours(instance.rollupExpirationHours()).traceExpirationHours(instance.traceExpirationHours()).addAllRollupCappedDatabaseSizesMb(instance.rollupCappedDatabaseSizesMb()).traceCappedDatabaseSizeMb(instance.traceCappedDatabaseSizeMb()).version(instance.version()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_TRACE_EXPIRATION_HOURS = 1L;
        private static final long INITIALIZED_BIT_TRACE_CAPPED_DATABASE_SIZE_MB = 2L;
        private static final long INITIALIZED_BIT_VERSION = 4L;
        private long initializedBitset;
        private ImmutableList.Builder<Integer> rollupExpirationHoursBuilder = ImmutableList.builder();
        private int traceExpirationHours;
        private ImmutableList.Builder<Integer> rollupCappedDatabaseSizesMbBuilder = ImmutableList.builder();
        private int traceCappedDatabaseSizeMb;
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder addRollupExpirationHours(int element) {
            this.rollupExpirationHoursBuilder.add((Object)element);
            return this;
        }

        public final Builder addRollupExpirationHours(int ... elements) {
            this.rollupExpirationHoursBuilder.addAll(Ints.asList(elements));
            return this;
        }

        public final Builder addAllRollupExpirationHours(Iterable<Integer> elements) {
            this.rollupExpirationHoursBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder traceExpirationHours(int traceExpirationHours) {
            this.checkNotIsSet(this.traceExpirationHoursIsSet(), "traceExpirationHours");
            this.traceExpirationHours = traceExpirationHours;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addRollupCappedDatabaseSizesMb(int element) {
            this.rollupCappedDatabaseSizesMbBuilder.add((Object)element);
            return this;
        }

        public final Builder addRollupCappedDatabaseSizesMb(int ... elements) {
            this.rollupCappedDatabaseSizesMbBuilder.addAll(Ints.asList(elements));
            return this;
        }

        public final Builder addAllRollupCappedDatabaseSizesMb(Iterable<Integer> elements) {
            this.rollupCappedDatabaseSizesMbBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder traceCappedDatabaseSizeMb(int traceCappedDatabaseSizeMb) {
            this.checkNotIsSet(this.traceCappedDatabaseSizeMbIsSet(), "traceCappedDatabaseSizeMb");
            this.traceCappedDatabaseSizeMb = traceCappedDatabaseSizeMb;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder version(String version) {
            this.checkNotIsSet(this.versionIsSet(), "version");
            this.version = Preconditions.checkNotNull(version);
            this.initializedBitset |= 4L;
            return this;
        }

        public StorageConfigDto build() {
            this.checkRequiredAttributes();
            return new StorageConfigDto((ImmutableList)this.rollupExpirationHoursBuilder.build(), this.traceExpirationHours, (ImmutableList)this.rollupCappedDatabaseSizesMbBuilder.build(), this.traceCappedDatabaseSizeMb, this.version);
        }

        private boolean traceExpirationHoursIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean traceCappedDatabaseSizeMbIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean versionIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of StorageConfigDto is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.traceExpirationHoursIsSet()) {
                attributes.add("traceExpirationHours");
            }
            if (!this.traceCappedDatabaseSizeMbIsSet()) {
                attributes.add("traceCappedDatabaseSizeMb");
            }
            if (!this.versionIsSet()) {
                attributes.add("version");
            }
            return "Cannot build StorageConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

