/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.AggregateTimer;
import org.glowroot.local.ui.AggregateMerging;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class TimerMergedAggregate
extends AggregateMerging.TimerMergedAggregateBase {
    private final AggregateTimer syntheticRootTimer;
    private final long transactionCount;

    private TimerMergedAggregate(AggregateTimer syntheticRootTimer, long transactionCount) {
        this.syntheticRootTimer = syntheticRootTimer;
        this.transactionCount = transactionCount;
    }

    @Override
    @JsonProperty(value="timers")
    public AggregateTimer syntheticRootTimer() {
        return this.syntheticRootTimer;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    public final TimerMergedAggregate withSyntheticRootTimer(AggregateTimer value) {
        if (this.syntheticRootTimer == value) {
            return this;
        }
        AggregateTimer newValue = Preconditions.checkNotNull(value);
        return new TimerMergedAggregate(newValue, this.transactionCount);
    }

    public final TimerMergedAggregate withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        long newValue = value;
        return new TimerMergedAggregate(this.syntheticRootTimer, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TimerMergedAggregate && this.equalTo((TimerMergedAggregate)another);
    }

    private boolean equalTo(TimerMergedAggregate another) {
        return this.syntheticRootTimer.equals(another.syntheticRootTimer) && this.transactionCount == another.transactionCount;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.syntheticRootTimer.hashCode();
        h = h * 17 + Longs.hashCode(this.transactionCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TimerMergedAggregate").add("syntheticRootTimer", this.syntheticRootTimer).add("transactionCount", this.transactionCount).toString();
    }

    @JsonCreator
    public static TimerMergedAggregate fromAllAttributes(@JsonProperty(value="timers") @Nullable AggregateTimer syntheticRootTimer, @JsonProperty(value="transactionCount") @Nullable Long transactionCount) {
        Builder builder = TimerMergedAggregate.builder();
        if (syntheticRootTimer != null) {
            builder.syntheticRootTimer(syntheticRootTimer);
        }
        if (transactionCount != null) {
            builder.transactionCount(transactionCount);
        }
        return builder.build();
    }

    public static TimerMergedAggregate copyOf(AggregateMerging.TimerMergedAggregateBase instance) {
        if (instance instanceof TimerMergedAggregate) {
            return (TimerMergedAggregate)instance;
        }
        return TimerMergedAggregate.builder().syntheticRootTimer(instance.syntheticRootTimer()).transactionCount(instance.transactionCount()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_SYNTHETIC_ROOT_TIMER = 1L;
        private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 2L;
        private long initializedBitset;
        @Nullable
        private AggregateTimer syntheticRootTimer;
        private long transactionCount;

        private Builder() {
        }

        public final Builder syntheticRootTimer(AggregateTimer syntheticRootTimer) {
            this.checkNotIsSet(this.syntheticRootTimerIsSet(), "syntheticRootTimer");
            this.syntheticRootTimer = Preconditions.checkNotNull(syntheticRootTimer);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder transactionCount(long transactionCount) {
            this.checkNotIsSet(this.transactionCountIsSet(), "transactionCount");
            this.transactionCount = transactionCount;
            this.initializedBitset |= 2L;
            return this;
        }

        public TimerMergedAggregate build() {
            this.checkRequiredAttributes();
            return new TimerMergedAggregate(this.syntheticRootTimer, this.transactionCount);
        }

        private boolean syntheticRootTimerIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean transactionCountIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of TimerMergedAggregate is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.syntheticRootTimerIsSet()) {
                attributes.add("syntheticRootTimer");
            }
            if (!this.transactionCountIsSet()) {
                attributes.add("transactionCount");
            }
            return "Cannot build TimerMergedAggregate, some of required attributes are not set " + attributes;
        }
    }
}

