/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.glowroot.collector.EntriesChunkSourceCreator;
import org.glowroot.collector.ProfileChunkSourceCreator;
import org.glowroot.collector.Trace;
import org.glowroot.collector.TraceCreator;
import org.glowroot.common.ChunkSource;
import org.glowroot.common.Clock;
import org.glowroot.common.ObjectMappers;
import org.glowroot.local.store.TraceDao;
import org.glowroot.local.ui.TraceExport;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.Iterables;
import org.glowroot.shaded.google.common.io.CharSource;
import org.glowroot.transaction.TransactionCollector;
import org.glowroot.transaction.TransactionRegistry;
import org.glowroot.transaction.model.Transaction;
import org.immutables.value.Value;

class TraceCommonService {
    private static final ObjectMapper mapper = ObjectMappers.create();
    private final TraceDao traceDao;
    private final TransactionRegistry transactionRegistry;
    private final TransactionCollector transactionCollector;
    private final Clock clock;
    private final Ticker ticker;

    TraceCommonService(TraceDao traceDao, TransactionRegistry transactionRegistry, TransactionCollector transactionCollectorImpl, Clock clock, Ticker ticker) {
        this.traceDao = traceDao;
        this.transactionRegistry = transactionRegistry;
        this.transactionCollector = transactionCollectorImpl;
        this.clock = clock;
        this.ticker = ticker;
    }

    @Nullable
    Trace getTrace(String traceId) throws Exception {
        for (Transaction transaction : Iterables.concat(this.transactionRegistry.getTransactions(), this.transactionCollector.getPendingTransactions())) {
            if (!transaction.getId().equals(traceId)) continue;
            return this.createTrace(transaction);
        }
        return this.traceDao.readTrace(traceId);
    }

    @Nullable
    ChunkSource getEntries(String traceId) throws SQLException {
        for (Transaction transaction : Iterables.concat(this.transactionRegistry.getTransactions(), this.transactionCollector.getPendingTransactions())) {
            if (!transaction.getId().equals(traceId)) continue;
            return this.createEntries(transaction);
        }
        return this.toNullableChunkSource(this.traceDao.readEntries(traceId));
    }

    @Nullable
    ChunkSource getProfile(String traceId) throws Exception {
        for (Transaction transaction : Iterables.concat(this.transactionRegistry.getTransactions(), this.transactionCollector.getPendingTransactions())) {
            if (!transaction.getId().equals(traceId)) continue;
            return this.createProfile(transaction);
        }
        return this.toNullableChunkSource(this.traceDao.readProfile(traceId));
    }

    @Nullable
    TraceExport getExport(String traceId) throws Exception {
        for (Transaction transaction : Iterables.concat(this.transactionRegistry.getTransactions(), this.transactionCollector.getPendingTransactions())) {
            if (!transaction.getId().equals(traceId)) continue;
            Trace trace = this.createTrace(transaction);
            return TraceExport.builder().trace(trace).traceJson(mapper.writeValueAsString(trace)).entries(this.createEntries(transaction)).profile(this.createProfile(transaction)).build();
        }
        Trace trace = this.traceDao.readTrace(traceId);
        if (trace == null) {
            return null;
        }
        return TraceExport.builder().trace(trace).traceJson(mapper.writeValueAsString(trace)).entries(this.toNullableChunkSource(this.traceDao.readEntries(traceId))).profile(this.toNullableChunkSource(this.traceDao.readProfile(traceId))).build();
    }

    private Trace createTrace(Transaction transaction) throws IOException {
        if (transaction.isCompleted()) {
            return TraceCreator.createCompletedTrace(transaction);
        }
        return TraceCreator.createActiveTrace(transaction, this.clock.currentTimeMillis(), this.ticker.read());
    }

    @Nullable
    private ChunkSource createEntries(Transaction active) {
        return EntriesChunkSourceCreator.createEntriesChunkSource(active.getEntries(), active.getStartTick(), this.ticker.read());
    }

    @Nullable
    private ChunkSource createProfile(Transaction active) throws IOException {
        return ProfileChunkSourceCreator.createProfileChunkSource(active.getProfile());
    }

    @Nullable
    private ChunkSource toNullableChunkSource(@Nullable CharSource charSource) {
        if (charSource == null) {
            return null;
        }
        return ChunkSource.from(charSource);
    }

    @Value.Immutable
    static abstract class TraceExportBase {
        TraceExportBase() {
        }

        abstract Trace trace();

        abstract String traceJson();

        @Nullable
        abstract ChunkSource entries();

        @Nullable
        abstract ChunkSource profile();
    }
}

