/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.common.Clock;
import org.glowroot.config.ConfigService;
import org.glowroot.local.store.QueryResult;
import org.glowroot.local.store.StringComparator;
import org.glowroot.local.store.TraceDao;
import org.glowroot.local.store.TracePoint;
import org.glowroot.local.store.TracePointQuery;
import org.glowroot.local.ui.GET;
import org.glowroot.local.ui.JsonService;
import org.glowroot.local.ui.QueryStrings;
import org.glowroot.shaded.fasterxml.jackson.core.JsonFactory;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.google.common.base.Function;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.glowroot.shaded.google.common.io.CharStreams;
import org.glowroot.transaction.ErrorMessage;
import org.glowroot.transaction.TransactionCollector;
import org.glowroot.transaction.TransactionRegistry;
import org.glowroot.transaction.model.Transaction;

@JsonService
class TracePointJsonService {
    private static final double NANOSECONDS_PER_MILLISECOND = 1000000.0;
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final TraceDao traceDao;
    private final TransactionRegistry transactionRegistry;
    private final TransactionCollector transactionCollector;
    private final ConfigService configService;
    private final Ticker ticker;
    private final Clock clock;

    TracePointJsonService(TraceDao traceDao, TransactionRegistry transactionRegistry, TransactionCollector transactionCollector, ConfigService configService, Ticker ticker, Clock clock) {
        this.traceDao = traceDao;
        this.transactionRegistry = transactionRegistry;
        this.transactionCollector = transactionCollector;
        this.configService = configService;
        this.ticker = ticker;
        this.clock = clock;
    }

    @GET(value="/backend/trace/points")
    String getPoints(String queryString) throws Exception {
        TracePointQuery query = QueryStrings.decode(queryString, TracePointQuery.class);
        return new Handler(query).handle();
    }

    private class Handler {
        private final TracePointQuery query;

        public Handler(TracePointQuery query) {
            this.query = query;
        }

        private String handle() throws Exception {
            boolean captureActiveTraces = this.shouldCaptureActiveTraces();
            ArrayList<Transaction> activeTraces = Lists.newArrayList();
            long captureTime = 0L;
            long captureTick = 0L;
            if (captureActiveTraces) {
                activeTraces = this.getMatchingActiveTraces();
                captureTime = TracePointJsonService.this.clock.currentTimeMillis();
                captureTick = TracePointJsonService.this.ticker.read();
            }
            QueryResult<TracePoint> queryResult = this.getStoredAndPendingPoints(captureActiveTraces);
            List<TracePoint> points = queryResult.records();
            this.removeDuplicatesBetweenActiveTracesAndPoints(activeTraces, points);
            boolean expired = points.isEmpty() && this.query.to() < TracePointJsonService.this.clock.currentTimeMillis() - TimeUnit.HOURS.toMillis(TracePointJsonService.this.configService.getStorageConfig().traceExpirationHours());
            return this.writeResponse(points, activeTraces, captureTime, captureTick, queryResult.moreAvailable(), expired);
        }

        private boolean shouldCaptureActiveTraces() {
            long currentTimeMillis = TracePointJsonService.this.clock.currentTimeMillis();
            return (this.query.to() == 0L || this.query.to() > currentTimeMillis) && this.query.from() < currentTimeMillis;
        }

        private QueryResult<TracePoint> getStoredAndPendingPoints(boolean captureActiveTraces) throws SQLException {
            List<Object> matchingPendingPoints = captureActiveTraces ? this.getMatchingPendingPoints() : ImmutableList.of();
            QueryResult<TracePoint> queryResult = TracePointJsonService.this.traceDao.readPoints(this.query);
            ArrayList<TracePoint> orderedPoints = Lists.newArrayList(queryResult.records());
            for (TracePoint tracePoint : matchingPendingPoints) {
                this.insertIntoOrderedPoints(tracePoint, orderedPoints);
            }
            return new QueryResult<TracePoint>(orderedPoints, queryResult.moreAvailable());
        }

        private List<Transaction> getMatchingActiveTraces() {
            List<Transaction> activeTraces = Lists.newArrayList();
            for (Transaction transaction : TracePointJsonService.this.transactionRegistry.getTransactions()) {
                if (!this.matches(transaction)) continue;
                activeTraces.add(transaction);
            }
            Collections.sort(activeTraces, Ordering.natural().onResultOf(new Function<Transaction, Long>(){

                @Override
                public Long apply(@Nullable Transaction transaction) {
                    Preconditions.checkNotNull(transaction);
                    return transaction.getStartTick();
                }
            }));
            if (this.query.limit() != 0 && activeTraces.size() > this.query.limit()) {
                activeTraces = activeTraces.subList(0, this.query.limit());
            }
            return activeTraces;
        }

        private List<TracePoint> getMatchingPendingPoints() {
            ArrayList<TracePoint> points = Lists.newArrayList();
            for (Transaction transaction : TracePointJsonService.this.transactionCollector.getPendingTransactions()) {
                if (!this.matches(transaction)) continue;
                TracePoint point = TracePoint.builder().id(transaction.getId()).captureTime(TracePointJsonService.this.clock.currentTimeMillis()).duration(transaction.getDuration()).error(transaction.getErrorMessage() != null).build();
                points.add(point);
            }
            return points;
        }

        private boolean matches(Transaction transaction) {
            return this.matchesDuration(transaction) && this.matchesTransactionType(transaction) && this.matchesSlowOnly(transaction) && this.matchesErrorOnly(transaction) && this.matchesHeadline(transaction) && this.matchesTransactionName(transaction) && this.matchesError(transaction) && this.matchesUser(transaction) && this.matchesCustomAttribute(transaction);
        }

        private boolean matchesDuration(Transaction transaction) {
            long duration = transaction.getDuration();
            if (duration < this.query.durationLow()) {
                return false;
            }
            Long durationHigh = this.query.durationHigh();
            return durationHigh == null || duration <= durationHigh;
        }

        private boolean matchesTransactionType(Transaction transaction) {
            String transactionType = this.query.transactionType();
            if (Strings.isNullOrEmpty(transactionType)) {
                return true;
            }
            return transactionType.equals(transaction.getTransactionType());
        }

        private boolean matchesSlowOnly(Transaction transaction) {
            return !this.query.slowOnly() || TracePointJsonService.this.transactionCollector.shouldStoreSlow(transaction);
        }

        private boolean matchesErrorOnly(Transaction transaction) {
            return !this.query.errorOnly() || TracePointJsonService.this.transactionCollector.shouldStoreError(transaction);
        }

        private boolean matchesHeadline(Transaction transaction) {
            return this.matchesUsingStringComparator(this.query.headlineComparator(), this.query.headline(), transaction.getHeadline());
        }

        private boolean matchesTransactionName(Transaction transaction) {
            return this.matchesUsingStringComparator(this.query.transactionNameComparator(), this.query.transactionName(), transaction.getTransactionName());
        }

        private boolean matchesError(Transaction transaction) {
            ErrorMessage errorMessage = transaction.getErrorMessage();
            String text = errorMessage == null ? null : errorMessage.message();
            return this.matchesUsingStringComparator(this.query.errorComparator(), this.query.error(), text);
        }

        private boolean matchesUser(Transaction transaction) {
            return this.matchesUsingStringComparator(this.query.userComparator(), this.query.user(), transaction.getUser());
        }

        private boolean matchesCustomAttribute(Transaction transaction) {
            if (Strings.isNullOrEmpty(this.query.customAttributeName()) && (this.query.customAttributeValueComparator() == null || Strings.isNullOrEmpty(this.query.customAttributeValue()))) {
                return true;
            }
            Map customAttributes = transaction.getCustomAttributes().asMap();
            for (Map.Entry entry : ((ImmutableMap)customAttributes).entrySet()) {
                String customAttributeName = (String)entry.getKey();
                if (!this.matchesUsingStringComparator(StringComparator.EQUALS, this.query.customAttributeName(), customAttributeName)) continue;
                for (String customAttributeValue : (Collection)entry.getValue()) {
                    if (!this.matchesUsingStringComparator(this.query.customAttributeValueComparator(), this.query.customAttributeValue(), customAttributeValue)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean matchesUsingStringComparator(@Nullable StringComparator requestComparator, @Nullable String requestText, @Nullable String traceText) throws AssertionError {
            if (requestComparator == null || Strings.isNullOrEmpty(requestText)) {
                return true;
            }
            if (Strings.isNullOrEmpty(traceText)) {
                return false;
            }
            return requestComparator.matches(traceText, requestText);
        }

        private void insertIntoOrderedPoints(TracePoint pendingPoint, List<TracePoint> orderedPoints) {
            int duplicateIndex = -1;
            int insertionIndex = -1;
            for (int i = 0; i < orderedPoints.size(); ++i) {
                TracePoint point = orderedPoints.get(i);
                if (pendingPoint.id().equals(point.id())) {
                    duplicateIndex = i;
                    break;
                }
                if (!(pendingPoint.duration() > point.duration())) continue;
                insertionIndex = i;
                break;
            }
            if (duplicateIndex != -1) {
                TracePoint point = orderedPoints.get(duplicateIndex);
                if (pendingPoint.duration() > point.duration()) {
                    orderedPoints.set(duplicateIndex, pendingPoint);
                }
                return;
            }
            if (insertionIndex == -1) {
                orderedPoints.add(pendingPoint);
            } else {
                orderedPoints.add(insertionIndex, pendingPoint);
            }
        }

        private void removeDuplicatesBetweenActiveTracesAndPoints(List<Transaction> activeTraces, List<TracePoint> points) {
            Iterator<Transaction> i = activeTraces.iterator();
            block0: while (i.hasNext()) {
                Transaction activeTransaction = i.next();
                Iterator<TracePoint> j = points.iterator();
                while (j.hasNext()) {
                    TracePoint point = j.next();
                    if (!activeTransaction.getId().equals(point.id())) continue;
                    if ((double)activeTransaction.getDuration() > point.duration()) {
                        j.remove();
                        continue block0;
                    }
                    i.remove();
                    continue block0;
                }
            }
        }

        private String writeResponse(List<TracePoint> points, List<Transaction> activeTraces, long captureTime, long captureTick, boolean limitExceeded, boolean expired) throws IOException, SQLException {
            StringBuilder sb = new StringBuilder();
            JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter(sb));
            jg.writeStartObject();
            jg.writeArrayFieldStart("normalPoints");
            for (TracePoint point : points) {
                if (point.error()) continue;
                jg.writeStartArray();
                jg.writeNumber(point.captureTime());
                jg.writeNumber(point.duration() / 1000000.0);
                jg.writeString(point.id());
                jg.writeEndArray();
            }
            jg.writeEndArray();
            jg.writeArrayFieldStart("errorPoints");
            for (TracePoint point : points) {
                if (!point.error()) continue;
                jg.writeStartArray();
                jg.writeNumber(point.captureTime());
                jg.writeNumber(point.duration() / 1000000.0);
                jg.writeString(point.id());
                jg.writeEndArray();
            }
            jg.writeEndArray();
            jg.writeArrayFieldStart("activePoints");
            for (Transaction activeTrace : activeTraces) {
                jg.writeStartArray();
                jg.writeNumber(captureTime);
                jg.writeNumber((double)(captureTick - activeTrace.getStartTick()) / 1000000.0);
                jg.writeString(activeTrace.getId());
                jg.writeEndArray();
            }
            jg.writeEndArray();
            if (limitExceeded) {
                jg.writeBooleanField("limitExceeded", true);
            }
            if (expired) {
                jg.writeBooleanField("expired", true);
            }
            jg.writeEndObject();
            jg.close();
            return sb.toString();
        }
    }
}

