/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.collector.Aggregate;
import org.glowroot.collector.AggregateCollector;
import org.glowroot.collector.AggregateIntervalCollector;
import org.glowroot.collector.ProfileAggregate;
import org.glowroot.collector.QueryAggregate;
import org.glowroot.collector.QueryComponent;
import org.glowroot.collector.TransactionSummary;
import org.glowroot.common.ScratchBuffer;
import org.glowroot.common.Traverser;
import org.glowroot.config.ConfigService;
import org.glowroot.config.RollupConfig;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.store.QueryResult;
import org.glowroot.local.store.TransactionSummaryQuery;
import org.glowroot.local.ui.AggregateMerging;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.transaction.model.ProfileNode;

class TransactionCommonService {
    private final AggregateDao aggregateDao;
    @Nullable
    private final AggregateCollector aggregateCollector;
    private final ConfigService configService;

    TransactionCommonService(AggregateDao aggregateDao, @Nullable AggregateCollector aggregateCollector, ConfigService configService) {
        this.aggregateDao = aggregateDao;
        this.aggregateCollector = aggregateCollector;
        this.configService = configService;
    }

    TransactionSummary readOverallSummary(String transactionType, long from, long to) throws SQLException {
        List<AggregateIntervalCollector> orderedIntervalCollectors = this.getOrderedIntervalCollectorsInRange(from, to);
        if (orderedIntervalCollectors.isEmpty()) {
            return this.aggregateDao.readOverallSummary(transactionType, from, to);
        }
        long revisedTo = TransactionCommonService.getRevisedTo(to, orderedIntervalCollectors);
        TransactionSummary overallSummary = this.aggregateDao.readOverallSummary(transactionType, from, revisedTo);
        return this.mergeInLiveOverallSummaries(transactionType, overallSummary, orderedIntervalCollectors);
    }

    QueryResult<TransactionSummary> readTransactionSummaries(TransactionSummaryQuery query) throws SQLException {
        List<AggregateIntervalCollector> orderedIntervalCollectors = this.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        if (orderedIntervalCollectors.isEmpty()) {
            return this.aggregateDao.readTransactionSummaries(query);
        }
        long revisedTo = TransactionCommonService.getRevisedTo(query.to(), orderedIntervalCollectors);
        TransactionSummaryQuery revisedQuery = query.withTo(revisedTo);
        QueryResult<TransactionSummary> queryResult = this.aggregateDao.readTransactionSummaries(revisedQuery);
        if (orderedIntervalCollectors.isEmpty()) {
            return queryResult;
        }
        return TransactionCommonService.mergeInLiveTransactionSummaries(revisedQuery, queryResult, orderedIntervalCollectors);
    }

    boolean shouldHaveQueries(String transactionType, @Nullable String transactionName, long from, long to) throws SQLException {
        if (transactionName == null) {
            return this.aggregateDao.shouldHaveOverallQueries(transactionType, from, to);
        }
        return this.aggregateDao.shouldHaveTransactionQueries(transactionType, transactionName, from, to);
    }

    boolean shouldHaveProfile(String transactionType, @Nullable String transactionName, long from, long to) throws SQLException {
        if (transactionName == null) {
            return this.aggregateDao.shouldHaveOverallProfile(transactionType, from, to);
        }
        return this.aggregateDao.shouldHaveTransactionProfile(transactionType, transactionName, from, to);
    }

    List<Aggregate> getAggregates(String transactionType, @Nullable String transactionName, long from, long to, long liveCaptureTime) throws Exception {
        int rollupLevel = this.aggregateDao.getRollupLevelForView(from, to);
        List<AggregateIntervalCollector> orderedIntervalCollectors = this.getOrderedIntervalCollectorsInRange(from - 1L, to);
        long revisedTo = TransactionCommonService.getRevisedTo(to, orderedIntervalCollectors);
        List<Aggregate> aggregates = this.getAggregatesFromDao(transactionType, transactionName, from, revisedTo, rollupLevel);
        if (rollupLevel == 0) {
            aggregates = Lists.newArrayList(aggregates);
            aggregates.addAll(TransactionCommonService.getLiveAggregates(transactionType, transactionName, orderedIntervalCollectors, liveCaptureTime));
            return aggregates;
        }
        long nonRolledUpFrom = from;
        if (!aggregates.isEmpty()) {
            long lastRolledUpTime = aggregates.get(aggregates.size() - 1).captureTime();
            nonRolledUpFrom = Math.max(nonRolledUpFrom, lastRolledUpTime + 1L);
        }
        ArrayList<Aggregate> orderedNonRolledUpAggregates = Lists.newArrayList();
        orderedNonRolledUpAggregates.addAll(this.getAggregatesFromDao(transactionType, transactionName, nonRolledUpFrom, revisedTo, 0));
        orderedNonRolledUpAggregates.addAll(TransactionCommonService.getLiveAggregates(transactionType, transactionName, orderedIntervalCollectors, liveCaptureTime));
        aggregates = Lists.newArrayList(aggregates);
        aggregates.addAll(this.rollUp(transactionType, transactionName, orderedNonRolledUpAggregates, liveCaptureTime, rollupLevel));
        return aggregates;
    }

    Map<String, List<QueryComponent.AggregateQuery>> getQueries(String transactionType, @Nullable String transactionName, long from, long to) throws Exception {
        List<QueryAggregate> queryAggregates = this.getQueryAggregates(transactionType, transactionName, from, to);
        return AggregateMerging.getOrderedAndTruncatedQueries(queryAggregates, this.configService.getAdvancedConfig().maxAggregateQueriesPerQueryType());
    }

    ProfileNode getProfile(String transactionType, @Nullable String transactionName, long from, long to, List<String> includes, List<String> excludes, double truncateLeafPercentage) throws Exception {
        List<ProfileAggregate> profileAggregate = this.getProfileAggregates(transactionType, transactionName, from, to);
        ProfileNode syntheticRootNode = AggregateMerging.getMergedProfile(profileAggregate);
        long syntheticRootNodeSampleCount = syntheticRootNode.getSampleCount();
        if (!includes.isEmpty() || !excludes.isEmpty()) {
            TransactionCommonService.filter(syntheticRootNode, includes, excludes);
        }
        if (truncateLeafPercentage != 0.0) {
            int minSamples = (int)Math.ceil((double)syntheticRootNode.getSampleCount() * truncateLeafPercentage);
            TransactionCommonService.truncateLeafs(syntheticRootNode.getChildNodes(), minSamples);
        }
        syntheticRootNode.setSampleCount(syntheticRootNodeSampleCount);
        return syntheticRootNode;
    }

    private List<AggregateIntervalCollector> getOrderedIntervalCollectorsInRange(long from, long to) {
        if (this.aggregateCollector == null) {
            return ImmutableList.of();
        }
        return this.aggregateCollector.getOrderedIntervalCollectorsInRange(from, to);
    }

    private List<Aggregate> getAggregatesFromDao(String transactionType, @Nullable String transactionName, long from, long to, int rollupLevel) throws SQLException {
        if (transactionName == null) {
            return this.aggregateDao.readOverallAggregates(transactionType, from, to, rollupLevel);
        }
        return this.aggregateDao.readTransactionAggregates(transactionType, transactionName, from, to, rollupLevel);
    }

    private List<QueryAggregate> getQueryAggregates(String transactionType, @Nullable String transactionName, long from, long to) throws Exception {
        int initialRollupLevel = this.aggregateDao.getRollupLevelForView(from, to);
        List<AggregateIntervalCollector> orderedIntervalCollectors = this.getOrderedIntervalCollectorsInRange(from, to);
        long revisedTo = TransactionCommonService.getRevisedTo(to, orderedIntervalCollectors);
        long revisedFrom = from;
        ArrayList<QueryAggregate> orderedQueryAggregates = Lists.newArrayList();
        for (int rollupLevel = initialRollupLevel; rollupLevel >= 0; --rollupLevel) {
            List<QueryAggregate> queryAggregates = this.getQueryAggregatesFromDao(transactionType, transactionName, from, revisedTo, rollupLevel);
            if (!queryAggregates.isEmpty()) {
                long lastRolledUpTime = queryAggregates.get(queryAggregates.size() - 1).captureTime();
                revisedFrom = Math.max(revisedFrom, lastRolledUpTime + 1L);
            }
            orderedQueryAggregates.addAll(queryAggregates);
            if (revisedFrom > revisedTo) break;
        }
        orderedQueryAggregates.addAll(TransactionCommonService.getLiveQueryAggregates(transactionType, transactionName, orderedIntervalCollectors));
        return orderedQueryAggregates;
    }

    private List<QueryAggregate> getQueryAggregatesFromDao(String transactionType, @Nullable String transactionName, long from, long to, int rollupLevel) throws SQLException {
        if (transactionName == null) {
            return this.aggregateDao.readOverallQueryAggregates(transactionType, from, to, rollupLevel);
        }
        return this.aggregateDao.readTransactionQueryAggregates(transactionType, transactionName, from, to, rollupLevel);
    }

    private List<ProfileAggregate> getProfileAggregates(String transactionType, @Nullable String transactionName, long from, long to) throws Exception {
        int initialRollupLevel = this.aggregateDao.getRollupLevelForView(from, to);
        List<AggregateIntervalCollector> orderedIntervalCollectors = this.getOrderedIntervalCollectorsInRange(from, to);
        long revisedTo = TransactionCommonService.getRevisedTo(to, orderedIntervalCollectors);
        long revisedFrom = from;
        ArrayList<ProfileAggregate> orderedProfileAggregates = Lists.newArrayList();
        for (int rollupLevel = initialRollupLevel; rollupLevel >= 0; --rollupLevel) {
            List<ProfileAggregate> profileAggregates = this.getProfileAggregatesFromDao(transactionType, transactionName, revisedFrom, revisedTo, rollupLevel);
            if (!profileAggregates.isEmpty()) {
                long lastRolledUpTime = profileAggregates.get(profileAggregates.size() - 1).captureTime();
                revisedFrom = Math.max(revisedFrom, lastRolledUpTime + 1L);
            }
            orderedProfileAggregates.addAll(profileAggregates);
            if (revisedFrom > revisedTo) break;
        }
        orderedProfileAggregates.addAll(TransactionCommonService.getLiveProfileAggregates(transactionType, transactionName, orderedIntervalCollectors));
        return orderedProfileAggregates;
    }

    private List<ProfileAggregate> getProfileAggregatesFromDao(String transactionType, @Nullable String transactionName, long from, long to, int rollupLevel) throws SQLException {
        if (transactionName == null) {
            return this.aggregateDao.readOverallProfileAggregates(transactionType, from, to, rollupLevel);
        }
        return this.aggregateDao.readTransactionProfileAggregates(transactionType, transactionName, from, to, rollupLevel);
    }

    private List<Aggregate> rollUp(String transactionType, @Nullable String transactionName, List<Aggregate> orderedNonRolledUpAggregates, long liveCaptureTime, int rollupLevel) throws Exception {
        long fixedIntervalMillis = ((RollupConfig)this.configService.getRollupConfigs().get(rollupLevel)).intervalMillis();
        ArrayList<Aggregate> rolledUpAggregates = Lists.newArrayList();
        ScratchBuffer scratchBuffer = new ScratchBuffer();
        AggregateDao.MergedAggregate currMergedAggregate = null;
        long currRollupTime = Long.MIN_VALUE;
        for (Aggregate nonRolledUpAggregate : orderedNonRolledUpAggregates) {
            long rollupTime = AggregateDao.getNextRollupTime(nonRolledUpAggregate.captureTime(), fixedIntervalMillis);
            if (rollupTime != currRollupTime && currMergedAggregate != null) {
                rolledUpAggregates.add(currMergedAggregate.toAggregate(scratchBuffer));
                currMergedAggregate = new AggregateDao.MergedAggregate(Math.min(rollupTime, liveCaptureTime), transactionType, transactionName, this.configService.getAdvancedConfig().maxAggregateQueriesPerQueryType());
            }
            if (currMergedAggregate == null) {
                currMergedAggregate = new AggregateDao.MergedAggregate(Math.min(rollupTime, liveCaptureTime), transactionType, transactionName, this.configService.getAdvancedConfig().maxAggregateQueriesPerQueryType());
            }
            currRollupTime = rollupTime;
            currMergedAggregate.addTotalMicros(nonRolledUpAggregate.totalMicros());
            currMergedAggregate.addErrorCount(nonRolledUpAggregate.errorCount());
            currMergedAggregate.addTransactionCount(nonRolledUpAggregate.transactionCount());
            currMergedAggregate.addTotalCpuMicros(nonRolledUpAggregate.totalCpuMicros());
            currMergedAggregate.addTotalBlockedMicros(nonRolledUpAggregate.totalBlockedMicros());
            currMergedAggregate.addTotalWaitedMicros(nonRolledUpAggregate.totalWaitedMicros());
            currMergedAggregate.addTotalAllocatedKBytes(nonRolledUpAggregate.totalAllocatedKBytes());
            currMergedAggregate.addTimers(nonRolledUpAggregate.timers());
            currMergedAggregate.addHistogram(nonRolledUpAggregate.histogram());
        }
        if (currMergedAggregate != null) {
            rolledUpAggregates.add(currMergedAggregate.toAggregate(scratchBuffer));
        }
        return rolledUpAggregates;
    }

    private static long getRevisedTo(long to, List<AggregateIntervalCollector> orderedIntervalCollectors) {
        if (orderedIntervalCollectors.isEmpty()) {
            return to;
        }
        return orderedIntervalCollectors.get(0).getEndTime() - 1L;
    }

    private TransactionSummary mergeInLiveOverallSummaries(String transactionType, TransactionSummary overallSummary, List<AggregateIntervalCollector> intervalCollectors) {
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            TransactionSummary liveOverallSummary = intervalCollector.getLiveOverallSummary(transactionType);
            if (liveOverallSummary == null) continue;
            overallSummary = TransactionCommonService.combineTransactionSummaries(null, overallSummary, liveOverallSummary);
        }
        return overallSummary;
    }

    private static QueryResult<TransactionSummary> mergeInLiveTransactionSummaries(TransactionSummaryQuery query, QueryResult<TransactionSummary> queryResult, List<AggregateIntervalCollector> intervalCollectors) {
        List<TransactionSummary> transactionSummaries = queryResult.records();
        HashMap<String, TransactionSummary> transactionSummaryMap = Maps.newHashMap();
        for (TransactionSummary transactionSummary : transactionSummaries) {
            String transactionName = transactionSummary.transactionName();
            Preconditions.checkNotNull(transactionName);
            transactionSummaryMap.put(transactionName, transactionSummary);
        }
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            List<TransactionSummary> liveTransactionSummaries = intervalCollector.getLiveTransactionSummaries(query.transactionType());
            for (TransactionSummary liveTransactionSummary : liveTransactionSummaries) {
                String transactionName = liveTransactionSummary.transactionName();
                Preconditions.checkNotNull(transactionName);
                TransactionSummary transactionSummary = (TransactionSummary)transactionSummaryMap.get(transactionName);
                if (transactionSummary == null) {
                    transactionSummaryMap.put(transactionName, liveTransactionSummary);
                    continue;
                }
                transactionSummaryMap.put(transactionName, TransactionCommonService.combineTransactionSummaries(transactionName, transactionSummary, liveTransactionSummary));
            }
        }
        transactionSummaries = TransactionCommonService.sortTransactionSummaries(transactionSummaryMap.values(), query.sortOrder());
        boolean moreAvailable = queryResult.moreAvailable();
        if (transactionSummaries.size() > query.limit()) {
            moreAvailable = true;
            transactionSummaries = transactionSummaries.subList(0, query.limit());
        }
        return new QueryResult<TransactionSummary>(transactionSummaries, moreAvailable);
    }

    private static List<Aggregate> getLiveAggregates(String transactionType, @Nullable String transactionName, List<AggregateIntervalCollector> intervalCollectors, long liveCaptureTime) throws IOException {
        ArrayList<Aggregate> aggregates = Lists.newArrayList();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            Aggregate liveAggregate = intervalCollector.getLiveAggregate(transactionType, transactionName, liveCaptureTime);
            if (liveAggregate == null) continue;
            aggregates.add(liveAggregate);
        }
        return aggregates;
    }

    private static List<QueryAggregate> getLiveQueryAggregates(String transactionType, @Nullable String transactionName, List<AggregateIntervalCollector> intervalCollectors) throws IOException {
        ArrayList<QueryAggregate> queryAggregates = Lists.newArrayList();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            QueryAggregate liveQueryAggregate = intervalCollector.getLiveQueryAggregate(transactionType, transactionName);
            if (liveQueryAggregate == null) continue;
            queryAggregates.add(liveQueryAggregate);
        }
        return queryAggregates;
    }

    private static List<ProfileAggregate> getLiveProfileAggregates(String transactionType, @Nullable String transactionName, List<AggregateIntervalCollector> intervalCollectors) throws IOException {
        ArrayList<ProfileAggregate> profileAggregates = Lists.newArrayList();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            ProfileAggregate liveProfileAggregate = intervalCollector.getLiveProfileAggregate(transactionType, transactionName);
            if (liveProfileAggregate == null) continue;
            profileAggregates.add(liveProfileAggregate);
        }
        return profileAggregates;
    }

    private static TransactionSummary combineTransactionSummaries(@Nullable String transactionName, TransactionSummary summary1, TransactionSummary summary2) {
        return TransactionSummary.builder().transactionName(transactionName).totalMicros(summary1.totalMicros() + summary2.totalMicros()).transactionCount(summary1.transactionCount() + summary2.transactionCount()).build();
    }

    private static void filter(ProfileNode syntheticRootNode, List<String> includes, List<String> excludes) {
        for (String include : includes) {
            if (syntheticRootNode.isMatched()) {
                new ProfileResetMatches(syntheticRootNode).traverse();
            }
            new ProfileFilterer(syntheticRootNode, include, false).traverse();
        }
        for (String exclude : excludes) {
            if (syntheticRootNode.isMatched()) {
                new ProfileResetMatches(syntheticRootNode).traverse();
            }
            new ProfileFilterer(syntheticRootNode, exclude, true).traverse();
        }
    }

    private static void truncateLeafs(Iterable<ProfileNode> rootNodes, int minSamples) {
        ProfileNode node;
        ArrayDeque<ProfileNode> toBeVisited = new ArrayDeque<ProfileNode>();
        for (ProfileNode rootNode : rootNodes) {
            toBeVisited.add(rootNode);
        }
        while ((node = (ProfileNode)toBeVisited.poll()) != null) {
            Iterator<ProfileNode> i = node.getChildNodes().iterator();
            while (i.hasNext()) {
                ProfileNode childNode = i.next();
                if (childNode.getSampleCount() < (long)minSamples) {
                    i.remove();
                    node.incrementEllipsedSampleCount((int)childNode.getSampleCount());
                    continue;
                }
                toBeVisited.add(childNode);
            }
        }
    }

    private static List<TransactionSummary> sortTransactionSummaries(Iterable<TransactionSummary> transactionSummaries, AggregateDao.TransactionSummarySortOrder sortOrder) {
        switch (sortOrder) {
            case TOTAL_TIME: {
                return TransactionSummary.orderingByTotalTimeDesc.immutableSortedCopy(transactionSummaries);
            }
            case AVERAGE_TIME: {
                return TransactionSummary.orderingByAverageTimeDesc.immutableSortedCopy(transactionSummaries);
            }
            case THROUGHPUT: {
                return TransactionSummary.orderingByTransactionCountDesc.immutableSortedCopy(transactionSummaries);
            }
        }
        throw new AssertionError((Object)("Unexpected sort order: " + (Object)((Object)sortOrder)));
    }

    private static class ProfileResetMatches
    extends Traverser<ProfileNode, RuntimeException> {
        private ProfileResetMatches(ProfileNode rootNode) {
            super(rootNode);
        }

        @Override
        public List<ProfileNode> visit(ProfileNode node) throws RuntimeException {
            node.resetMatched();
            return ImmutableList.copyOf(node.getChildNodes());
        }

        @Override
        public void revisitAfterChildren(ProfileNode node) throws RuntimeException {
        }
    }

    private static class ProfileFilterer
    extends Traverser<ProfileNode, RuntimeException> {
        private final String filterTextUpper;
        private final boolean exclusion;

        private ProfileFilterer(ProfileNode rootNode, String filterText, boolean exclusion) {
            super(rootNode);
            this.filterTextUpper = filterText.toUpperCase(Locale.ENGLISH);
            this.exclusion = exclusion;
        }

        @Override
        public List<ProfileNode> visit(ProfileNode node) {
            if (this.isMatch(node)) {
                node.setMatched();
                return ImmutableList.of();
            }
            return ImmutableList.copyOf(node.getChildNodes());
        }

        @Override
        public void revisitAfterChildren(ProfileNode node) {
            if (node.isMatched()) {
                return;
            }
            if (node.isChildNodesEmpty()) {
                return;
            }
            if (this.removeNode(node)) {
                if (this.exclusion) {
                    node.setMatched();
                }
                return;
            }
            if (!this.exclusion) {
                node.setMatched();
            }
            long filteredSampleCount = 0L;
            Iterator<ProfileNode> i = node.iterator();
            while (i.hasNext()) {
                ProfileNode childNode = i.next();
                if (this.exclusion == !childNode.isMatched()) {
                    filteredSampleCount += childNode.getSampleCount();
                    continue;
                }
                i.remove();
            }
            node.setSampleCount(filteredSampleCount);
        }

        private boolean isMatch(ProfileNode node) {
            String leafThreadStateUpper;
            String stackTraceElementUpper = node.getStackTraceElementStr().toUpperCase(Locale.ENGLISH);
            if (stackTraceElementUpper.contains(this.filterTextUpper)) {
                return true;
            }
            String leafThreadState = node.getLeafThreadState();
            return leafThreadState != null && (leafThreadStateUpper = leafThreadState.toUpperCase(Locale.ENGLISH)).contains(this.filterTextUpper);
        }

        private boolean removeNode(ProfileNode node) {
            if (node.isSyntheticRootNode()) {
                return false;
            }
            if (this.exclusion) {
                return this.hasOnlyMatchedChildren(node);
            }
            return this.hasNoMatchedChildren(node);
        }

        private boolean hasOnlyMatchedChildren(ProfileNode node) {
            for (ProfileNode childNode : node) {
                if (childNode.isMatched()) continue;
                return false;
            }
            return true;
        }

        private boolean hasNoMatchedChildren(ProfileNode node) {
            for (ProfileNode childNode : node) {
                if (!childNode.isMatched()) continue;
                return false;
            }
            return true;
        }
    }
}

