/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Doubles;

@ParametersAreNonnullByDefault
@Immutable
final class TransactionConfigDto
extends ConfigJsonService.TransactionConfigDtoBase {
    private final int slowThresholdMillis;
    private final int profilingIntervalMillis;
    private final String defaultDisplayedTransactionType;
    private final ImmutableList<Double> defaultDisplayedPercentiles;
    private final String version;

    private TransactionConfigDto(int slowThresholdMillis, int profilingIntervalMillis, String defaultDisplayedTransactionType, ImmutableList<Double> defaultDisplayedPercentiles, String version) {
        this.slowThresholdMillis = slowThresholdMillis;
        this.profilingIntervalMillis = profilingIntervalMillis;
        this.defaultDisplayedTransactionType = defaultDisplayedTransactionType;
        this.defaultDisplayedPercentiles = defaultDisplayedPercentiles;
        this.version = version;
    }

    @Override
    @JsonProperty(value="slowThresholdMillis")
    public int slowThresholdMillis() {
        return this.slowThresholdMillis;
    }

    @Override
    @JsonProperty(value="profilingIntervalMillis")
    public int profilingIntervalMillis() {
        return this.profilingIntervalMillis;
    }

    @Override
    @JsonProperty(value="defaultDisplayedTransactionType")
    public String defaultDisplayedTransactionType() {
        return this.defaultDisplayedTransactionType;
    }

    @Override
    @JsonProperty(value="defaultDisplayedPercentiles")
    public ImmutableList<Double> defaultDisplayedPercentiles() {
        return this.defaultDisplayedPercentiles;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final TransactionConfigDto withSlowThresholdMillis(int value) {
        if (this.slowThresholdMillis == value) {
            return this;
        }
        int newValue = value;
        return new TransactionConfigDto(newValue, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, this.defaultDisplayedPercentiles, this.version);
    }

    public final TransactionConfigDto withProfilingIntervalMillis(int value) {
        if (this.profilingIntervalMillis == value) {
            return this;
        }
        int newValue = value;
        return new TransactionConfigDto(this.slowThresholdMillis, newValue, this.defaultDisplayedTransactionType, this.defaultDisplayedPercentiles, this.version);
    }

    public final TransactionConfigDto withDefaultDisplayedTransactionType(String value) {
        if (this.defaultDisplayedTransactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new TransactionConfigDto(this.slowThresholdMillis, this.profilingIntervalMillis, newValue, this.defaultDisplayedPercentiles, this.version);
    }

    public final TransactionConfigDto withDefaultDisplayedPercentiles(double ... elements) {
        ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
        return new TransactionConfigDto(this.slowThresholdMillis, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, newValue, this.version);
    }

    public final TransactionConfigDto withDefaultDisplayedPercentiles(Iterable<Double> elements) {
        if (this.defaultDisplayedPercentiles == elements) {
            return this;
        }
        ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
        return new TransactionConfigDto(this.slowThresholdMillis, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, newValue, this.version);
    }

    public final TransactionConfigDto withVersion(String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new TransactionConfigDto(this.slowThresholdMillis, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, this.defaultDisplayedPercentiles, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TransactionConfigDto && this.equalTo((TransactionConfigDto)another);
    }

    private boolean equalTo(TransactionConfigDto another) {
        return this.slowThresholdMillis == another.slowThresholdMillis && this.profilingIntervalMillis == another.profilingIntervalMillis && this.defaultDisplayedTransactionType.equals(another.defaultDisplayedTransactionType) && this.defaultDisplayedPercentiles.equals(another.defaultDisplayedPercentiles) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.slowThresholdMillis;
        h = h * 17 + this.profilingIntervalMillis;
        h = h * 17 + this.defaultDisplayedTransactionType.hashCode();
        h = h * 17 + this.defaultDisplayedPercentiles.hashCode();
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TransactionConfigDto").add("slowThresholdMillis", this.slowThresholdMillis).add("profilingIntervalMillis", this.profilingIntervalMillis).add("defaultDisplayedTransactionType", this.defaultDisplayedTransactionType).add("defaultDisplayedPercentiles", this.defaultDisplayedPercentiles).add("version", this.version).toString();
    }

    @JsonCreator
    public static TransactionConfigDto fromAllAttributes(@JsonProperty(value="slowThresholdMillis") @Nullable Integer slowThresholdMillis, @JsonProperty(value="profilingIntervalMillis") @Nullable Integer profilingIntervalMillis, @JsonProperty(value="defaultDisplayedTransactionType") @Nullable String defaultDisplayedTransactionType, @JsonProperty(value="defaultDisplayedPercentiles") @Nullable ImmutableList<Double> defaultDisplayedPercentiles, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = TransactionConfigDto.builder();
        if (slowThresholdMillis != null) {
            builder.slowThresholdMillis(slowThresholdMillis);
        }
        if (profilingIntervalMillis != null) {
            builder.profilingIntervalMillis(profilingIntervalMillis);
        }
        if (defaultDisplayedTransactionType != null) {
            builder.defaultDisplayedTransactionType(defaultDisplayedTransactionType);
        }
        if (defaultDisplayedPercentiles != null) {
            builder.addAllDefaultDisplayedPercentiles(defaultDisplayedPercentiles);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static TransactionConfigDto copyOf(ConfigJsonService.TransactionConfigDtoBase instance) {
        if (instance instanceof TransactionConfigDto) {
            return (TransactionConfigDto)instance;
        }
        return TransactionConfigDto.builder().slowThresholdMillis(instance.slowThresholdMillis()).profilingIntervalMillis(instance.profilingIntervalMillis()).defaultDisplayedTransactionType(instance.defaultDisplayedTransactionType()).addAllDefaultDisplayedPercentiles(instance.defaultDisplayedPercentiles()).version(instance.version()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 15L;
        private static final long INITIALIZED_BIT_SLOW_THRESHOLD_MILLIS = 1L;
        private static final long INITIALIZED_BIT_PROFILING_INTERVAL_MILLIS = 2L;
        private static final long INITIALIZED_BIT_DEFAULT_DISPLAYED_TRANSACTION_TYPE = 4L;
        private static final long INITIALIZED_BIT_VERSION = 8L;
        private long initializedBitset;
        private int slowThresholdMillis;
        private int profilingIntervalMillis;
        @Nullable
        private String defaultDisplayedTransactionType;
        private ImmutableList.Builder<Double> defaultDisplayedPercentilesBuilder = ImmutableList.builder();
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder slowThresholdMillis(int slowThresholdMillis) {
            this.checkNotIsSet(this.slowThresholdMillisIsSet(), "slowThresholdMillis");
            this.slowThresholdMillis = slowThresholdMillis;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder profilingIntervalMillis(int profilingIntervalMillis) {
            this.checkNotIsSet(this.profilingIntervalMillisIsSet(), "profilingIntervalMillis");
            this.profilingIntervalMillis = profilingIntervalMillis;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder defaultDisplayedTransactionType(String defaultDisplayedTransactionType) {
            this.checkNotIsSet(this.defaultDisplayedTransactionTypeIsSet(), "defaultDisplayedTransactionType");
            this.defaultDisplayedTransactionType = Preconditions.checkNotNull(defaultDisplayedTransactionType);
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder addDefaultDisplayedPercentiles(double element) {
            this.defaultDisplayedPercentilesBuilder.add((Object)element);
            return this;
        }

        public final Builder addDefaultDisplayedPercentiles(double ... elements) {
            this.defaultDisplayedPercentilesBuilder.addAll(Doubles.asList(elements));
            return this;
        }

        public final Builder addAllDefaultDisplayedPercentiles(Iterable<Double> elements) {
            this.defaultDisplayedPercentilesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder version(String version) {
            this.checkNotIsSet(this.versionIsSet(), "version");
            this.version = Preconditions.checkNotNull(version);
            this.initializedBitset |= 8L;
            return this;
        }

        public TransactionConfigDto build() {
            this.checkRequiredAttributes();
            return new TransactionConfigDto(this.slowThresholdMillis, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, (ImmutableList)this.defaultDisplayedPercentilesBuilder.build(), this.version);
        }

        private boolean slowThresholdMillisIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean profilingIntervalMillisIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean defaultDisplayedTransactionTypeIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean versionIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of TransactionConfigDto is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 15L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.slowThresholdMillisIsSet()) {
                attributes.add("slowThresholdMillis");
            }
            if (!this.profilingIntervalMillisIsSet()) {
                attributes.add("profilingIntervalMillis");
            }
            if (!this.defaultDisplayedTransactionTypeIsSet()) {
                attributes.add("defaultDisplayedTransactionType");
            }
            if (!this.versionIsSet()) {
                attributes.add("version");
            }
            return "Cannot build TransactionConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

