/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.plugin.api;

import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.glowroot.plugin.api.Logger;
import org.glowroot.plugin.api.config.ConfigService;
import org.glowroot.plugin.api.internal.NopConfigService;
import org.glowroot.plugin.api.internal.NopTransactionService;
import org.glowroot.plugin.api.internal.ServiceRegistry;
import org.glowroot.plugin.api.transaction.TransactionService;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class Agent {
    private static final org.glowroot.shaded.slf4j.Logger logger = LoggerFactory.getLogger(Agent.class);
    private static final TransactionService transactionService;
    @Nullable
    private static final ServiceRegistry serviceRegistry;

    private Agent() {
    }

    public static TransactionService getTransactionService() {
        return transactionService;
    }

    public static ConfigService getConfigService(String pluginId) {
        return serviceRegistry == null ? NopConfigService.INSTANCE : serviceRegistry.getConfigService(pluginId);
    }

    public static Logger getLogger(Class<?> clazz) {
        return new LoggerImpl(LoggerFactory.getLogger(clazz));
    }

    static {
        try {
            Class<?> registryClass = Class.forName("org.glowroot.transaction.ServiceRegistryImpl");
            Method getInstanceMethod = registryClass.getMethod("getInstance", new Class[0]);
            serviceRegistry = (ServiceRegistry)getInstanceMethod.invoke(null, new Object[0]);
            transactionService = serviceRegistry == null ? NopTransactionService.INSTANCE : serviceRegistry.getTransactionService();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new AssertionError((Object)e);
        }
    }

    @VisibleForTesting
    static class LoggerImpl
    implements Logger {
        private final org.glowroot.shaded.slf4j.Logger logger;

        @VisibleForTesting
        public LoggerImpl(org.glowroot.shaded.slf4j.Logger logger) {
            this.logger = logger;
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public void trace(@Nullable String msg) {
            this.logger.trace(msg);
        }

        @Override
        public void trace(@Nullable String format, @Nullable Object arg) {
            this.logger.trace(format, arg);
        }

        @Override
        public void trace(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.logger.trace(format, arg1, arg2);
        }

        @Override
        public void trace(@Nullable String format, Object ... arguments) {
            this.logger.trace(format, arguments);
        }

        @Override
        public void trace(@Nullable String msg, @Nullable Throwable t) {
            this.logger.trace(msg, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void debug(@Nullable String msg) {
            this.logger.debug(msg);
        }

        @Override
        public void debug(@Nullable String format, @Nullable Object arg) {
            this.logger.debug(format, arg);
        }

        @Override
        public void debug(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.logger.debug(format, arg1, arg2);
        }

        @Override
        public void debug(@Nullable String format, Object ... arguments) {
            this.logger.debug(format, arguments);
        }

        @Override
        public void debug(@Nullable String msg, @Nullable Throwable t) {
            this.logger.debug(msg, t);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public void info(@Nullable String msg) {
            this.logger.info(msg);
        }

        @Override
        public void info(@Nullable String format, @Nullable Object arg) {
            this.logger.info(format, arg);
        }

        @Override
        public void info(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.logger.info(format, arg1, arg2);
        }

        @Override
        public void info(@Nullable String format, Object ... arguments) {
            this.logger.info(format, arguments);
        }

        @Override
        public void info(@Nullable String msg, @Nullable Throwable t) {
            this.logger.info(msg, t);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public void warn(@Nullable String msg) {
            this.logger.warn(msg);
        }

        @Override
        public void warn(@Nullable String format, @Nullable Object arg) {
            this.logger.warn(format, arg);
        }

        @Override
        public void warn(@Nullable String format, Object ... arguments) {
            this.logger.warn(format, arguments);
        }

        @Override
        public void warn(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.logger.warn(format, arg1, arg2);
        }

        @Override
        public void warn(@Nullable String msg, @Nullable Throwable t) {
            this.logger.warn(msg, t);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public void error(@Nullable String msg) {
            this.logger.error(msg);
        }

        @Override
        public void error(@Nullable String format, @Nullable Object arg) {
            this.logger.error(format, arg);
        }

        @Override
        public void error(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.logger.error(format, arg1, arg2);
        }

        @Override
        public void error(@Nullable String format, Object ... arguments) {
            this.logger.error(format, arguments);
        }

        @Override
        public void error(@Nullable String msg, @Nullable Throwable t) {
            this.logger.error(msg, t);
        }
    }
}

