/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.fasterxml.jackson.datatype.guava;

import org.glowroot.shaded.fasterxml.jackson.databind.BeanDescription;
import org.glowroot.shaded.fasterxml.jackson.databind.DeserializationConfig;
import org.glowroot.shaded.fasterxml.jackson.databind.JavaType;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.glowroot.shaded.fasterxml.jackson.databind.KeyDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.deser.Deserializers;
import org.glowroot.shaded.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.type.CollectionType;
import org.glowroot.shaded.fasterxml.jackson.databind.type.MapLikeType;
import org.glowroot.shaded.fasterxml.jackson.databind.type.MapType;
import org.glowroot.shaded.fasterxml.jackson.databind.type.TypeFactory;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.GuavaOptionalDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.HashCodeDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.HashMultisetDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.HostAndPortDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.ImmutableBiMapDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.ImmutableListDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.ImmutableMapDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.ImmutableMultisetDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.ImmutableSetDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.ImmutableSortedMapDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.ImmutableSortedMultisetDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.ImmutableSortedSetDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.InternetDomainNameDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.LinkedHashMultisetDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.RangeDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.TreeMultisetDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.multimap.list.ArrayListMultimapDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.multimap.list.LinkedListMultimapDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.multimap.set.HashMultimapDeserializer;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.multimap.set.LinkedHashMultimapDeserializer;
import org.glowroot.shaded.google.common.base.Optional;
import org.glowroot.shaded.google.common.collect.ArrayListMultimap;
import org.glowroot.shaded.google.common.collect.BiMap;
import org.glowroot.shaded.google.common.collect.EnumBiMap;
import org.glowroot.shaded.google.common.collect.EnumHashBiMap;
import org.glowroot.shaded.google.common.collect.EnumMultiset;
import org.glowroot.shaded.google.common.collect.ForwardingListMultimap;
import org.glowroot.shaded.google.common.collect.ForwardingSetMultimap;
import org.glowroot.shaded.google.common.collect.ForwardingSortedSetMultimap;
import org.glowroot.shaded.google.common.collect.HashBiMap;
import org.glowroot.shaded.google.common.collect.HashMultimap;
import org.glowroot.shaded.google.common.collect.HashMultiset;
import org.glowroot.shaded.google.common.collect.ImmutableBiMap;
import org.glowroot.shaded.google.common.collect.ImmutableCollection;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableListMultimap;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.ImmutableMultiset;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.collect.ImmutableSetMultimap;
import org.glowroot.shaded.google.common.collect.ImmutableSortedMap;
import org.glowroot.shaded.google.common.collect.ImmutableSortedMultiset;
import org.glowroot.shaded.google.common.collect.ImmutableSortedSet;
import org.glowroot.shaded.google.common.collect.LinkedHashMultimap;
import org.glowroot.shaded.google.common.collect.LinkedHashMultiset;
import org.glowroot.shaded.google.common.collect.LinkedListMultimap;
import org.glowroot.shaded.google.common.collect.ListMultimap;
import org.glowroot.shaded.google.common.collect.Multimap;
import org.glowroot.shaded.google.common.collect.Multiset;
import org.glowroot.shaded.google.common.collect.Range;
import org.glowroot.shaded.google.common.collect.SetMultimap;
import org.glowroot.shaded.google.common.collect.SortedMultiset;
import org.glowroot.shaded.google.common.collect.SortedSetMultimap;
import org.glowroot.shaded.google.common.collect.Table;
import org.glowroot.shaded.google.common.collect.TreeMultimap;
import org.glowroot.shaded.google.common.collect.TreeMultiset;
import org.glowroot.shaded.google.common.hash.HashCode;
import org.glowroot.shaded.google.common.net.HostAndPort;
import org.glowroot.shaded.google.common.net.InternetDomainName;

public class GuavaDeserializers
extends Deserializers.Base {
    @Override
    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (ImmutableCollection.class.isAssignableFrom(raw)) {
            if (ImmutableList.class.isAssignableFrom(raw)) {
                return new ImmutableListDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (ImmutableMultiset.class.isAssignableFrom(raw)) {
                if (ImmutableSortedMultiset.class.isAssignableFrom(raw)) {
                    this.requireCollectionOfComparableElements(type, "ImmutableSortedMultiset");
                    return new ImmutableSortedMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
                }
                return new ImmutableMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (ImmutableSet.class.isAssignableFrom(raw)) {
                if (ImmutableSortedSet.class.isAssignableFrom(raw)) {
                    this.requireCollectionOfComparableElements(type, "ImmutableSortedSet");
                    return new ImmutableSortedSetDeserializer(type, elementTypeDeserializer, elementDeserializer);
                }
                return new ImmutableSetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            return new ImmutableListDeserializer(type, elementTypeDeserializer, elementDeserializer);
        }
        if (Multiset.class.isAssignableFrom(raw)) {
            if (SortedMultiset.class.isAssignableFrom(raw)) {
                if (TreeMultiset.class.isAssignableFrom(raw)) {
                    return new TreeMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
                }
                return new TreeMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (LinkedHashMultiset.class.isAssignableFrom(raw)) {
                return new LinkedHashMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (HashMultiset.class.isAssignableFrom(raw)) {
                return new HashMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (EnumMultiset.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new HashMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
        }
        return null;
    }

    private void requireCollectionOfComparableElements(CollectionType actualType, String targetType) {
        Class<?> elemType = actualType.getContentType().getRawClass();
        if (!Comparable.class.isAssignableFrom(elemType)) {
            throw new IllegalArgumentException("Can not handle " + targetType + " with elements that are not Comparable<?> (" + elemType.getName() + ")");
        }
    }

    @Override
    public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (ImmutableMap.class.isAssignableFrom(raw)) {
            if (ImmutableSortedMap.class.isAssignableFrom(raw)) {
                return new ImmutableSortedMapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (ImmutableBiMap.class.isAssignableFrom(raw)) {
                return new ImmutableBiMapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            return new ImmutableMapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (BiMap.class.isAssignableFrom(raw)) {
            if (EnumBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (EnumHashBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (HashBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (ListMultimap.class.isAssignableFrom(raw)) {
            if (ImmutableListMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (ArrayListMultimap.class.isAssignableFrom(raw)) {
                return new ArrayListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (LinkedListMultimap.class.isAssignableFrom(raw)) {
                return new LinkedListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (ForwardingListMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new ArrayListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (SetMultimap.class.isAssignableFrom(raw)) {
            if (SortedSetMultimap.class.isAssignableFrom(raw)) {
                if (TreeMultimap.class.isAssignableFrom(raw)) {
                    // empty if block
                }
                if (ForwardingSortedSetMultimap.class.isAssignableFrom(raw)) {
                    // empty if block
                }
            }
            if (ImmutableSetMultimap.class.isAssignableFrom(raw)) {
                return new LinkedHashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (HashMultimap.class.isAssignableFrom(raw)) {
                return new HashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (LinkedHashMultimap.class.isAssignableFrom(raw)) {
                return new LinkedHashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (ForwardingSetMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new HashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (Multimap.class.isAssignableFrom(raw)) {
            return new LinkedListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (Table.class.isAssignableFrom(raw)) {
            // empty if block
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (raw == Optional.class) {
            JavaType refType = type.containedType(0);
            if (refType == null) {
                refType = TypeFactory.unknownType();
            }
            JsonDeserializer valueDeser = (JsonDeserializer)type.getValueHandler();
            TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
            if (typeDeser == null) {
                typeDeser = config.findTypeDeserializer(refType);
            }
            return new GuavaOptionalDeserializer(type, refType, typeDeser, valueDeser);
        }
        if (raw == Range.class) {
            return new RangeDeserializer(type);
        }
        if (raw == HostAndPort.class) {
            return HostAndPortDeserializer.std;
        }
        if (raw == InternetDomainName.class) {
            return InternetDomainNameDeserializer.std;
        }
        if (raw == HashCode.class) {
            return HashCodeDeserializer.std;
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }
}

