/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser;

import java.io.IOException;
import org.glowroot.shaded.fasterxml.jackson.core.JsonParser;
import org.glowroot.shaded.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.shaded.fasterxml.jackson.core.JsonToken;
import org.glowroot.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.KeyDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.type.MapType;
import org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser.GuavaMapDeserializer;
import org.glowroot.shaded.google.common.collect.ImmutableMap;

abstract class GuavaImmutableMapDeserializer<T extends ImmutableMap<Object, Object>>
extends GuavaMapDeserializer<T> {
    GuavaImmutableMapDeserializer(MapType type, KeyDeserializer keyDeser, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        super(type, keyDeser, typeDeser, deser);
    }

    protected abstract ImmutableMap.Builder<Object, Object> createBuilder();

    @Override
    protected T _deserializeEntries(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        KeyDeserializer keyDes = this._keyDeserializer;
        JsonDeserializer valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._typeDeserializerForValue;
        ImmutableMap.Builder<Object, Object> builder = this.createBuilder();
        while (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
            String fieldName = jp.getCurrentName();
            String key = keyDes == null ? fieldName : keyDes.deserializeKey(fieldName, ctxt);
            JsonToken t = jp.nextToken();
            Object value = t == JsonToken.VALUE_NULL ? null : (typeDeser == null ? (Object)valueDes.deserialize(jp, ctxt) : valueDes.deserializeWithType(jp, ctxt, typeDeser));
            builder.put(key, value);
            jp.nextToken();
        }
        ImmutableMap<Object, Object> map = builder.build();
        return (T)map;
    }
}

