/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.fasterxml.jackson.datatype.guava.deser;

import java.io.IOException;
import org.glowroot.shaded.fasterxml.jackson.core.JsonParser;
import org.glowroot.shaded.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.shaded.fasterxml.jackson.core.JsonToken;
import org.glowroot.shaded.fasterxml.jackson.databind.BeanProperty;
import org.glowroot.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.shaded.fasterxml.jackson.databind.JavaType;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.glowroot.shaded.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.glowroot.shaded.google.common.base.Optional;

public class GuavaOptionalDeserializer
extends StdDeserializer<Optional<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _fullType;
    protected final JavaType _referenceType;
    protected final JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public GuavaOptionalDeserializer(JavaType fullType, JavaType refType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        super(fullType);
        this._fullType = fullType;
        this._referenceType = refType;
        this._valueTypeDeserializer = typeDeser;
        this._valueDeserializer = valueDeser;
    }

    @Override
    public JavaType getValueType() {
        return this._fullType;
    }

    @Override
    public Optional<?> getNullValue() {
        return Optional.absent();
    }

    protected GuavaOptionalDeserializer withResolved(TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        return new GuavaOptionalDeserializer(this._fullType, this._referenceType, typeDeser, valueDeser);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        deser = deser == null ? ctxt.findContextualValueDeserializer(this._referenceType, property) : ctxt.handleSecondaryContextualization(deser, property, this._fullType);
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        if (deser == this._valueDeserializer && typeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return this.withResolved(typeDeser, deser);
    }

    @Override
    public Optional<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object refd = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(jp, ctxt) : this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer);
        return Optional.fromNullable(refd);
    }

    @Override
    public Optional<?> deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return this.getNullValue();
        }
        if (t != null && t.isScalarValue()) {
            return this.deserialize(jp, ctxt);
        }
        return Optional.fromNullable(typeDeserializer.deserializeTypedFromAny(jp, ctxt));
    }
}

